/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.StringUtil;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    public static final String CATCH_ALL_WILDCARD = "*";
    public static final String WHITELIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.whitelist";
    public static final String BLACKLIST_PROPERTY = "org.apache.activemq.artemis.jms.deserialization.blacklist";
    private List<String> whiteList = new ArrayList<String>();
    private List<String> blackList = new ArrayList<String>();

    public ObjectInputStreamWithClassLoader(InputStream in) throws IOException {
        super(in);
        String whiteList = System.getProperty(WHITELIST_PROPERTY, null);
        this.setWhiteList(whiteList);
        String blackList = System.getProperty(BLACKLIST_PROPERTY, null);
        this.setBlackList(blackList);
    }

    public String getWhiteList() {
        return StringUtil.joinStringList(this.whiteList, ",");
    }

    public String getBlackList() {
        return StringUtil.joinStringList(this.blackList, ",");
    }

    public void setWhiteList(String whiteList) {
        this.whiteList = StringUtil.splitStringList(whiteList, ",");
    }

    public void setBlackList(String blackList) {
        this.blackList = StringUtil.splitStringList(blackList, ",");
    }

    protected Class resolveClass(final ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return this.resolveClass0(desc);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return ObjectInputStreamWithClassLoader.this.resolveClass0(desc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    protected Class resolveProxyClass(final String[] interfaces) throws IOException, ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return this.resolveProxyClass0(interfaces);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return ObjectInputStreamWithClassLoader.this.resolveProxyClass0(interfaces);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private Class resolveClass0(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(name, false, loader);
            if (clazz == null) {
                clazz = super.resolveClass(desc);
            }
            return this.checkSecurity(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.checkSecurity(super.resolveClass(desc));
        }
    }

    private Class resolveProxyClass0(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            Class<?> cl = Class.forName(interfaces[i2], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i2] = cl;
        }
        try {
            return this.checkSecurity(Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs));
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private RuntimeException unwrapException(PrivilegedActionException e) throws IOException, ClassNotFoundException {
        Throwable c = e.getCause();
        if (c instanceof IOException) {
            throw (IOException)c;
        }
        if (c instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)c;
        }
        if (c instanceof RuntimeException) {
            throw (RuntimeException)c;
        }
        if (c instanceof Error) {
            throw (Error)c;
        }
        throw new RuntimeException(c);
    }

    private Class<?> checkSecurity(Class<?> clazz) throws ClassNotFoundException {
        Class<?> target = clazz;
        while (target.isArray()) {
            target = target.getComponentType();
        }
        while (target.isAnonymousClass() || target.isLocalClass()) {
            target = target.getEnclosingClass();
        }
        if (!target.isPrimitive() && !this.isTrustedType(target)) {
            throw new ClassNotFoundException("Forbidden " + clazz + "! This class is not trusted to be deserialized under the current configuration. Please refer to the documentation for more information on how to configure trusted classes.");
        }
        return clazz;
    }

    private boolean isTrustedType(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        String className = clazz.getCanonicalName();
        if (className == null) {
            className = clazz.getName();
        }
        for (String blackListEntry : this.blackList) {
            if (CATCH_ALL_WILDCARD.equals(blackListEntry)) {
                return false;
            }
            if (!this.isClassOrPackageMatch(className, blackListEntry)) continue;
            return false;
        }
        for (String whiteListEntry : this.whiteList) {
            if (CATCH_ALL_WILDCARD.equals(whiteListEntry)) {
                return true;
            }
            if (!this.isClassOrPackageMatch(className, whiteListEntry)) continue;
            return true;
        }
        return this.whiteList.size() == 0;
    }

    private boolean isClassOrPackageMatch(String className, String listEntry) {
        if (className == null) {
            return false;
        }
        if (className.equals(listEntry)) {
            return true;
        }
        int entryLength = listEntry.length();
        return className.length() > entryLength && className.startsWith(listEntry) && '.' == className.charAt(entryLength);
    }
}

