/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.ref.WeakReference;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;

public class MemorySize {
    private static final int numberOfObjects = 10000;

    private static Object newObject(ObjectFactory factory) throws Exception {
        return factory.createObject();
    }

    public static boolean is64bitArch() {
        boolean is64bit = true;
        try {
            String arch = System.getProperty("os.arch");
            if (arch != null) {
                is64bit = arch.contains("64");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is64bit;
    }

    public static int calculateSize(ObjectFactory factory) throws Exception {
        int i2;
        Runtime runtime = Runtime.getRuntime();
        MemorySize.getMemorySize(runtime);
        MemorySize.newObject(factory);
        Object[] obj = new Object[20000];
        for (i2 = 0; i2 < 20000; ++i2) {
            obj[i2] = MemorySize.newObject(factory);
        }
        obj = new Object[20000];
        long heap1 = MemorySize.getMemorySize(runtime);
        long totalMemory1 = runtime.totalMemory();
        for (i2 = 0; i2 < 10000; ++i2) {
            obj[i2] = MemorySize.newObject(factory);
        }
        long heap2 = MemorySize.getMemorySize(runtime);
        long totalMemory2 = runtime.totalMemory();
        int size = Math.round((float)(heap2 - heap1) / 10000.0f);
        if (totalMemory1 != totalMemory2) {
            ActiveMQClientLogger.LOGGER.jvmAllocatedMoreMemory(totalMemory1, totalMemory2);
        }
        return size;
    }

    private static long getMemorySize(Runtime runtime) {
        for (int i2 = 0; i2 < 5; ++i2) {
            MemorySize.forceGC();
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private static void forceGC() {
        WeakReference<Object> dumbReference = new WeakReference<Object>(new Object());
        while (dumbReference.get() != null) {
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface ObjectFactory {
        public Object createObject();
    }
}

