/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class AutoCreateUtil {
    public static void autoCreateQueue(ClientSession session, SimpleString destAddress, SimpleString selectorString) throws ActiveMQException {
        ClientSession.AddressQuery response = session.addressQuery(destAddress);
        SimpleString queueName = AutoCreateUtil.getCoreQueueName(session, destAddress);
        if (!response.isExists() || !response.getQueueNames().contains(queueName)) {
            if (response.isAutoCreateQueues()) {
                try {
                    QueueConfiguration queueConfiguration = new QueueConfiguration(queueName).setAutoCreated(true).setAddress(destAddress);
                    AutoCreateUtil.setRequiredQueueConfigurationIfNotSet(queueConfiguration, response, RoutingType.ANYCAST, selectorString, true);
                    session.createQueue(queueConfiguration);
                    ActiveMQClientLogger.LOGGER.debug("The queue " + destAddress + " was created automatically");
                }
                catch (ActiveMQQueueExistsException activeMQQueueExistsException) {}
            } else {
                throw new ActiveMQException("Destination " + destAddress + " does not exist", ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST);
            }
        }
    }

    public static void setRequiredQueueConfigurationIfNotSet(QueueConfiguration queueConfiguration, ClientSession.AddressQuery addressQuery, RoutingType routingType, SimpleString filter2, boolean durable) {
        if (queueConfiguration.getRoutingType() == null) {
            queueConfiguration.setRoutingType(routingType);
        }
        if (queueConfiguration.getFilterString() == null) {
            queueConfiguration.setFilterString(filter2);
        }
        if (queueConfiguration.getMaxConsumers() == null) {
            queueConfiguration.setMaxConsumers(addressQuery.getDefaultMaxConsumers());
        }
        if (queueConfiguration.isPurgeOnNoConsumers() == null) {
            queueConfiguration.setPurgeOnNoConsumers(addressQuery.isDefaultPurgeOnNoConsumers());
        }
        queueConfiguration.setDurable(durable);
    }

    public static SimpleString getCoreQueueName(ClientSession session, SimpleString destAddress) {
        if (session.getVersion() < 130) {
            return destAddress;
        }
        return CompositeAddress.extractQueueName(destAddress);
    }
}

