/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class UDPServerLocatorSchema
extends AbstractServerLocatorSchema {
    public static List<String> IGNORED = new ArrayList<String>();

    @Override
    public String getSchemaName() {
        return "udp";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        DiscoveryGroupConfiguration dgc = UDPServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query2, this.getHost(uri), this.getPort(uri), name);
        BeanSupport.stripPasswords(query2);
        ConnectionOptions options = this.newConnectionOptions(uri, query2);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(dgc);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(dgc);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean2) throws Exception {
        DiscoveryGroupConfiguration dgc = bean2.getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory endpoint = (UDPBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        dgc.setBroadcastEndpointFactory(endpoint);
        String query2 = BeanSupport.getData(IGNORED, bean2, dgc, endpoint);
        return new URI("udp", null, endpoint.getGroupAddress(), endpoint.getGroupPort(), null, query2, null);
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(URI uri, Map<String, String> query2, String host, int port, String name) throws Exception {
        UDPBroadcastEndpointFactory endpointFactoryConfiguration = new UDPBroadcastEndpointFactory().setGroupAddress(host).setGroupPort(port);
        BeanSupport.setData(uri, endpointFactoryConfiguration, query2);
        DiscoveryGroupConfiguration dgc = BeanSupport.setData(uri, new DiscoveryGroupConfiguration(), query2).setName(name).setBroadcastEndpointFactory(endpointFactoryConfiguration);
        BeanSupport.setData(uri, dgc, query2);
        return dgc;
    }

    static {
        IGNORED.add("localBindAddress");
        IGNORED.add("localBindPort");
    }
}

