/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.schema.connector.InVMTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class InVMServerLocatorSchema
extends AbstractServerLocatorSchema {
    @Override
    public String getSchemaName() {
        return "vm";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        TransportConfiguration tc = InVMTransportConfigurationSchema.createTransportConfiguration(uri, query2, name, "org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory");
        ServerLocator factory = ActiveMQClient.createServerLocatorWithoutHA(tc);
        BeanSupport.stripPasswords(query2);
        return BeanSupport.setData(uri, factory, query2);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean2) throws Exception {
        return InVMServerLocatorSchema.getUri(bean2.getStaticTransportConfigurations());
    }

    public static URI getUri(TransportConfiguration[] configurations) throws URISyntaxException {
        String host = "0";
        if (configurations != null && configurations.length > 0) {
            TransportConfiguration configuration = configurations[0];
            Map<String, Object> params = configuration.getParams();
            host = params.get("serverId") == null ? host : params.get("serverId").toString();
        }
        return new URI("vm", null, host, -1, null, null, null);
    }
}

