/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.connector;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.uri.schema.connector.AbstractTransportConfigurationSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class TCPTransportConfigurationSchema
extends AbstractTransportConfigurationSchema {
    private final Set<String> allowableProperties;

    public TCPTransportConfigurationSchema(Set<String> allowableProperties) {
        this.allowableProperties = allowableProperties;
    }

    @Override
    public String getSchemaName() {
        return "tcp";
    }

    @Override
    protected List<TransportConfiguration> internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        return TCPTransportConfigurationSchema.getTransportConfigurations(uri, query2, this.allowableProperties, name, this.getFactoryName(uri));
    }

    @Override
    protected URI internalNewURI(List<TransportConfiguration> bean2) throws Exception {
        return null;
    }

    public static List<TransportConfiguration> getTransportConfigurations(URI uri, Map<String, String> query2, Set<String> allowableProperties, String name, String factoryName) throws URISyntaxException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        HashMap<String, Object> extraProps = new HashMap<String, Object>();
        BeanSupport.setData(uri, props, allowableProperties, query2, extraProps);
        ArrayList<TransportConfiguration> transportConfigurations = new ArrayList<TransportConfiguration>();
        TransportConfiguration config = new TransportConfiguration(factoryName, props, name, extraProps);
        transportConfigurations.add(config);
        String connectors = uri.getFragment();
        if (connectors != null && !connectors.trim().isEmpty()) {
            String[] split;
            for (String s2 : split = connectors.split(",")) {
                URI extraUri = new URI(s2);
                HashMap<String, Object> newProps = new HashMap<String, Object>();
                extraProps = new HashMap();
                BeanSupport.setData(extraUri, newProps, allowableProperties, query2, extraProps);
                BeanSupport.setData(extraUri, newProps, allowableProperties, TCPTransportConfigurationSchema.parseQuery(extraUri.getQuery(), null), extraProps);
                transportConfigurations.add(new TransportConfiguration(factoryName, newProps, name + ":" + extraUri.toString(), extraProps));
            }
        }
        return transportConfigurations;
    }

    protected String getFactoryName(URI uri) {
        if (uri.getPath() != null && uri.getPath().contains("hornetq")) {
            return "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory";
        }
        return NettyConnectorFactory.class.getName();
    }
}

