/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.connector.InVMTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.InVMServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class InVMSchema
extends AbstractCFSchema {
    @Override
    public String getSchemaName() {
        return "vm";
    }

    @Override
    protected ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query2);
        ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA(options.getFactoryTypeEnum(), InVMTransportConfigurationSchema.createTransportConfiguration(uri, query2, name, "org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory"));
        BeanSupport.setData(uri, factory, query2);
        BeanSupport.setData(uri, factory.getServerLocator(), query2);
        return factory;
    }

    @Override
    protected URI internalNewURI(ActiveMQConnectionFactory bean2) throws Exception {
        return InVMServerLocatorSchema.getUri(bean2.getStaticConnectors());
    }
}

