/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.filter.XPathExpression;
import org.xml.sax.InputSource;

public class JAXPXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    private final String xpathExpression;
    private final XPath xpath;
    private final DocumentBuilder builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXPXPathEvaluator(String xpathExpression, DocumentBuilder builder) {
        this.xpathExpression = xpathExpression;
        this.builder = builder;
        XPathFactory xPathFactory = FACTORY;
        synchronized (xPathFactory) {
            this.xpath = FACTORY.newXPath();
        }
    }

    @Override
    public boolean evaluate(Filterable m3) throws FilterException {
        String stringBody = m3.getBodyAs(String.class);
        if (stringBody != null) {
            return this.evaluate(stringBody);
        }
        return false;
    }

    protected boolean evaluate(String text) {
        return this.evaluate(new InputSource(new StringReader(text)));
    }

    protected boolean evaluate(InputSource inputSource) {
        try {
            return (Boolean)this.xpath.evaluate(this.xpathExpression, this.builder.parse(inputSource), XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.xpathExpression;
    }
}

