/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.activemq.artemis.jndi.JNDIStorable;

public class JNDIReferenceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment2) throws Exception {
        JNDIStorable result = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            Class<?> theClass = JNDIReferenceFactory.loadClass(this, reference.getClassName());
            if (JNDIStorable.class.isAssignableFrom(theClass)) {
                JNDIStorable store = (JNDIStorable)theClass.newInstance();
                store.setProperties(JNDIReferenceFactory.getProperties(reference));
                result = store;
            }
        } else {
            throw new RuntimeException("Object " + object + " is not a reference");
        }
        return result;
    }

    public static Properties getProperties(Reference reference) {
        Properties properties = new Properties();
        Enumeration<RefAddr> iter2 = reference.getAll();
        while (iter2.hasMoreElements()) {
            StringRefAddr addr = (StringRefAddr)iter2.nextElement();
            properties.put(addr.getType(), addr.getContent() == null ? "" : addr.getContent());
        }
        return properties;
    }

    public static Reference createReference(String instanceClassName, JNDIStorable po) throws NamingException {
        Reference result = new Reference(instanceClassName, JNDIReferenceFactory.class.getName(), null);
        try {
            Properties props = po.getProperties();
            Enumeration<?> iter2 = props.propertyNames();
            while (iter2.hasMoreElements()) {
                String key = (String)iter2.nextElement();
                result.add(new StringRefAddr(key, props.getProperty(key)));
            }
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        return result;
    }

    public static Class<?> loadClass(Object thisObj, String className) throws ClassNotFoundException {
        ClassLoader loader = thisObj.getClass().getClassLoader();
        Class<?> theClass = loader != null ? loader.loadClass(className) : Class.forName(className);
        return theClass;
    }
}

