/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerBundle;

public class ActiveMQJMSServerBundle_$bundle
implements ActiveMQJMSServerBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQJMSServerBundle_$bundle INSTANCE = new ActiveMQJMSServerBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQJMSServerBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cfDoesntExist$str() {
        return "AMQ129000: Connection Factory {0} does not exist";
    }

    @Override
    public final ActiveMQInternalErrorException cfDoesntExist(String name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.cfDoesntExist$str(), name));
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String discoveryGroupDoesntExist$str() {
        return "AMQ129003: Discovery Group ''{0}'' does not exist on main config";
    }

    @Override
    public final ActiveMQIllegalStateException discoveryGroupDoesntExist(String name) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.discoveryGroupDoesntExist$str(), name));
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConnectorNameOnCF$str() {
        return "AMQ129004: No Connector name configured on create ConnectionFactory";
    }

    @Override
    public final ActiveMQIllegalStateException noConnectorNameOnCF() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.noConnectorNameOnCF$str(), new Object[0]));
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConnectorNameConfiguredOnCF$str() {
        return "AMQ129005: Connector ''{0}'' not found on the main configuration file";
    }

    @Override
    public final ActiveMQIllegalStateException noConnectorNameConfiguredOnCF(String name) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.noConnectorNameConfiguredOnCF$str(), name));
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cfBindingsExists$str() {
        return "AMQ129006: Binding {0} is already being used by another connection factory";
    }

    @Override
    public final ActiveMQAddressExistsException cfBindingsExists(String name) {
        ActiveMQAddressExistsException result = new ActiveMQAddressExistsException(this._formatMessage(this.cfBindingsExists$str(), name));
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorDecodingPassword$str() {
        return "AMQ129007: Error decoding password using codec instance";
    }

    @Override
    public final ActiveMQIllegalStateException errorDecodingPassword(Exception e) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.errorDecodingPassword$str(), new Object[0]));
        result.initCause(e);
        ActiveMQJMSServerBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

