/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge.impl;

import javax.management.StandardMBean;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.apache.activemq.artemis.jms.bridge.JMSBridgeControl;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;

public class JMSBridgeControlImpl
extends StandardMBean
implements JMSBridgeControl {
    private final JMSBridge bridge;

    public JMSBridgeControlImpl(JMSBridge bridge) throws Exception {
        super(JMSBridgeControl.class);
        this.bridge = bridge;
    }

    @Override
    public void pause() throws Exception {
        this.bridge.pause();
    }

    @Override
    public void resume() throws Exception {
        this.bridge.resume();
    }

    @Override
    public boolean isStarted() {
        return this.bridge.isStarted();
    }

    @Override
    public void start() throws Exception {
        this.bridge.start();
    }

    @Override
    public void stop() throws Exception {
        this.bridge.stop();
    }

    @Override
    public String getClientID() {
        return this.bridge.getClientID();
    }

    @Override
    public long getFailureRetryInterval() {
        return this.bridge.getFailureRetryInterval();
    }

    @Override
    public int getMaxBatchSize() {
        return this.bridge.getMaxBatchSize();
    }

    @Override
    public long getMaxBatchTime() {
        return this.bridge.getMaxBatchTime();
    }

    @Override
    public int getMaxRetries() {
        return this.bridge.getMaxRetries();
    }

    @Override
    public String getQualityOfServiceMode() {
        QualityOfServiceMode mode = this.bridge.getQualityOfServiceMode();
        if (mode != null) {
            return mode.name();
        }
        return null;
    }

    @Override
    public String getSelector() {
        return this.bridge.getSelector();
    }

    @Override
    public String getSourcePassword() {
        return this.bridge.getSourcePassword();
    }

    @Override
    public String getSourceUsername() {
        return this.bridge.getSourceUsername();
    }

    @Override
    public String getSubscriptionName() {
        return this.bridge.getSubscriptionName();
    }

    @Override
    public String getTargetPassword() {
        return this.bridge.getTargetPassword();
    }

    @Override
    public String getTargetUsername() {
        return this.bridge.getTargetUsername();
    }

    @Override
    public boolean isAddMessageIDInHeader() {
        return this.bridge.isAddMessageIDInHeader();
    }

    @Override
    public boolean isFailed() {
        return this.bridge.isFailed();
    }

    @Override
    public boolean isPaused() {
        return this.bridge.isPaused();
    }

    @Override
    public void setAddMessageIDInHeader(boolean value) {
        this.bridge.setAddMessageIDInHeader(value);
    }

    @Override
    public void setClientID(String clientID) {
        this.bridge.setClientID(clientID);
    }

    @Override
    public void setFailureRetryInterval(long interval) {
        this.bridge.setFailureRetryInterval(interval);
    }

    @Override
    public void setMaxBatchSize(int size) {
        this.bridge.setMaxBatchSize(size);
    }

    @Override
    public void setMaxBatchTime(long time) {
        this.bridge.setMaxBatchTime(time);
    }

    @Override
    public void setMaxRetries(int retries) {
        this.bridge.setMaxRetries(retries);
    }

    @Override
    public void setQualityOfServiceMode(String mode) {
        if (mode != null) {
            this.bridge.setQualityOfServiceMode(QualityOfServiceMode.valueOf(mode));
        }
    }

    @Override
    public void setSelector(String selector) {
        this.bridge.setSelector(selector);
    }

    @Override
    public void setSourcePassword(String pwd2) {
        this.bridge.setSourcePassword(pwd2);
    }

    @Override
    public void setSourceUsername(String name) {
        this.bridge.setSourceUsername(name);
    }

    @Override
    public void setSubscriptionName(String subname) {
        this.bridge.setSubscriptionName(subname);
    }

    @Override
    public void setTargetPassword(String pwd2) {
        this.bridge.setTargetPassword(pwd2);
    }

    @Override
    public void setTargetUsername(String name) {
        this.bridge.setTargetUsername(name);
    }
}

