/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQShutdownException;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalLoaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalReaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalRecord;
import org.apache.activemq.artemis.jdbc.store.journal.TransactionHolder;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.jboss.logging.Logger;

public class JDBCJournalImpl
extends AbstractJDBCDriver
implements Journal {
    private static final Logger logger = Logger.getLogger(JDBCJournalImpl.class);
    private long syncDelay;
    private static int USER_VERSION = 1;
    private final List<JDBCJournalRecord> records;
    private String insertJournalRecords;
    private String selectJournalRecords;
    private String countJournalRecords;
    private String deleteJournalRecords;
    private String deleteJournalTxRecords;
    private boolean started;
    private AtomicBoolean failed = new AtomicBoolean(false);
    private JDBCJournalSync syncTimer;
    private final Executor completeExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private Map<Long, TransactionHolder> transactions = new ConcurrentHashMap<Long, TransactionHolder>();
    private final AtomicLong seq = new AtomicLong(0L);
    private final IOCriticalErrorListener criticalIOErrorListener;

    @Override
    public void setRemoveExtraFilesOnLoad(boolean removeExtraFilesOnLoad) {
    }

    @Override
    public boolean isRemoveExtraFilesOnLoad() {
        return false;
    }

    public JDBCJournalImpl(JDBCConnectionProvider connectionProvider, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, Executor completeExecutor, IOCriticalErrorListener criticalIOErrorListener, long syncDelay) {
        super(connectionProvider, provider);
        this.records = new ArrayList<JDBCJournalRecord>();
        this.scheduledExecutorService = scheduledExecutorService;
        this.completeExecutor = completeExecutor;
        this.criticalIOErrorListener = criticalIOErrorListener;
        this.syncDelay = syncDelay;
    }

    @Override
    public void appendAddEvent(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
    }

    @Override
    public void start() throws SQLException {
        super.start();
        this.syncTimer = new JDBCJournalSync(this.scheduledExecutorService, this.completeExecutor, this.syncDelay, TimeUnit.MILLISECONDS, this);
        this.started = true;
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public long getMaxRecordSize() {
        return this.sqlProvider.getMaxBlobSize();
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateJournalTableSQL());
    }

    @Override
    protected void prepareStatements() {
        logger.tracef("preparing statements", new Object[0]);
        this.insertJournalRecords = this.sqlProvider.getInsertJournalRecordsSQL();
        this.selectJournalRecords = this.sqlProvider.getSelectJournalRecordsSQL();
        this.countJournalRecords = this.sqlProvider.getCountJournalRecordsSQL();
        this.deleteJournalRecords = this.sqlProvider.getDeleteJournalRecordsSQL();
        this.deleteJournalTxRecords = this.sqlProvider.getDeleteJournalTxRecordsSQL();
    }

    @Override
    public void stop() throws SQLException {
        this.stop(true);
    }

    public synchronized void stop(boolean sync) throws SQLException {
        if (this.started) {
            if (sync) {
                this.sync();
            }
            this.started = false;
            super.stop();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        super.destroy();
        this.stop();
    }

    /*
     * Exception decompiling
     */
    public synchronized int sync() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void handleException(List<JDBCJournalRecord> recordRef, Throwable e) {
        logger.warn((Object)e.getMessage(), e);
        this.failed.set(true);
        this.criticalIOErrorListener.onIOException(e, "Critical IO Error.  Failed to process JDBC Record statements", null);
        if (logger.isTraceEnabled()) {
            logger.trace("Rolling back Transaction, just in case");
        }
        if (recordRef != null) {
            this.executeCallbacks(recordRef, false);
        }
    }

    private synchronized boolean cleanupTxRecords(List<Long> deletedRecords, List<Long> committedTx, PreparedStatement deleteJournalTxRecords) throws SQLException {
        ArrayList<TransactionHolder> iterableCopyTx = new ArrayList<TransactionHolder>();
        iterableCopyTx.addAll(this.transactions.values());
        for (Long txId : committedTx) {
            this.transactions.get((Object)txId).committed = true;
        }
        boolean hasDeletedJournalTxRecords = false;
        for (TransactionHolder h2 : iterableCopyTx) {
            ArrayList<RecordInfo> iterableCopy = new ArrayList<RecordInfo>();
            iterableCopy.addAll(h2.recordInfos);
            for (RecordInfo info : iterableCopy) {
                if (!deletedRecords.contains(info.id)) continue;
                h2.recordInfos.remove(info);
            }
            if (!h2.recordInfos.isEmpty() || !h2.committed) continue;
            deleteJournalTxRecords.setLong(1, h2.transactionID);
            deleteJournalTxRecords.addBatch();
            hasDeletedJournalTxRecords = true;
            this.transactions.remove(h2.transactionID);
        }
        return hasDeletedJournalTxRecords;
    }

    private void executeCallbacks(final List<JDBCJournalRecord> records, final boolean success) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (JDBCJournalRecord record : records) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Calling callback " + record + " with success = " + success);
                    }
                    record.complete(success);
                }
            }
        };
        this.completeExecutor.execute(r);
    }

    private void checkStatus() throws Exception {
        this.checkStatus(null);
    }

    private void checkStatus(IOCompletion callback) throws Exception {
        if (!this.started) {
            if (callback != null) {
                callback.onError(-1, "JDBC Journal is not loaded");
            }
            throw new ActiveMQShutdownException("JDBCJournal is not loaded");
        }
        if (this.failed.get()) {
            if (callback != null) {
                callback.onError(-1, "JDBC Journal failed");
            }
            throw new ActiveMQException("JDBCJournal Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRecord(JDBCJournalRecord record) throws Exception {
        this.checkStatus();
        if (logger.isTraceEnabled()) {
            logger.trace("appendRecord " + record);
        }
        record.storeLineUp();
        if (!this.started && record.getIoCompletion() != null) {
            record.getIoCompletion().onError(ActiveMQExceptionType.IO_ERROR.getCode(), "JDBC Journal not started");
        }
        SimpleWaitIOCallback callback = null;
        if (record.isSync() && record.getIoCompletion() == null) {
            callback = new SimpleWaitIOCallback();
            record.setIoCompletion(callback);
        }
        JDBCJournalImpl jDBCJournalImpl = this;
        synchronized (jDBCJournalImpl) {
            if (record.isTransactional() || record.getRecordType() == 17) {
                this.addTxRecord(record);
            }
            List<JDBCJournalRecord> list = this.records;
            synchronized (list) {
                this.records.add(record);
            }
        }
        this.syncTimer.delay();
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    private synchronized void addTxRecord(JDBCJournalRecord record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("addTxRecord " + record + ", started=" + this.started + ", failed=" + this.failed);
        }
        this.checkStatus();
        TransactionHolder txHolder = this.transactions.get(record.getTxId());
        if (txHolder == null) {
            txHolder = new TransactionHolder(record.getTxId());
            this.transactions.put(record.getTxId(), txHolder);
        }
        if (record.isTransactional()) {
            RecordInfo info = new RecordInfo(record.getId(), record.getRecordType(), new byte[0], record.isUpdate(), false, record.getCompactCount());
            if (record.getRecordType() == 15) {
                txHolder.recordsToDelete.add(info);
            } else {
                txHolder.recordInfos.add(info);
            }
        } else {
            txHolder.prepared = true;
        }
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendAddRecord bytes[] " + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendAddRecord (encoding) " + r + " with record = " + record);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendAddRecord (completionCallback & encoding) " + r + " with record = " + record);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendUpdateRecord (bytes)) " + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, byte[] record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceableRecord) throws Exception {
        this.appendUpdateRecord(id, recordType, record, sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendUpdateRecord (encoding)) " + r + " with record " + record);
        }
        this.appendRecord(r);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceableUpdate) throws Exception {
        this.appendUpdateRecord(id, recordType, persister, record, sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendUpdateRecord (encoding & completioncallback)) " + r + " with record " + record);
        }
        this.appendRecord(r);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        this.appendUpdateRecord(id, recordType, persister, record, sync, completionCallback);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendDeleteRecord id=" + id + " sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void tryAppendDeleteRecord(long id, JournalUpdateCallback updateCallback, boolean sync) throws Exception {
        this.appendDeleteRecord(id, sync);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendDeleteRecord id=" + id + " sync=" + sync + " with completionCallback");
        }
        this.appendRecord(r);
    }

    @Override
    public void tryAppendDeleteRecord(long id, boolean sync, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        this.appendDeleteRecord(id, sync, completionCallback);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
        if (logger.isTraceEnabled()) {
            logger.trace("appendAddRecordTransactional txID=" + txID + " id=" + id + " using bytes[] r=" + r);
        }
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendAddRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendUpdateRecordTransactional txID=" + txID + " id=" + id + " using bytes and r=" + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendUpdateRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord(record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendDeleteRecordTransactional txID=" + txID + " id=" + id + " using bytes and r=" + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord(EncoderPersister.getInstance(), record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendDeleteRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace("appendDeleteRecordTransactional txID=" + txID + " id=" + id);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendCommitRecord txID=" + txID + " sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendCommitRecord txID=" + txID + " callback=" + callback);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setStoreLineUp(lineUpContext);
        r.setIoCompletion(callback);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendCommitRecord txID=" + txID + " using callback, lineup=" + lineUpContext);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendPrepareRecord txID=" + txID + " using sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setTxData(transactionData);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendPrepareRecord txID=" + txID + " using callback, sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendPrepareRecord txID=" + txID + " transactionData, sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace("appendRollbackRecord txID=" + txID + " sync=" + sync);
        }
        this.appendRecord(r);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace("appendRollbackRecord txID=" + txID + " sync=" + sync + " using callback");
        }
        this.appendRecord(r);
    }

    @Override
    public synchronized JournalLoadInformation load(LoaderCallback reloadManager) {
        JournalLoadInformation jli = new JournalLoadInformation();
        JDBCJournalReaderCallback jrc = new JDBCJournalReaderCallback(reloadManager);
        try (Connection connection = this.connectionProvider.getConnection();
             PreparedStatement selectJournalRecords = connection.prepareStatement(this.selectJournalRecords);
             ResultSet rs = selectJournalRecords.executeQuery();){
            int noRecords = 0;
            while (rs.next()) {
                JDBCJournalRecord r = JDBCJournalRecord.readRecord(rs);
                switch (r.getRecordType()) {
                    case 11: {
                        jrc.onReadAddRecord(r.toRecordInfo());
                        break;
                    }
                    case 12: {
                        jrc.onReadUpdateRecord(r.toRecordInfo());
                        break;
                    }
                    case 16: {
                        jrc.onReadDeleteRecord(r.getId());
                        break;
                    }
                    case 13: {
                        jrc.onReadAddRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 14: {
                        jrc.onReadUpdateRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 15: {
                        jrc.onReadDeleteRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 17: {
                        jrc.onReadPrepareRecord(r.getTxId(), r.getTxDataAsByteArray(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 18: {
                        jrc.onReadCommitRecord(r.getTxId(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 19: {
                        jrc.onReadRollbackRecord(r.getTxId());
                        break;
                    }
                    default: {
                        throw new Exception("Error Reading Journal, Unknown Record Type: " + r.getRecordType());
                    }
                }
                ++noRecords;
                if (r.getSeq() <= this.seq.longValue()) continue;
                this.seq.set(r.getSeq());
            }
            jrc.checkPreparedTx();
            jli.setMaxID(((JDBCJournalLoaderCallback)reloadManager).getMaxId());
            jli.setNumberOfRecords(noRecords);
            this.transactions = jrc.getTransactions();
        }
        catch (Throwable e) {
            this.handleException(null, e);
        }
        return jli;
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        return null;
    }

    @Override
    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return null;
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        callback.storeLineUp();
    }

    @Override
    public synchronized JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        ArrayList<RecordInfo> records = new ArrayList<RecordInfo>();
        JournalLoadInformation journalLoadInformation = this.load(records, preparedTransactions, failureCallback, fixBadTX);
        records.forEach(committedRecords::add);
        return journalLoadInformation;
    }

    @Override
    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        JDBCJournalLoaderCallback lc = new JDBCJournalLoaderCallback(committedRecords, preparedTransactions, failureCallback, fixBadTX);
        return this.load(lc);
    }

    @Override
    public int getAlignment() throws Exception {
        return 0;
    }

    @Override
    public int getNumberOfRecords() {
        int count = 0;
        try (Connection connection = this.connectionProvider.getConnection();
             PreparedStatement countJournalRecords = connection.prepareStatement(this.countJournalRecords);
             ResultSet rs = countJournalRecords.executeQuery();){
            rs.next();
            count = rs.getInt(1);
        }
        catch (SQLException e) {
            logger.warn((Object)e.getMessage(), e);
            return -1;
        }
        return count;
    }

    @Override
    public int getUserVersion() {
        return USER_VERSION;
    }

    @Override
    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        return null;
    }

    @Override
    public final void synchronizationLock() {
        logger.error((Object)"Replication is not supported with JDBC Store", new Exception("trace"));
    }

    @Override
    public final void synchronizationUnlock() {
        logger.error((Object)"Replication is not supported with JDBC Store", new Exception("trace"));
    }

    @Override
    public void forceMoveNextFile() throws Exception {
    }

    @Override
    public JournalFile[] getDataFiles() {
        return new JournalFile[0];
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        return null;
    }

    @Override
    public int getFileSize() {
        return 0;
    }

    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
    }

    @Override
    public void replicationSyncFinished() {
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private static class JDBCJournalSync
    extends ActiveMQScheduledComponent {
        private final JDBCJournalImpl journal;

        JDBCJournalSync(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, JDBCJournalImpl journal) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, true);
            this.journal = journal;
        }

        @Override
        public void run() {
            if (this.journal.isStarted()) {
                this.journal.sync();
            }
        }
    }
}

