/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.commons.beanutils.PropertyUtils;

public class JDBCDataSourceUtils {
    public static DataSource getDataSource(String dataSourceClassName, Map<String, Object> dataSourceProperties) {
        ActiveMQJournalLogger.LOGGER.initializingJdbcDataSource(dataSourceClassName, dataSourceProperties.keySet().stream().map(key -> key + "=" + (key.equalsIgnoreCase("password") ? "****" : dataSourceProperties.get(key))).collect(Collectors.joining(", ", "{", "}")));
        try {
            DataSource dataSource = (DataSource)Class.forName(dataSourceClassName).newInstance();
            for (Map.Entry<String, Object> entry : dataSourceProperties.entrySet()) {
                PropertyUtils.setProperty(dataSource, entry.getKey(), entry.getValue());
            }
            return dataSource;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + dataSourceClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate DataSource", e);
        }
    }
}

