/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;

public class ConnectorServerFactory {
    private MBeanServer server;
    private String serviceUrl;
    private String rmiServerHost;
    private Map environment;
    private ObjectName objectName;
    private JMXConnectorServer connectorServer;
    private AuthenticatorType authenticatorType = AuthenticatorType.PASSWORD;
    private boolean secured;
    private String keyStoreProvider;
    private String keyStoreType;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStoreProvider;
    private String trustStoreType;
    private String trustStorePath;
    private String trustStorePassword;

    public void setkeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setkeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getRmiServerHost() {
        return this.rmiServerHost;
    }

    public void setRmiServerHost(String rmiServerHost) {
        this.rmiServerHost = rmiServerHost;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment2) {
        this.environment = environment2;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType.name().toLowerCase();
    }

    public void setAuthenticatorType(String value) {
        this.authenticatorType = AuthenticatorType.valueOf(value.toUpperCase());
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    private boolean isClientAuth() {
        return this.authenticatorType.equals((Object)AuthenticatorType.CERTIFICATE);
    }

    public void init() throws Exception {
        if (this.server == null) {
            throw new IllegalArgumentException("server must be set");
        }
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
        this.setupArtemisRMIServerSocketFactory();
        if (this.isClientAuth()) {
            this.secured = true;
        }
        if (this.secured) {
            this.setupSsl();
        }
        if (!AuthenticatorType.PASSWORD.equals((Object)this.authenticatorType)) {
            this.environment.remove("jmx.remote.authenticator");
        }
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, this.server);
        if (this.objectName != null) {
            this.server.registerMBean(this.connectorServer, this.objectName);
        }
        try {
            this.connectorServer.start();
        }
        catch (Exception ex) {
            this.doUnregister(this.objectName);
            throw ex;
        }
    }

    public void destroy() throws Exception {
        try {
            if (this.connectorServer != null) {
                this.connectorServer.stop();
            }
        }
        finally {
            this.doUnregister(this.objectName);
        }
    }

    protected void doUnregister(ObjectName objectName) {
        try {
            if (this.objectName != null && this.server.isRegistered(objectName)) {
                this.server.unregisterMBean(objectName);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private void setupSsl() throws Exception {
        SSLContext context = new SSLSupport().setKeystoreProvider(this.keyStoreProvider).setKeystoreType(this.keyStoreType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.trustStoreProvider).setTruststoreType(this.trustStoreType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
        SSLServerSocketFactory sssf = context.getServerSocketFactory();
        ArtemisSslRMIServerSocketFactory rssf = new ArtemisSslRMIServerSocketFactory(sssf, this.isClientAuth(), this.rmiServerHost);
        SslRMIClientSocketFactory rcsf = new SslRMIClientSocketFactory();
        this.environment.put("jmx.remote.rmi.server.socket.factory", rssf);
        this.environment.put("jmx.remote.rmi.client.socket.factory", rcsf);
    }

    private void setupArtemisRMIServerSocketFactory() {
        ArtemisRMIServerSocketFactory rmiServerSocketFactory = new ArtemisRMIServerSocketFactory(this.getRmiServerHost());
        this.environment.put("jmx.remote.rmi.server.socket.factory", rmiServerSocketFactory);
    }

    private static class ArtemisRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private String rmiServerHost;

        ArtemisRMIServerSocketFactory(String rmiServerHost) {
            this.rmiServerHost = rmiServerHost;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            return serverSocket;
        }
    }

    private static class ArtemisSslRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private SSLServerSocketFactory sssf;
        private boolean clientAuth;
        private String rmiServerHost;

        ArtemisSslRMIServerSocketFactory(SSLServerSocketFactory sssf, boolean clientAuth, String rmiServerHost) {
            this.sssf = sssf;
            this.clientAuth = clientAuth;
            this.rmiServerHost = rmiServerHost;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.sssf.createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            ss.setNeedClientAuth(this.clientAuth);
            return ss;
        }
    }

    private static enum AuthenticatorType {
        NONE,
        PASSWORD,
        CERTIFICATE;

    }
}

