/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.utils.Preconditions;
import org.jboss.logging.Logger;

public class QueueMessageMetrics {
    private static final Logger logger = Logger.getLogger(QueueMessageMetrics.class);
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "messageCount");
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> DURABLE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "durableMessageCount");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "persistentSize");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> DURABLE_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "durablePersistentSize");
    private volatile int messageCount;
    private volatile long persistentSize;
    private volatile int durableMessageCount;
    private volatile long durablePersistentSize;
    private final Queue queue;
    private final String name;

    public QueueMessageMetrics(Queue queue, String name) {
        Preconditions.checkNotNull(queue);
        this.queue = queue;
        this.name = name;
    }

    public void incrementMetrics(MessageReference reference) {
        long size = this.getPersistentSize(reference);
        COUNT_UPDATER.incrementAndGet(this);
        if (logger.isDebugEnabled()) {
            logger.debugf("%s increment messageCount to %d: %s", (Object)this, (Object)this.messageCount, (Object)reference);
        }
        SIZE_UPDATER.addAndGet(this, size);
        if (this.queue.isDurable() && reference.isDurable()) {
            DURABLE_COUNT_UPDATER.incrementAndGet(this);
            DURABLE_SIZE_UPDATER.addAndGet(this, size);
        }
    }

    public void decrementMetrics(MessageReference reference) {
        long size = -this.getPersistentSize(reference);
        COUNT_UPDATER.decrementAndGet(this);
        if (logger.isDebugEnabled()) {
            logger.debugf("%s decrement messageCount to %d: %s", (Object)this, (Object)this.messageCount, (Object)reference);
        }
        SIZE_UPDATER.addAndGet(this, size);
        if (this.queue.isDurable() && reference.isDurable()) {
            DURABLE_COUNT_UPDATER.decrementAndGet(this);
            DURABLE_SIZE_UPDATER.addAndGet(this, size);
        }
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public long getPersistentSize() {
        return this.persistentSize;
    }

    public void setPersistentSize(long persistentSize) {
        this.persistentSize = persistentSize;
    }

    public int getDurableMessageCount() {
        return this.durableMessageCount;
    }

    public void setDurableMessageCount(int durableMessageCount) {
        this.durableMessageCount = durableMessageCount;
    }

    public long getDurablePersistentSize() {
        return this.durablePersistentSize;
    }

    public void setDurablePersistentSize(long durablePersistentSize) {
        this.durablePersistentSize = durablePersistentSize;
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }

    public String toString() {
        return "QueuePendingMessageMetrics[queue=" + this.queue.getName() + ", name=" + this.name + "]";
    }
}

