/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.jboss.logging.Logger;

public class FileStoreMonitor
extends ActiveMQScheduledComponent {
    private static final Logger logger = Logger.getLogger(FileStoreMonitor.class);
    private final Set<Callback> callbackList = new HashSet<Callback>();
    private final Set<FileStore> stores = new HashSet<FileStore>();
    private double maxUsage;
    private final Object monitorLock = new Object();
    private final IOCriticalErrorListener ioCriticalErrorListener;

    public FileStoreMonitor(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, double maxUsage, IOCriticalErrorListener ioCriticalErrorListener) {
        super(scheduledExecutorService, executor, checkPeriod, timeUnit, false);
        this.maxUsage = maxUsage;
        this.ioCriticalErrorListener = ioCriticalErrorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addCallback(Callback callback) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.callbackList.add(callback);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addStore(File file) throws IOException {
        Object object = this.monitorLock;
        synchronized (object) {
            if (file != null && file.exists()) {
                try {
                    this.addStore(Files.getFileStore(file.toPath()));
                }
                catch (IOException e) {
                    logger.error((Object)("Error getting file store for " + file.getAbsolutePath()), e);
                    throw e;
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addStore(FileStore store) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.stores.add(store);
            return this;
        }
    }

    @Override
    public void run() {
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object = this.monitorLock;
        synchronized (object) {
            boolean over = false;
            long usableSpace = 0L;
            long totalSpace = 0L;
            for (FileStore store : this.stores) {
                try {
                    usableSpace = store.getUsableSpace();
                    over = FileStoreMonitor.calculateUsage(usableSpace, totalSpace = this.getTotalSpace(store)) > this.maxUsage;
                    if (!over) continue;
                    break;
                }
                catch (IOException ioe) {
                    this.ioCriticalErrorListener.onIOException(ioe, "IO Error while calculating disk usage", null);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), e);
                }
            }
            for (Callback callback : this.callbackList) {
                callback.tick(usableSpace, totalSpace);
                if (over) {
                    callback.over(usableSpace, totalSpace);
                    continue;
                }
                callback.under(usableSpace, totalSpace);
            }
        }
    }

    public double getMaxUsage() {
        return this.maxUsage;
    }

    public FileStoreMonitor setMaxUsage(double maxUsage) {
        this.maxUsage = maxUsage;
        return this;
    }

    public static double calculateUsage(long usableSpace, long totalSpace) {
        if (totalSpace == 0L) {
            return 0.0;
        }
        return 1.0 - (double)usableSpace / (double)totalSpace;
    }

    private long getTotalSpace(FileStore store) throws IOException {
        long totalSpace = store.getTotalSpace();
        if (totalSpace < 0L) {
            totalSpace = Long.MAX_VALUE;
        }
        return totalSpace;
    }

    public static interface Callback {
        public void tick(long var1, long var3);

        public void over(long var1, long var3);

        public void under(long var1, long var3);
    }
}

