/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.queue;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class FederatedQueueConsumerKey
implements FederatedConsumerKey {
    private final SimpleString address;
    private final SimpleString queueName;
    private final RoutingType routingType;
    private final SimpleString queueFilterString;
    private final SimpleString filterString;
    private final SimpleString fqqn;
    private final int priority;

    FederatedQueueConsumerKey(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString queueFilterString, SimpleString filterString, int priority) {
        this.address = address;
        this.routingType = routingType;
        this.queueName = queueName;
        this.fqqn = CompositeAddress.toFullyQualified(address, queueName);
        this.filterString = filterString;
        this.queueFilterString = queueFilterString;
        this.priority = priority;
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public SimpleString getQueueFilterString() {
        return this.queueFilterString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString getFqqn() {
        return this.fqqn;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederatedQueueConsumerKey)) {
            return false;
        }
        FederatedQueueConsumerKey that = (FederatedQueueConsumerKey)o;
        return this.priority == that.priority && Objects.equals(this.address, that.address) && Objects.equals(this.queueName, that.queueName) && this.routingType == that.routingType && Objects.equals(this.queueFilterString, that.queueFilterString) && Objects.equals(this.filterString, that.filterString) && Objects.equals(this.fqqn, that.fqqn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.queueName, this.routingType, this.queueFilterString, this.filterString, this.fqqn, this.priority});
    }
}

