/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.FederatedQueueConsumer;
import org.apache.activemq.artemis.core.server.federation.FederatedQueueConsumerImpl;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.jboss.logging.Logger;

public abstract class FederatedAbstract
implements ActiveMQServerBasePlugin {
    private static final Logger logger = Logger.getLogger(FederatedAbstract.class);
    private static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();
    protected final Federation federation;
    protected ActiveMQServer server;
    protected FederationUpstream upstream;
    protected WildcardConfiguration wildcardConfiguration;
    protected final Map<FederatedConsumerKey, FederatedQueueConsumer> remoteQueueConsumers = new HashMap<FederatedConsumerKey, FederatedQueueConsumer>();
    private boolean started;

    public FederatedAbstract(Federation federation, ActiveMQServer server, FederationUpstream upstream) {
        this.federation = federation;
        this.server = server;
        this.upstream = upstream;
        this.wildcardConfiguration = server.getConfiguration().getWildcardConfiguration() == null ? DEFAULT_WILDCARD_CONFIGURATION : server.getConfiguration().getWildcardConfiguration();
    }

    @Override
    public void registered(ActiveMQServer server) {
        this.start();
    }

    @Override
    public void unregistered(ActiveMQServer server) {
        this.stop();
    }

    public synchronized void stop() {
        for (FederatedQueueConsumer remoteQueueConsumer : this.remoteQueueConsumers.values()) {
            remoteQueueConsumer.close();
        }
        this.remoteQueueConsumers.clear();
        this.started = false;
    }

    public synchronized void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected Transformer mergeTransformers(Transformer left, Transformer right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return m3 -> left.transform(right.transform(m3));
    }

    protected Transformer getTransformer(String transformerRef) {
        FederationTransformerConfiguration federationTransformerConfiguration;
        Transformer transformer = null;
        if (transformerRef != null && (federationTransformerConfiguration = this.federation.getConfig().getTransformerConfigurationMap().get(transformerRef)) != null) {
            transformer = this.server.getServiceRegistry().getFederationTransformer(federationTransformerConfiguration.getName(), federationTransformerConfiguration.getTransformerConfiguration());
        }
        return transformer;
    }

    public synchronized void createRemoteConsumer(FederatedConsumerKey key, Transformer transformer, FederatedQueueConsumerImpl.ClientSessionCallback callback) {
        if (this.started) {
            FederatedQueueConsumer remoteQueueConsumer = this.remoteQueueConsumers.get(key);
            if (remoteQueueConsumer == null) {
                if (this.server.hasBrokerFederationPlugins()) {
                    try {
                        this.server.callBrokerFederationPlugins(plugin -> plugin.beforeCreateFederatedQueueConsumer(key));
                    }
                    catch (ActiveMQException t) {
                        ActiveMQServerLogger.LOGGER.federationPluginExecutionError(t, "beforeCreateFederatedQueueConsumer");
                        throw new IllegalStateException(t.getMessage(), t.getCause());
                    }
                }
                remoteQueueConsumer = new FederatedQueueConsumerImpl(this.federation, this.server, transformer, key, this.upstream, callback);
                remoteQueueConsumer.start();
                this.remoteQueueConsumers.put(key, remoteQueueConsumer);
                if (this.server.hasBrokerFederationPlugins()) {
                    try {
                        FederatedQueueConsumer finalConsumer = remoteQueueConsumer;
                        this.server.callBrokerFederationPlugins(plugin -> plugin.afterCreateFederatedQueueConsumer(finalConsumer));
                    }
                    catch (ActiveMQException t) {
                        ActiveMQServerLogger.LOGGER.federationPluginExecutionError(t, "afterCreateFederatedQueueConsumer");
                        throw new IllegalStateException(t.getMessage(), t.getCause());
                    }
                }
            }
            remoteQueueConsumer.incrementCount();
        }
    }

    public synchronized void removeRemoteConsumer(FederatedConsumerKey key) {
        FederatedQueueConsumer remoteQueueConsumer = this.remoteQueueConsumers.get(key);
        if (remoteQueueConsumer != null) {
            if (this.server.hasBrokerFederationPlugins()) {
                try {
                    this.server.callBrokerFederationPlugins(plugin -> plugin.beforeCloseFederatedQueueConsumer(remoteQueueConsumer));
                }
                catch (ActiveMQException t) {
                    ActiveMQServerLogger.LOGGER.federationPluginExecutionError(t, "beforeCloseFederatedQueueConsumer");
                    throw new IllegalStateException(t.getMessage(), t.getCause());
                }
            }
            if (remoteQueueConsumer.decrementCount() <= 0) {
                remoteQueueConsumer.close();
                this.remoteQueueConsumers.remove(key);
            }
            if (this.server.hasBrokerFederationPlugins()) {
                try {
                    this.server.callBrokerFederationPlugins(plugin -> plugin.afterCloseFederatedQueueConsumer(remoteQueueConsumer));
                }
                catch (ActiveMQException t) {
                    ActiveMQServerLogger.LOGGER.federationPluginExecutionError(t, "afterCloseFederatedQueueConsumer");
                    throw new IllegalStateException(t.getMessage(), t.getCause());
                }
            }
        }
    }
}

