/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class BroadcastGroupImpl
implements BroadcastGroup,
Runnable {
    private static final Logger logger = Logger.getLogger(BroadcastGroupImpl.class);
    private final NodeManager nodeManager;
    private final String name;
    private final List<TransportConfiguration> connectors = new ArrayList<TransportConfiguration>();
    private boolean started;
    private final long broadCastPeriod;
    private final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> future;
    private boolean loggedBroadcastException = false;
    private final String uniqueID;
    private NotificationService notificationService;
    private BroadcastEndpoint endpoint;

    public BroadcastGroupImpl(NodeManager nodeManager, String name, long broadCastPeriod, ScheduledExecutorService scheduledExecutor, BroadcastEndpointFactory endpointFactory) throws Exception {
        this.nodeManager = nodeManager;
        this.name = name;
        this.scheduledExecutor = scheduledExecutor;
        this.broadCastPeriod = broadCastPeriod;
        this.endpoint = endpointFactory.createBroadcastEndpoint();
        this.uniqueID = UUIDGenerator.getInstance().generateStringUUID();
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.endpoint.openBroadcaster();
        this.started = true;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeManager.getNodeId().toString(), CoreNotificationType.BROADCAST_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        this.activate();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
        try {
            this.endpoint.close(true);
        }
        catch (Exception e1) {
            ActiveMQServerLogger.LOGGER.broadcastGroupClosed(e1);
        }
        this.started = false;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeManager.getNodeId().toString(), CoreNotificationType.BROADCAST_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.broadcastGroupClosed(e);
            }
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void addConnector(TransportConfiguration tcConfig) {
        this.connectors.add(tcConfig);
    }

    @Override
    public synchronized void removeConnector(TransportConfiguration tcConfig) {
        this.connectors.remove(tcConfig);
    }

    @Override
    public synchronized int size() {
        return this.connectors.size();
    }

    private synchronized void activate() {
        if (this.scheduledExecutor != null) {
            this.future = this.scheduledExecutor.scheduleWithFixedDelay(this, 0L, this.broadCastPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void broadcastConnectors() throws Exception {
        ActiveMQBuffer buff = ActiveMQBuffers.dynamicBuffer(4096);
        buff.writeString(this.nodeManager.getNodeId().toString());
        buff.writeString(this.uniqueID);
        buff.writeInt(this.connectors.size());
        for (TransportConfiguration tcConfig : this.connectors) {
            tcConfig.encode(buff);
        }
        byte[] data = new byte[buff.readableBytes()];
        buff.getBytes(buff.readerIndex(), data);
        this.endpoint.broadcast(data);
    }

    @Override
    public void run() {
        if (!this.started) {
            return;
        }
        try {
            this.broadcastConnectors();
            this.loggedBroadcastException = false;
        }
        catch (Exception e) {
            if (!this.loggedBroadcastException) {
                ActiveMQServerLogger.LOGGER.errorBroadcastingConnectorConfigs(e);
                this.loggedBroadcastException = true;
            }
            logger.debug((Object)"Failed to broadcast connector configs...again", e);
        }
    }
}

