/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import io.netty.channel.Channel;
import java.io.File;
import java.io.Serializable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.naming.NamingException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class ActiveMQServerLogger_$logger
extends DelegatingBasicLogger
implements ActiveMQServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ActiveMQServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptWhilstStoppingComponent(String componentClassName) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.interruptWhilstStoppingComponent$str(), (Object)componentClassName);
    }

    protected String interruptWhilstStoppingComponent$str() {
        return "AMQ223000: Received Interrupt Exception whilst waiting for component to shutdown: {0}";
    }

    @Override
    public final void ignoredQuorumVote(ServerConnectVote vote) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.ignoredQuorumVote$str(), (Object)vote);
    }

    protected String ignoredQuorumVote$str() {
        return "AMQ223001: Ignored quorum vote due to quorum reached or vote casted: {0}";
    }

    @Override
    public final void serverStarting(String type, Configuration configuration) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.serverStarting$str(), (Object)type, (Object)configuration);
    }

    protected String serverStarting$str() {
        return "AMQ221000: {0} Message Broker is starting with configuration {1}";
    }

    @Override
    public final void serverStarted(String fullVersion, String name, SimpleString nodeId, String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), fullVersion, name, nodeId, identity);
    }

    protected String serverStarted$str() {
        return "AMQ221001: Apache ActiveMQ Artemis Message Broker version {0} [{1}, nodeID={2}] {3}";
    }

    @Override
    public final void serverStopped(String version, SimpleString nodeId, String uptime) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.serverStopped$str(), (Object)version, (Object)nodeId, (Object)uptime);
    }

    protected String serverStopped$str() {
        return "AMQ221002: Apache ActiveMQ Artemis Message Broker version {0} [{1}] stopped, uptime {2}";
    }

    @Override
    public final void deployQueue(String queueName, String addressName, String routingType) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deployQueue$str(), (Object)queueName, (Object)addressName, (Object)routingType);
    }

    protected String deployQueue$str() {
        return "AMQ221003: Deploying {2} queue {0} on address {1}";
    }

    @Override
    public final void dumpServerInfo(String serverInfo) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.dumpServerInfo$str(), (Object)serverInfo);
    }

    protected String dumpServerInfo$str() {
        return "AMQ221004: {0}";
    }

    @Override
    public final void deletingPendingMessage(Pair<Long, Long> msgToDelete) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deletingPendingMessage$str(), (Object)msgToDelete);
    }

    protected String deletingPendingMessage$str() {
        return "AMQ221005: Deleting pending large message as it was not completed: {0}";
    }

    @Override
    public final void awaitingLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.awaitingLiveLock$str(), new Object[0]);
    }

    protected String awaitingLiveLock$str() {
        return "AMQ221006: Waiting to obtain live lock";
    }

    @Override
    public final void serverIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.serverIsLive0$str(), new Object[0]);
    }

    protected String serverIsLive0$str() {
        return "AMQ221007: Server is now live";
    }

    @Override
    public final void awaitFailBack() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.awaitFailBack$str(), new Object[0]);
    }

    protected String awaitFailBack$str() {
        return "AMQ221008: live server wants to restart, restarting server in backup";
    }

    @Override
    public final void backupServerStarted(String version, SimpleString nodeID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupServerStarted$str(), (Object)version, (Object)nodeID);
    }

    protected String backupServerStarted$str() {
        return "AMQ221109: Apache ActiveMQ Artemis Backup Server version {0} [{1}] started, waiting live to fail before it gets active";
    }

    @Override
    public final void backupServerIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupServerIsLive$str(), new Object[0]);
    }

    protected String backupServerIsLive$str() {
        return "AMQ221010: Backup Server is now live";
    }

    @Override
    public final void serverIsLive(String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.serverIsLive1$str(), (Object)identity);
    }

    protected String serverIsLive1$str() {
        return "AMQ221011: Server {0} is now live";
    }

    @Override
    public final void journalUseAIO() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalUseAIO$str(), new Object[0]);
    }

    protected String journalUseAIO$str() {
        return "AMQ221012: Using AIO Journal";
    }

    @Override
    public final void journalUseNIO() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalUseNIO$str(), new Object[0]);
    }

    protected String journalUseNIO$str() {
        return "AMQ221013: Using NIO Journal";
    }

    @Override
    public final void percentLoaded(Long percent) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.percentLoaded$str(), (Object)percent);
    }

    protected String percentLoaded$str() {
        return "AMQ221014: {0}% loaded";
    }

    @Override
    public final void journalCannotFindQueueReloading(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalCannotFindQueueReloading$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloading$str() {
        return "AMQ221015: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR, deleting record now";
    }

    @Override
    public final void journalCannotFindQueueReloadingPage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalCannotFindQueueReloadingPage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPage$str() {
        return "AMQ221016: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now";
    }

    @Override
    public final void journalCannotFindQueueReloadingPageCursor(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalCannotFindQueueReloadingPageCursor$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPageCursor$str() {
        return "AMQ221017: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now";
    }

    @Override
    public final void largeMessageWithNoRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.largeMessageWithNoRef$str(), (Object)messageID);
    }

    protected String largeMessageWithNoRef$str() {
        return "AMQ221018: Large message: {0} did not have any associated reference, file will be deleted";
    }

    @Override
    public final void journalUnreferencedMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalUnreferencedMessage$str(), (Object)messageID);
    }

    protected String journalUnreferencedMessage$str() {
        return "AMQ221019: Deleting unreferenced message id={0} from the journal";
    }

    @Override
    public final void startedAcceptor(String acceptorType, String host, Integer port, String enabledProtocols) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.startedAcceptor$str(), acceptorType, host, port, enabledProtocols);
    }

    protected String startedAcceptor$str() {
        return "AMQ221020: Started {0} Acceptor at {1}:{2,number,#} for protocols [{3}]";
    }

    @Override
    public final void errorRemovingConnection() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.errorRemovingConnection$str(), new Object[0]);
    }

    protected String errorRemovingConnection$str() {
        return "AMQ221021: failed to remove connection";
    }

    @Override
    public final void errorStartingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, this.errorStartingConnectorService$str(), (Object)name);
    }

    protected String errorStartingConnectorService$str() {
        return "AMQ221022: unable to start connector service: {0}";
    }

    @Override
    public final void errorStoppingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, this.errorStoppingConnectorService$str(), (Object)name);
    }

    protected String errorStoppingConnectorService$str() {
        return "AMQ221023: unable to stop connector service: {0}";
    }

    @Override
    public final void backupServerSynchronized(ActiveMQServerImpl server, String liveID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupServerSynchronized$str(), (Object)server, (Object)liveID);
    }

    protected String backupServerSynchronized$str() {
        return "AMQ221024: Backup server {0} is synchronized with live server, nodeID={1}.";
    }

    @Override
    public final void replicaSyncFile(SequentialFile jf, Long size) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.replicaSyncFile$str(), (Object)jf, (Object)size);
    }

    protected String replicaSyncFile$str() {
        return "AMQ221025: Replication: sending {0} (size={1}) to replica.";
    }

    @Override
    public final void bridgeNoBindings(SimpleString name, SimpleString forwardingAddress, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.bridgeNoBindings$str(), (Object)name, (Object)forwardingAddress, (Object)address);
    }

    protected String bridgeNoBindings$str() {
        return "AMQ221026: Bridge {0} connected to forwardingAddress={1}. {2} does not have any bindings. Messages will be ignored until a binding is created.";
    }

    @Override
    public final void bridgeConnected(BridgeImpl name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.bridgeConnected$str(), (Object)name);
    }

    protected String bridgeConnected$str() {
        return "AMQ221027: Bridge {0} is connected";
    }

    @Override
    public final void bridgeStopping() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.bridgeStopping$str(), new Object[0]);
    }

    protected String bridgeStopping$str() {
        return "AMQ221028: Bridge is stopping, will not retry";
    }

    @Override
    public final void bridgeStopped(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.bridgeStopped$str(), (Object)name);
    }

    protected String bridgeStopped$str() {
        return "AMQ221029: stopped bridge {0}";
    }

    @Override
    public final void bridgePaused(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.bridgePaused$str(), (Object)name);
    }

    protected String bridgePaused$str() {
        return "AMQ221030: paused bridge {0}";
    }

    @Override
    public final void backupAnnounced() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupAnnounced$str(), new Object[0]);
    }

    protected String backupAnnounced$str() {
        return "AMQ221031: backup announced";
    }

    @Override
    public final void waitingToBecomeBackup() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.waitingToBecomeBackup$str(), new Object[0]);
    }

    protected String waitingToBecomeBackup$str() {
        return "AMQ221032: Waiting to become backup node";
    }

    @Override
    public final void gotBackupLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.gotBackupLock$str(), new Object[0]);
    }

    protected String gotBackupLock$str() {
        return "AMQ221033: ** got backup lock";
    }

    @Override
    public final void waitingToObtainLiveLock(String timeoutMessage) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.waitingToObtainLiveLock$str(), (Object)timeoutMessage);
    }

    protected String waitingToObtainLiveLock$str() {
        return "AMQ221034: Waiting {0} to obtain live lock";
    }

    @Override
    public final void obtainedLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.obtainedLiveLock$str(), new Object[0]);
    }

    protected String obtainedLiveLock$str() {
        return "AMQ221035: Live Server Obtained live lock";
    }

    @Override
    public final void messageWithDuplicateID(Object duplicateProperty, SimpleString toAddress, SimpleString address, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.messageWithDuplicateID$str(), duplicateProperty, toAddress, address, simpleString);
    }

    protected String messageWithDuplicateID$str() {
        return "AMQ221036: Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored and message removed from {3}";
    }

    @Override
    public final void becomingLive(ActiveMQServer server) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.becomingLive$str(), (Object)server);
    }

    protected String becomingLive$str() {
        return "AMQ221037: {0} to become ''live''";
    }

    @Override
    public final void deprecatedConfigurationOption(String deprecatedOption) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deprecatedConfigurationOption$str(), (Object)deprecatedOption);
    }

    protected String deprecatedConfigurationOption$str() {
        return "AMQ221038: Configuration option ''{0}'' is deprecated. Consult the manual for details.";
    }

    @Override
    public final void restartingReplicatedBackupAfterFailback() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.restartingReplicatedBackupAfterFailback$str(), new Object[0]);
    }

    protected String restartingReplicatedBackupAfterFailback$str() {
        return "AMQ221039: Restarting as Replicating backup server after live restart";
    }

    @Override
    public final void remoteGroupCoordinatorsNotStarted() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.remoteGroupCoordinatorsNotStarted$str(), new Object[0]);
    }

    protected String remoteGroupCoordinatorsNotStarted$str() {
        return "AMQ221040: Remote group coordinators has not started.";
    }

    @Override
    public final void cantFindQueueOnPageComplete(long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.cantFindQueueOnPageComplete$str(), (Object)queueID);
    }

    protected String cantFindQueueOnPageComplete$str() {
        return "AMQ221041: Cannot find queue {0} while reloading PAGE_CURSOR_COMPLETE, deleting record now";
    }

    @Override
    public final void timedOutWaitingCompletions(String bridgeName, long numberOfMessages) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.timedOutWaitingCompletions$str(), (Object)bridgeName, (Object)numberOfMessages);
    }

    protected String timedOutWaitingCompletions$str() {
        return "AMQ221042: Bridge {0} timed out waiting for the completion of {1} messages, we will just shutdown the bridge after 10 seconds wait";
    }

    @Override
    public final void addingProtocolSupport(String protocolKey, String moduleName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.addingProtocolSupport$str(), (Object)protocolKey, (Object)moduleName);
    }

    protected String addingProtocolSupport$str() {
        return "AMQ221043: Protocol module found: [{1}]. Adding protocol support for: {0}";
    }

    @Override
    public final void switchingNIO() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.switchingNIO$str(), new Object[0]);
    }

    protected String switchingNIO$str() {
        return "AMQ221045: libaio is not available, switching the configuration into NIO";
    }

    @Override
    public final void unblockingMessageProduction(SimpleString addressName, long currentSize, long maxSize) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.unblockingMessageProduction$str(), (Object)addressName, (Object)currentSize, (Object)maxSize);
    }

    protected String unblockingMessageProduction$str() {
        return "AMQ221046: Unblocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}";
    }

    @Override
    public final void backupServerScaledDown() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupServerScaledDown$str(), new Object[0]);
    }

    protected String backupServerScaledDown$str() {
        return "AMQ221047: Backup Server has scaled down to live server";
    }

    @Override
    public final void slowConsumerDetected(String sessionID, long consumerID, String queueName, String remoteAddress, float slowConsumerThreshold, float consumerRate) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.slowConsumerDetected$str(), sessionID, consumerID, queueName, remoteAddress, Float.valueOf(slowConsumerThreshold), Float.valueOf(consumerRate));
    }

    protected String slowConsumerDetected$str() {
        return "AMQ221048: Consumer {0}:{1} attached to queue ''{2}'' from {3} identified as ''slow.'' Expected consumption rate: {4} msgs/second; actual consumption rate: {5} msgs/second.";
    }

    @Override
    public final void activatingReplica(SimpleString nodeID) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.activatingReplica$str(), (Object)nodeID);
    }

    protected String activatingReplica$str() {
        return "AMQ221049: Activating Replica for node: {0}";
    }

    @Override
    public final void activatingSharedStoreSlave() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.activatingSharedStoreSlave$str(), new Object[0]);
    }

    protected String activatingSharedStoreSlave$str() {
        return "AMQ221050: Activating Shared Store Slave";
    }

    @Override
    public final void populatingSecurityRolesFromLDAP(String url) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.populatingSecurityRolesFromLDAP$str(), (Object)url);
    }

    protected String populatingSecurityRolesFromLDAP$str() {
        return "AMQ221051: Populating security roles from LDAP at: {0}";
    }

    @Override
    public final void deployTopic(SimpleString topicName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deployTopic$str(), (Object)topicName);
    }

    protected String deployTopic$str() {
        return "AMQ221052: Deploying topic {0}";
    }

    @Override
    public final void disallowedProtocol(String protocol, String acceptorName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.disallowedProtocol$str(), (Object)protocol, (Object)acceptorName);
    }

    protected String disallowedProtocol$str() {
        return "AMQ221053: Disallowing use of vulnerable protocol ''{0}'' on acceptor ''{1}''. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.";
    }

    @Override
    public final void switchingNIOonPath(String journalPath) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.switchingNIOonPath$str(), (Object)journalPath);
    }

    protected String switchingNIOonPath$str() {
        return "AMQ221054: libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {0}";
    }

    @Override
    public final void removingBackupData(String path) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.removingBackupData$str(), (Object)path);
    }

    protected String removingBackupData$str() {
        return "AMQ221055: There were too many old replicated folders upon startup, removing {0}";
    }

    @Override
    public final void reloadingConfiguration(String module) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.reloadingConfiguration$str(), (Object)module);
    }

    protected String reloadingConfiguration$str() {
        return "AMQ221056: Reloading configuration: {0}";
    }

    @Override
    public final void usingDefaultPaging(long bytes) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.usingDefaultPaging$str(), (Object)bytes);
    }

    protected String usingDefaultPaging$str() {
        return "AMQ221057: Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {0}";
    }

    @Override
    public final void invalidJournalFileSize(int journalFileSize, int fileSize, int alignment) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.invalidJournalFileSize$str(), (Object)journalFileSize, (Object)fileSize, (Object)alignment);
    }

    protected String invalidJournalFileSize$str() {
        return "AMQ221058: resetting Journal File size from {0} to {1} to fit with alignment of {2}";
    }

    @Override
    public final void backupDeletingData(String oldPath) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupDeletingData$str(), (Object)oldPath);
    }

    protected String backupDeletingData$str() {
        return "AMQ221059: Deleting old data directory {0} as the max folders is set to 0";
    }

    @Override
    public final void sendingQuorumVoteRequest(String remoteAddress, String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.sendingQuorumVoteRequest$str(), (Object)remoteAddress, (Object)vote);
    }

    protected String sendingQuorumVoteRequest$str() {
        return "AMQ221060: Sending quorum vote request to {0}: {1}";
    }

    @Override
    public final void receivedQuorumVoteResponse(String remoteAddress, String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.receivedQuorumVoteResponse$str(), (Object)remoteAddress, (Object)vote);
    }

    protected String receivedQuorumVoteResponse$str() {
        return "AMQ221061: Received quorum vote response from {0}: {1}";
    }

    @Override
    public final void receivedQuorumVoteRequest(String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.receivedQuorumVoteRequest$str(), (Object)vote);
    }

    protected String receivedQuorumVoteRequest$str() {
        return "AMQ221062: Received quorum vote request: {0}";
    }

    @Override
    public final void sendingQuorumVoteResponse(String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.sendingQuorumVoteResponse$str(), (Object)vote);
    }

    protected String sendingQuorumVoteResponse$str() {
        return "AMQ221063: Sending quorum vote response: {0}";
    }

    @Override
    public final void nodeFoundInClusterTopology(String nodeId) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.nodeFoundInClusterTopology$str(), (Object)nodeId);
    }

    protected String nodeFoundInClusterTopology$str() {
        return "AMQ221064: Node {0} found in cluster topology";
    }

    @Override
    public final void nodeNotFoundInClusterTopology(String nodeId) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.nodeNotFoundInClusterTopology$str(), (Object)nodeId);
    }

    protected String nodeNotFoundInClusterTopology$str() {
        return "AMQ221065: Node {0} not found in cluster topology";
    }

    @Override
    public final void initiatingQuorumVote(SimpleString vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.initiatingQuorumVote$str(), (Object)vote);
    }

    protected String initiatingQuorumVote$str() {
        return "AMQ221066: Initiating quorum vote: {0}";
    }

    @Override
    public final void waitingForQuorumVoteResults(int timeout, String unit) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.waitingForQuorumVoteResults$str(), (Object)timeout, (Object)unit);
    }

    protected String waitingForQuorumVoteResults$str() {
        return "AMQ221067: Waiting {0} {1} for quorum vote results.";
    }

    @Override
    public final void receivedAllQuorumVotes() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.receivedAllQuorumVotes$str(), new Object[0]);
    }

    protected String receivedAllQuorumVotes$str() {
        return "AMQ221068: Received all quorum votes.";
    }

    @Override
    public final void timeoutWaitingForQuorumVoteResponses() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.timeoutWaitingForQuorumVoteResponses$str(), new Object[0]);
    }

    protected String timeoutWaitingForQuorumVoteResponses$str() {
        return "AMQ221069: Timeout waiting for quorum vote responses.";
    }

    @Override
    public final void restartingAsBackupBasedOnQuorumVoteResults() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.restartingAsBackupBasedOnQuorumVoteResults$str(), new Object[0]);
    }

    protected String restartingAsBackupBasedOnQuorumVoteResults$str() {
        return "AMQ221070: Restarting as backup based on quorum vote results.";
    }

    @Override
    public final void failingOverBasedOnQuorumVoteResults() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.failingOverBasedOnQuorumVoteResults$str(), new Object[0]);
    }

    protected String failingOverBasedOnQuorumVoteResults$str() {
        return "AMQ221071: Failing over based on quorum vote results.";
    }

    @Override
    public final void failedToFindRolesForTheSubject(Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)e, this.failedToFindRolesForTheSubject$str(), new Object[0]);
    }

    protected String failedToFindRolesForTheSubject$str() {
        return "AMQ221072: Can't find roles for the subject.";
    }

    @Override
    public final void failedAddRolePrincipal(Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)e, this.failedAddRolePrincipal$str(), new Object[0]);
    }

    protected String failedAddRolePrincipal$str() {
        return "AMQ221073: Can't add role principal.";
    }

    @Override
    public final void debugStarted(Long globalSizeBytes, Long numberOfMessages) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.debugStarted$str(), (Object)globalSizeBytes, (Object)numberOfMessages);
    }

    protected String debugStarted$str() {
        return "AMQ221074: Debug started : size = {0} bytes, messages = {1}";
    }

    @Override
    public final void deprecatedWildcardRoutingEnabled() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deprecatedWildcardRoutingEnabled$str(), new Object[0]);
    }

    protected String deprecatedWildcardRoutingEnabled$str() {
        return "AMQ221075: Usage of wildcardRoutingEnabled configuration property is deprecated, please use wildCardConfiguration.enabled instead";
    }

    @Override
    public final void onDestroyConnectionWithSessionMetadata(String msg) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.onDestroyConnectionWithSessionMetadata$str(), (Object)msg);
    }

    protected String onDestroyConnectionWithSessionMetadata$str() {
        return "AMQ221076: {0}";
    }

    @Override
    public final void infoNoQueueWithID(Long id, Long record) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.infoNoQueueWithID$str(), (Object)id, (Object)record);
    }

    protected String infoNoQueueWithID$str() {
        return "AMQ221077: There is no queue with ID {0}, deleting record {1}";
    }

    @Override
    public final void infoScaledDownMessages(Long num) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.infoScaledDownMessages$str(), (Object)num);
    }

    protected String infoScaledDownMessages$str() {
        return "AMQ221078: Scaled down {0} messages total.";
    }

    @Override
    public final void ignoringPrepareOnXidAlreadyCalled(String xid) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.ignoringPrepareOnXidAlreadyCalled$str(), (Object)xid);
    }

    protected String ignoringPrepareOnXidAlreadyCalled$str() {
        return "AMQ221079: Ignoring prepare on xid as already called : {0}";
    }

    @Override
    public final void deployAddress(String addressName, String routingTypes) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.deployAddress$str(), (Object)addressName, (Object)routingTypes);
    }

    protected String deployAddress$str() {
        return "AMQ221080: Deploying address {0} supporting {1}";
    }

    @Override
    public final void infoNoAddressWithID(Long id, Long record) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.infoNoAddressWithID$str(), (Object)id, (Object)record);
    }

    protected String infoNoAddressWithID$str() {
        return "AMQ221081: There is no address with ID {0}, deleting record {1}";
    }

    @Override
    public final void initializingMetricsPlugin(String clazz, String properties) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.initializingMetricsPlugin$str(), (Object)clazz, (Object)properties);
    }

    protected String initializingMetricsPlugin$str() {
        return "AMQ221082: Initializing metrics plugin {0} with properties: {1}";
    }

    @Override
    public final void ignoringQuorumVote(int maxClusterSize) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.ignoringQuorumVote$str(), (Object)maxClusterSize);
    }

    protected String ignoringQuorumVote$str() {
        return "AMQ221083: ignoring quorum vote as max cluster size is {0}.";
    }

    @Override
    public final void requestedQuorumVotes(int vote) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.requestedQuorumVotes$str(), (Object)vote);
    }

    protected String requestedQuorumVotes$str() {
        return "AMQ221084: Requested {0} quorum votes";
    }

    @Override
    public final void redirectClientConnection(Connection connection, Target target) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.redirectClientConnection$str(), (Object)connection, (Object)target);
    }

    protected String redirectClientConnection$str() {
        return "AMQ221085: Redirect {0} to {1}";
    }

    @Override
    public final void cannotRedirectClientConnection(Connection connection) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.cannotRedirectClientConnection$str(), (Object)connection);
    }

    protected String cannotRedirectClientConnection$str() {
        return "AMQ221086: Cannot redirect {0}";
    }

    @Override
    public final void serverFinalisedWIthoutBeingSTopped() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.serverFinalisedWIthoutBeingSTopped$str(), new Object[0]);
    }

    protected String serverFinalisedWIthoutBeingSTopped$str() {
        return "AMQ222000: ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope";
    }

    @Override
    public final void errorClosingSessionsWhileStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingSessionsWhileStoppingServer$str(), new Object[0]);
    }

    protected String errorClosingSessionsWhileStoppingServer$str() {
        return "AMQ222001: Error closing sessions while stopping server";
    }

    @Override
    public final void timedOutStoppingThreadpool(ExecutorService service) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutStoppingThreadpool$str(), (Object)service);
    }

    protected String timedOutStoppingThreadpool$str() {
        return "AMQ222002: Timed out waiting for pool to terminate {0}. Interrupting all its threads!";
    }

    @Override
    public final void divertWithNoAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.divertWithNoAddress$str(), new Object[0]);
    }

    protected String divertWithNoAddress$str() {
        return "AMQ222004: Must specify an address for each divert. This one will not be deployed.";
    }

    @Override
    public final void divertWithNoForwardingAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.divertWithNoForwardingAddress$str(), new Object[0]);
    }

    protected String divertWithNoForwardingAddress$str() {
        return "AMQ222005: Must specify a forwarding address for each divert. This one will not be deployed.";
    }

    @Override
    public final void divertBindingAlreadyExists(SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.divertBindingAlreadyExists$str(), (Object)bindingName);
    }

    protected String divertBindingAlreadyExists$str() {
        return "AMQ222006: Binding already exists with name {0}, divert will not be deployed";
    }

    @Override
    public final void clusterSecurityRisk() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterSecurityRisk$str(), new Object[0]);
    }

    protected String clusterSecurityRisk$str() {
        return "AMQ222007: Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.";
    }

    @Override
    public final void serverRestartWarning(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.serverRestartWarning$str(), new Object[0]);
    }

    protected String serverRestartWarning$str() {
        return "AMQ222008: unable to restart server, please kill and restart manually";
    }

    @Override
    public final void replicationStartProblem(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.replicationStartProblem$str(), new Object[0]);
    }

    protected String replicationStartProblem$str() {
        return "AMQ222009: Unable to announce backup for replication. Trying to stop the server.";
    }

    @Override
    public final void ioCriticalIOError(String message, String file, Throwable code) {
        this.log.logv(FQCN, Logger.Level.WARN, code, this.ioCriticalIOError$str(), (Object)message, (Object)file);
    }

    protected String ioCriticalIOError$str() {
        return "AMQ222010: Critical IO Error, shutting down the server. file={1}, message={0}";
    }

    @Override
    public final void errorStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStoppingServer$str(), new Object[0]);
    }

    protected String errorStoppingServer$str() {
        return "AMQ222011: Error stopping server";
    }

    @Override
    public final void backupActivationProblem() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.backupActivationProblem$str(), new Object[0]);
    }

    protected String backupActivationProblem$str() {
        return "AMQ222012: Timed out waiting for backup activation to exit";
    }

    @Override
    public final void errorStartingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStartingReplication0$str(), new Object[0]);
    }

    protected String errorStartingReplication0$str() {
        return "AMQ222013: Error when trying to start replication";
    }

    @Override
    public final void errorStoppingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStoppingReplication$str(), new Object[0]);
    }

    protected String errorStoppingReplication$str() {
        return "AMQ222014: Error when trying to stop replication";
    }

    @Override
    public final void connectorWithNoName() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectorWithNoName$str(), new Object[0]);
    }

    protected String connectorWithNoName$str() {
        return "AMQ222016: Cannot deploy a connector with no name specified.";
    }

    @Override
    public final void connectorAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectorAlreadyDeployed$str(), (Object)name);
    }

    protected String connectorAlreadyDeployed$str() {
        return "AMQ222017: There is already a connector with name {0} deployed. This one will not be deployed.";
    }

    @Override
    public final void AIONotFound() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.AIONotFound$str(), new Object[0]);
    }

    protected String AIONotFound$str() {
        return "AMQ222018: AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal";
    }

    @Override
    public final void discoveryGroupAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.discoveryGroupAlreadyDeployed$str(), (Object)name);
    }

    protected String discoveryGroupAlreadyDeployed$str() {
        return "AMQ222019: There is already a discovery group with name {0} deployed. This one will not be deployed.";
    }

    @Override
    public final void errorScanningURLs(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorScanningURLs$str(), new Object[0]);
    }

    protected String errorScanningURLs$str() {
        return "AMQ222020: error scanning for URL''s";
    }

    @Override
    public final void problemUndeployingNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemUndeployingNode$str(), (Object)node);
    }

    protected String problemUndeployingNode$str() {
        return "AMQ222021: problem undeploying {0}";
    }

    @Override
    public final void timedOutStoppingPagingCursor(Executor executor) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutStoppingPagingCursor$str(), (Object)executor);
    }

    protected String timedOutStoppingPagingCursor$str() {
        return "AMQ222022: Timed out waiting for paging cursor to stop {0}";
    }

    @Override
    public final void problemCleaningPageAddress(Exception e, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningPageAddress$str(), (Object)address);
    }

    protected String problemCleaningPageAddress$str() {
        return "AMQ222023: problem cleaning page address {0}";
    }

    @Override
    public final void problemCompletingOperations(OperationContext e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.problemCompletingOperations$str(), (Object)e);
    }

    protected String problemCompletingOperations$str() {
        return "AMQ222024: Could not complete operations on IO context {0}";
    }

    @Override
    public final void problemCleaningPagesubscriptionCounter(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningPagesubscriptionCounter$str(), new Object[0]);
    }

    protected String problemCleaningPagesubscriptionCounter$str() {
        return "AMQ222025: Problem cleaning page subscription counter";
    }

    @Override
    public final void problemCleaningCursorPages(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningCursorPages$str(), new Object[0]);
    }

    protected String problemCleaningCursorPages$str() {
        return "AMQ222026: Error on cleaning up cursor pages";
    }

    @Override
    public final void timedOutFlushingExecutorsPagingCursor(PageSubscription pageSubscription) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutFlushingExecutorsPagingCursor$str(), (Object)pageSubscription);
    }

    protected String timedOutFlushingExecutorsPagingCursor$str() {
        return "AMQ222027: Timed out flushing executors for paging cursor to stop {0}";
    }

    @Override
    public final void pageNotFound(PagePosition pos, long queueID, String queue) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.pageNotFound$str(), (Object)pos, (Object)queueID, (Object)queue);
    }

    protected String pageNotFound$str() {
        return "AMQ222028: Could not find page cache for page {0}, on queue {1}/{2} removing it from the journal";
    }

    @Override
    public final void pageSubscriptionCouldntLoad(long transactionID, PagePosition position, SimpleString address, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageSubscriptionCouldntLoad$str(), transactionID, position, address, name);
    }

    protected String pageSubscriptionCouldntLoad$str() {
        return "AMQ222029: Could not locate page transaction {0}, ignoring message on position {1} on address={2} queue={3}";
    }

    @Override
    public final void pageInvalid(String fileName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.pageInvalid$str(), (Object)fileName, (Object)name);
    }

    protected String pageInvalid$str() {
        return "AMQ222030: File {0} being renamed to {1}.invalidPage as it was loaded partially. Please verify your data.";
    }

    @Override
    public final void pageDeleteError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageDeleteError$str(), new Object[0]);
    }

    protected String pageDeleteError$str() {
        return "AMQ222031: Error while deleting page file";
    }

    @Override
    public final void pageFinaliseError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageFinaliseError$str(), new Object[0]);
    }

    protected String pageFinaliseError$str() {
        return "AMQ222032: page finalise error";
    }

    @Override
    public final void pageSuspectFile(String fileName, int position, int msgNumber) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.pageSuspectFile$str(), (Object)fileName, (Object)position, (Object)msgNumber);
    }

    protected String pageSuspectFile$str() {
        return "AMQ222033: Page file {0} had incomplete records at position {1} at record number {2}";
    }

    @Override
    public final void pageTxDeleteError(Exception e, long recordID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageTxDeleteError$str(), (Object)recordID);
    }

    protected String pageTxDeleteError$str() {
        return "AMQ222034: Can not delete page transaction id={0}";
    }

    @Override
    public final void pageStoreFactoryNoIdFile(String s2, String addressFile) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.pageStoreFactoryNoIdFile$str(), (Object)s2, (Object)addressFile);
    }

    protected String pageStoreFactoryNoIdFile$str() {
        return "AMQ222035: Directory {0} did not have an identification file {1}";
    }

    @Override
    public final void pageStoreTimeout(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.pageStoreTimeout$str(), (Object)address);
    }

    protected String pageStoreTimeout$str() {
        return "AMQ222036: Timed out on waiting PagingStore {0} to shutdown";
    }

    @Override
    public final void pageStoreStartIOError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageStoreStartIOError$str(), new Object[0]);
    }

    protected String pageStoreStartIOError$str() {
        return "AMQ222037: IO Error, impossible to start paging";
    }

    @Override
    public final void pageStoreStart(SimpleString storeName, long addressSize, long maxSize, long globalMaxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreStart$str(), storeName, addressSize, maxSize, globalMaxSize);
    }

    protected String pageStoreStart$str() {
        return "AMQ222038: Starting paging on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }

    @Override
    public final void pageStoreDropMessages(SimpleString storeName, long addressSize, long maxSize, long globalMaxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreDropMessages$str(), storeName, addressSize, maxSize, globalMaxSize);
    }

    protected String pageStoreDropMessages$str() {
        return "AMQ222039: Messages sent to address ''{0}'' are being dropped; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }

    @Override
    public final void serverIsStopped() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.serverIsStopped$str(), new Object[0]);
    }

    protected String serverIsStopped$str() {
        return "AMQ222040: Server is stopped";
    }

    @Override
    public final void journalCannotFindQueueDelCount(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalCannotFindQueueDelCount$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueDelCount$str() {
        return "AMQ222041: Cannot find queue {0} to update delivery count";
    }

    @Override
    public final void journalCannotFindMessageDelCount(Long msg) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalCannotFindMessageDelCount$str(), (Object)msg);
    }

    protected String journalCannotFindMessageDelCount$str() {
        return "AMQ222042: Cannot find message {0} to update delivery count";
    }

    @Override
    public final void journalCannotFindQueueForMessage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalCannotFindQueueForMessage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueForMessage$str() {
        return "AMQ222043: Message for queue {0} which does not exist. This message will be ignored.";
    }

    @Override
    public final void journalErrorDeletingMessage(Exception e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.journalErrorDeletingMessage$str(), (Object)messageID);
    }

    protected String journalErrorDeletingMessage$str() {
        return "AMQ222044: It was not possible to delete message {0}";
    }

    @Override
    public final void journalMessageInPreparedTX(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalMessageInPreparedTX$str(), (Object)queueID);
    }

    protected String journalMessageInPreparedTX$str() {
        return "AMQ222045: Message in prepared tx for queue {0} which does not exist. This message will be ignored.";
    }

    @Override
    public final void journalErrorRemovingRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalErrorRemovingRef$str(), (Object)messageID);
    }

    protected String journalErrorRemovingRef$str() {
        return "AMQ222046: Failed to remove reference for {0}";
    }

    @Override
    public final void journalCannotFindQueueReloadingACK(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalCannotFindQueueReloadingACK$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingACK$str() {
        return "AMQ222047: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR";
    }

    @Override
    public final void journalPAGEOnPrepared() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalPAGEOnPrepared$str(), new Object[0]);
    }

    protected String journalPAGEOnPrepared$str() {
        return "AMQ222048: PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state";
    }

    @Override
    public final void journalInvalidRecordType(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalInvalidRecordType$str(), (Object)recordType);
    }

    protected String journalInvalidRecordType$str() {
        return "AMQ222049: InternalError: Record type {0} not recognized. Maybe you are using journal files created on a different version";
    }

    @Override
    public final void journalInvalidRecordTypeOnPreparedTX(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalInvalidRecordTypeOnPreparedTX$str(), (Object)recordType);
    }

    protected String journalInvalidRecordTypeOnPreparedTX$str() {
        return "AMQ222050: Can not locate recordType={0} on loadPreparedTransaction//deleteRecords";
    }

    @Override
    public final void journalError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.journalError$str(), new Object[0]);
    }

    protected String journalError$str() {
        return "AMQ222051: Journal Error";
    }

    @Override
    public final void errorIncrementDelayDeletionCount(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorIncrementDelayDeletionCount$str(), new Object[0]);
    }

    protected String errorIncrementDelayDeletionCount$str() {
        return "AMQ222052: error incrementing delay detection";
    }

    @Override
    public final void lareMessageErrorCopying(Exception e, LargeServerMessage largeServerMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.lareMessageErrorCopying$str(), (Object)largeServerMessage);
    }

    protected String lareMessageErrorCopying$str() {
        return "AMQ222053: Error on copying large message {0} for DLA or Expiry";
    }

    @Override
    public final void errorExecutingAIOCallback(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.errorExecutingAIOCallback$str(), new Object[0]);
    }

    protected String errorExecutingAIOCallback$str() {
        return "AMQ222054: Error on executing IOCallback";
    }

    @Override
    public final void errorDeletingDuplicateCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorDeletingDuplicateCache$str(), new Object[0]);
    }

    protected String errorDeletingDuplicateCache$str() {
        return "AMQ222055: Error on deleting duplicate cache";
    }

    @Override
    public final void noDLA(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noDLA$str(), (Object)address);
    }

    protected String noDLA$str() {
        return "AMQ222056: Did not route to any bindings for address {0} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.";
    }

    @Override
    public final void ioErrorAddingReferences(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.ioErrorAddingReferences$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorAddingReferences$str() {
        return "AMQ222057: It was not possible to add references due to an IO error code {0} message = {1}";
    }

    @Override
    public final void duplicateMessageDetected(Message message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.duplicateMessageDetected$str(), (Object)message);
    }

    protected String duplicateMessageDetected$str() {
        return "AMQ222059: Duplicate message detected - message will not be routed. Message information:\n{0}";
    }

    @Override
    public final void journalErrorConfirmingLargeMessage(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.journalErrorConfirmingLargeMessage$str(), (Object)messageID);
    }

    protected String journalErrorConfirmingLargeMessage$str() {
        return "AMQ222060: Error while confirming large message completion on rollback for recordID={0}";
    }

    @Override
    public final void clientConnectionFailed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clientConnectionFailed$str(), (Object)name);
    }

    protected String clientConnectionFailed$str() {
        return "AMQ222061: Client connection failed, clearing up resources for session {0}";
    }

    @Override
    public final void clearingUpSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clearingUpSession$str(), (Object)name);
    }

    protected String clearingUpSession$str() {
        return "AMQ222062: Cleared up resources for session {0}";
    }

    @Override
    public final void errorProcessingIOCallback(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorProcessingIOCallback$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String errorProcessingIOCallback$str() {
        return "AMQ222063: Error processing IOCallback code = {0} message = {1}";
    }

    @Override
    public final void incompatibleVersionAfterConnect(int version, int clientVersion) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.incompatibleVersionAfterConnect$str(), (Object)version, (Object)clientVersion);
    }

    protected String incompatibleVersionAfterConnect$str() {
        return "AMQ222065: Client is not being consistent on the request versioning. It just sent a version id={0} while it informed {1} previously";
    }

    @Override
    public final void reattachRequestFailed(String remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.reattachRequestFailed$str(), (Object)remoteAddress);
    }

    protected String reattachRequestFailed$str() {
        return "AMQ222066: Reattach request from {0} failed as there is no confirmationWindowSize configured, which may be ok for your system";
    }

    @Override
    public final void connectionFailureDetected(String message, ActiveMQExceptionType type) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectionFailureDetected$str(), (Object)message, (Object)type);
    }

    protected String connectionFailureDetected$str() {
        return "AMQ222067: Connection failure has been detected: {0} [code={1}]";
    }

    @Override
    public final void errorCleaningStompConn(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCleaningStompConn$str(), new Object[0]);
    }

    protected String errorCleaningStompConn$str() {
        return "AMQ222069: error cleaning up stomp connection";
    }

    @Override
    public final void stompTXAckNorSupported() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.stompTXAckNorSupported$str(), new Object[0]);
    }

    protected String stompTXAckNorSupported$str() {
        return "AMQ222070: Stomp Transactional acknowledgement is not supported";
    }

    @Override
    public final void errorOnStompHeartBeat(InterruptedException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorOnStompHeartBeat$str(), new Object[0]);
    }

    protected String errorOnStompHeartBeat$str() {
        return "AMQ222071: Interrupted while waiting for stomp heartbeat to die";
    }

    @Override
    public final void timedOutFlushingInvmChannel() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutFlushingInvmChannel$str(), new Object[0]);
    }

    protected String timedOutFlushingInvmChannel$str() {
        return "AMQ222072: Timed out flushing channel on InVMConnection";
    }

    @Override
    public final void nettyChannelGroupError() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nettyChannelGroupError$str(), new Object[0]);
    }

    protected String nettyChannelGroupError$str() {
        return "AMQ212074: channel group did not completely close";
    }

    @Override
    public final void nettyChannelStillOpen(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nettyChannelStillOpen$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillOpen$str() {
        return "AMQ222075: {0} is still connected to {1}";
    }

    @Override
    public final void nettyChannelGroupBindError() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nettyChannelGroupBindError$str(), new Object[0]);
    }

    protected String nettyChannelGroupBindError$str() {
        return "AMQ222076: channel group did not completely unbind";
    }

    @Override
    public final void nettyChannelStillBound(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nettyChannelStillBound$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillBound$str() {
        return "AMQ222077: {0} is still bound to {1}";
    }

    @Override
    public final void errorCreatingRemotingInterceptor(Exception e, String interceptorClass) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCreatingRemotingInterceptor$str(), (Object)interceptorClass);
    }

    protected String errorCreatingRemotingInterceptor$str() {
        return "AMQ222078: Error instantiating remoting interceptor {0}";
    }

    @Override
    public final void invalidAcceptorKeys(String s2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidAcceptorKeys$str(), (Object)s2);
    }

    protected String invalidAcceptorKeys$str() {
        return "AMQ222079: The following keys are invalid for configuring the acceptor: {0} the acceptor will not be started.";
    }

    @Override
    public final void errorCreatingAcceptor(Exception e, String factoryClassName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCreatingAcceptor$str(), (Object)factoryClassName);
    }

    protected String errorCreatingAcceptor$str() {
        return "AMQ222080: Error instantiating remoting acceptor {0}";
    }

    @Override
    public final void timeoutRemotingThreadPool() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutRemotingThreadPool$str(), new Object[0]);
    }

    protected String timeoutRemotingThreadPool$str() {
        return "AMQ222081: Timed out waiting for remoting thread pool to terminate";
    }

    @Override
    public final void errorOnFailureCheck(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorOnFailureCheck$str(), new Object[0]);
    }

    protected String errorOnFailureCheck$str() {
        return "AMQ222082: error on connection failure check";
    }

    @Override
    public final void connectorKeysInvalid(String s2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectorKeysInvalid$str(), (Object)s2);
    }

    protected String connectorKeysInvalid$str() {
        return "AMQ222083: The following keys are invalid for configuring the connector service: {0} the connector will not be started.";
    }

    @Override
    public final void connectorKeysMissing(String s2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectorKeysMissing$str(), (Object)s2);
    }

    protected String connectorKeysMissing$str() {
        return "AMQ222084: The following keys are required for configuring the connector service: {0} the connector will not be started.";
    }

    @Override
    public final void invalidPacketForReplication(Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidPacketForReplication$str(), (Object)packet);
    }

    protected String invalidPacketForReplication$str() {
        return "AMQ222085: Packet {0} can not be processed by the ReplicationEndpoint";
    }

    @Override
    public final void errorHandlingReplicationPacket(Exception e, Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorHandlingReplicationPacket$str(), (Object)packet);
    }

    protected String errorHandlingReplicationPacket$str() {
        return "AMQ222086: error handling packet {0} for replication";
    }

    @Override
    public final void errorClosingPageOnReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingPageOnReplication$str(), new Object[0]);
    }

    protected String errorClosingPageOnReplication$str() {
        return "AMQ222087: Replication Error while closing the page on backup";
    }

    @Override
    public final void journalcomparisonMismatch(String s2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalcomparisonMismatch$str(), (Object)s2);
    }

    protected String journalcomparisonMismatch$str() {
        return "AMQ222088: Journal comparison mismatch:\n{0}";
    }

    @Override
    public final void errorDeletingLargeMessage(Exception e, long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorDeletingLargeMessage$str(), (Object)messageId);
    }

    protected String errorDeletingLargeMessage$str() {
        return "AMQ222089: Replication Error deleting large message ID = {0}";
    }

    @Override
    public final void largeMessageNotAvailable(long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.largeMessageNotAvailable$str(), (Object)messageId);
    }

    protected String largeMessageNotAvailable$str() {
        return "AMQ222090: Replication Large MessageID {0}  is not available on backup server. Ignoring replication message";
    }

    @Override
    public final void replicationStopOnBackupShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.replicationStopOnBackupShutdown$str(), new Object[0]);
    }

    protected String replicationStopOnBackupShutdown$str() {
        return "AMQ222091: The backup node has been shut-down, replication will now stop";
    }

    @Override
    public final void replicationStopOnBackupFail(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.replicationStopOnBackupFail$str(), new Object[0]);
    }

    protected String replicationStopOnBackupFail$str() {
        return "AMQ222092: Connection to the backup node failed, removing replication now";
    }

    @Override
    public final void timedOutWaitingToStopBridge() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutWaitingToStopBridge$str(), new Object[0]);
    }

    protected String timedOutWaitingToStopBridge$str() {
        return "AMQ222093: Timed out waiting to stop Bridge";
    }

    @Override
    public final void bridgeUnableToSendMessage(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.bridgeUnableToSendMessage$str(), (Object)ref);
    }

    protected String bridgeUnableToSendMessage$str() {
        return "AMQ222094: Bridge unable to send message {0}, will try again once bridge reconnects";
    }

    @Override
    public final void bridgeConnectionFailed(Boolean failedOver) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeConnectionFailed$str(), (Object)failedOver);
    }

    protected String bridgeConnectionFailed$str() {
        return "AMQ222095: Connection failed with failedOver={0}";
    }

    @Override
    public final void errorQueryingBridge(Throwable t, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.errorQueryingBridge1$str(), (Object)name);
    }

    protected String errorQueryingBridge1$str() {
        return "AMQ222096: Error on querying binding on bridge {0}. Retrying in 100 milliseconds";
    }

    @Override
    public final void errorQueryingBridge(SimpleString address, Integer retryCount) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorQueryingBridge2$str(), (Object)address, (Object)retryCount);
    }

    protected String errorQueryingBridge2$str() {
        return "AMQ222097: Address {0} does not have any bindings, retry #({1})";
    }

    @Override
    public final void errorStartingBridge(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorStartingBridge$str(), (Object)name);
    }

    protected String errorStartingBridge$str() {
        return "AMQ222098: Server is starting, retry to create the session for bridge {0}";
    }

    @Override
    public final void errorConnectingBridge(Exception e, Bridge bridge) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorConnectingBridge$str(), (Object)bridge);
    }

    protected String errorConnectingBridge$str() {
        return "AMQ222099: Bridge {0} is unable to connect to destination. It will be disabled.";
    }

    @Override
    public final void bridgeLocatorShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeLocatorShutdown$str(), new Object[0]);
    }

    protected String bridgeLocatorShutdown$str() {
        return "AMQ222100: ServerLocator was shutdown, can not retry on opening connection for bridge";
    }

    @Override
    public final void bridgeAbortStart(SimpleString name, Integer retryCount, Integer reconnectAttempts) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeAbortStart$str(), (Object)name, (Object)retryCount, (Object)reconnectAttempts);
    }

    protected String bridgeAbortStart$str() {
        return "AMQ222101: Bridge {0} achieved {1} maxattempts={2} it will stop retrying to reconnect";
    }

    @Override
    public final void errorReConnecting(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorReConnecting$str(), new Object[0]);
    }

    protected String errorReConnecting$str() {
        return "AMQ222102: Unexpected exception while trying to reconnect";
    }

    @Override
    public final void timedOutXID(Xid xid) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutXID$str(), (Object)xid);
    }

    protected String timedOutXID$str() {
        return "AMQ222103: transaction with xid {0} timed out";
    }

    @Override
    public final void ioErrorOnTX(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.ioErrorOnTX$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorOnTX$str() {
        return "AMQ222104: IO Error completing the transaction, code = {0}, message = {1}";
    }

    @Override
    public final void replacingIncompleteLargeMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.replacingIncompleteLargeMessage$str(), (Object)messageID);
    }

    protected String replacingIncompleteLargeMessage$str() {
        return "AMQ222106: Replacing incomplete LargeMessage with ID={0}";
    }

    @Override
    public final void clientConnectionFailedClearingSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clientConnectionFailedClearingSession$str(), (Object)name);
    }

    protected String clientConnectionFailedClearingSession$str() {
        return "AMQ222107: Cleared up resources for session {0}";
    }

    @Override
    public final void broadcastGroupClosed(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.broadcastGroupClosed$str(), new Object[0]);
    }

    protected String broadcastGroupClosed$str() {
        return "AMQ222108: unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void timeoutLockingConsumer(String consumer, String remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutLockingConsumer$str(), (Object)consumer, (Object)remoteAddress);
    }

    protected String timeoutLockingConsumer$str() {
        return "AMQ222109: Timed out waiting for write lock on consumer {0} from {1}. Check the Thread dump";
    }

    @Override
    public final void noQueueIdDefined(Message message, Message messageCopy, SimpleString idsHeaderName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noQueueIdDefined$str(), (Object)message, (Object)messageCopy, (Object)idsHeaderName);
    }

    protected String noQueueIdDefined$str() {
        return "AMQ222110: no queue IDs defined!,  originalMessage  = {0}, copiedMessage = {1}, props={2}";
    }

    @Override
    public final void managementOperationError(Exception e, String op, String resourceName) {
        this.log.logv(FQCN, Logger.Level.TRACE, (Throwable)e, this.managementOperationError$str(), (Object)op, (Object)resourceName);
    }

    protected String managementOperationError$str() {
        return "AMQ222111: exception while invoking {0} on {1}";
    }

    @Override
    public final void managementAttributeError(Exception e, String att, String resourceName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.managementAttributeError$str(), (Object)att, (Object)resourceName);
    }

    protected String managementAttributeError$str() {
        return "AMQ222112: exception while retrieving attribute {0} on {1}";
    }

    @Override
    public final void managementStopError(Integer size, List<String> unexpectedResourceNames) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.managementStopError$str(), (Object)size, (Object)unexpectedResourceNames);
    }

    protected String managementStopError$str() {
        return "AMQ222113: On ManagementService stop, there are {0} unexpected registered MBeans: {1}";
    }

    @Override
    public final void unableToDeleteGroupBindings(Exception e, SimpleString groupId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToDeleteGroupBindings$str(), (Object)groupId);
    }

    protected String unableToDeleteGroupBindings$str() {
        return "AMQ222114: Unable to delete group binding info {0}";
    }

    @Override
    public final void errorClosingServerLocator(Exception e, ServerLocatorInternal clusterLocator) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingServerLocator$str(), (Object)clusterLocator);
    }

    protected String errorClosingServerLocator$str() {
        return "AMQ222115: Error closing serverLocator={0}";
    }

    @Override
    public final void unableToStartBroadcastGroup(Exception e, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartBroadcastGroup$str(), (Object)name);
    }

    protected String unableToStartBroadcastGroup$str() {
        return "AMQ222116: unable to start broadcast group {0}";
    }

    @Override
    public final void unableToStartClusterConnection(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartClusterConnection$str(), (Object)name);
    }

    protected String unableToStartClusterConnection$str() {
        return "AMQ222117: unable to start cluster connection {0}";
    }

    @Override
    public final void unableToStartBridge(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartBridge$str(), (Object)name);
    }

    protected String unableToStartBridge$str() {
        return "AMQ222118: unable to start Bridge {0}";
    }

    @Override
    public final void announceBackupNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.announceBackupNoConnector$str(), (Object)connectorName);
    }

    protected String announceBackupNoConnector$str() {
        return "AMQ222119: No connector with name {0}. backup cannot be announced.";
    }

    @Override
    public final void announceBackupNoClusterConnections() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.announceBackupNoClusterConnections$str(), new Object[0]);
    }

    protected String announceBackupNoClusterConnections$str() {
        return "AMQ222120: no cluster connections defined, unable to announce backup";
    }

    @Override
    public final void bridgeNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeNotUnique$str(), new Object[0]);
    }

    protected String bridgeNotUnique$str() {
        return "AMQ222121: Must specify a unique name for each bridge. This one will not be deployed.";
    }

    @Override
    public final void bridgeNoQueue(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeNoQueue$str(), (Object)name);
    }

    protected String bridgeNoQueue$str() {
        return "AMQ222122: Must specify a queue name for each bridge. This one {0} will not be deployed.";
    }

    @Override
    public final void bridgeNoForwardAddress(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeNoForwardAddress$str(), (Object)bridgeName);
    }

    protected String bridgeNoForwardAddress$str() {
        return "AMQ222123: Forward address is not specified on bridge {0}. Will use original message address instead";
    }

    @Override
    public final void bridgeAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeAlreadyDeployed$str(), (Object)name);
    }

    protected String bridgeAlreadyDeployed$str() {
        return "AMQ222124: There is already a bridge with name {0} deployed. This one will not be deployed.";
    }

    @Override
    public final void bridgeQueueNotFound(String queueName, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeQueueNotFound$str(), (Object)queueName, (Object)bridgeName);
    }

    protected String bridgeQueueNotFound$str() {
        return "AMQ222125: No queue found with name {0} bridge {1} will not be deployed.";
    }

    @Override
    public final void bridgeNoDiscoveryGroup(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeNoDiscoveryGroup$str(), (Object)name);
    }

    protected String bridgeNoDiscoveryGroup$str() {
        return "AMQ222126: No discovery group found with name {0} bridge will not be deployed.";
    }

    @Override
    public final void clusterConnectionNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterConnectionNotUnique$str(), new Object[0]);
    }

    protected String clusterConnectionNotUnique$str() {
        return "AMQ222127: Must specify a unique name for each cluster connection. This one will not be deployed.";
    }

    @Override
    public final void clusterConnectionNoForwardAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterConnectionNoForwardAddress$str(), new Object[0]);
    }

    protected String clusterConnectionNoForwardAddress$str() {
        return "AMQ222128: Must specify an address for each cluster connection. This one will not be deployed.";
    }

    @Override
    public final void clusterConnectionNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterConnectionNoConnector$str(), (Object)connectorName);
    }

    protected String clusterConnectionNoConnector$str() {
        return "AMQ222129: No connector with name {0}. The cluster connection will not be deployed.";
    }

    @Override
    public final void clusterConnectionAlreadyExists(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterConnectionAlreadyExists$str(), (Object)connectorName);
    }

    protected String clusterConnectionAlreadyExists$str() {
        return "AMQ222130: Cluster Configuration  {0} already exists. The cluster connection will not be deployed.";
    }

    @Override
    public final void clusterConnectionNoDiscoveryGroup(String discoveryGroupName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterConnectionNoDiscoveryGroup$str(), (Object)discoveryGroupName);
    }

    protected String clusterConnectionNoDiscoveryGroup$str() {
        return "AMQ222131: No discovery group with name {0}. The cluster connection will not be deployed.";
    }

    @Override
    public final void broadcastGroupAlreadyExists(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.broadcastGroupAlreadyExists$str(), (Object)name);
    }

    protected String broadcastGroupAlreadyExists$str() {
        return "AMQ222132: There is already a broadcast-group with name {0} deployed. This one will not be deployed.";
    }

    @Override
    public final void broadcastGroupNoConnector(String connectorName, String bgName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.broadcastGroupNoConnector$str(), (Object)connectorName, (Object)bgName);
    }

    protected String broadcastGroupNoConnector$str() {
        return "AMQ222133: There is no connector deployed with name {0}. The broadcast group with name {1} will not be deployed.";
    }

    @Override
    public final void noConnector(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noConnector$str(), (Object)name);
    }

    protected String noConnector$str() {
        return "AMQ222134: No connector defined with name {0}. The bridge will not be deployed.";
    }

    @Override
    public final void errorStoppingRedistributor() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorStoppingRedistributor$str(), new Object[0]);
    }

    protected String errorStoppingRedistributor$str() {
        return "AMQ222135: Stopping Redistributor, Timed out waiting for tasks to complete";
    }

    @Override
    public final void ioErrorRedistributing(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.ioErrorRedistributing$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorRedistributing$str() {
        return "AMQ222136: IO Error during redistribution, errorCode = {0} message = {1}";
    }

    @Override
    public final void errorAnnouncingBackup(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorAnnouncingBackup0$str(), new Object[0]);
    }

    protected String errorAnnouncingBackup0$str() {
        return "AMQ222137: Unable to announce backup, retrying";
    }

    @Override
    public final void noLocalMemborOnClusterConnection(ClusterConnectionImpl clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noLocalMemborOnClusterConnection$str(), (Object)clusterConnection);
    }

    protected String noLocalMemborOnClusterConnection$str() {
        return "AMQ222138: Local Member is not set at on ClusterConnection {0}";
    }

    @Override
    public final void remoteQueueAlreadyBoundOnClusterConnection(Object messageFlowRecord, SimpleString clusterName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.remoteQueueAlreadyBoundOnClusterConnection$str(), messageFlowRecord, (Object)clusterName);
    }

    protected String remoteQueueAlreadyBoundOnClusterConnection$str() {
        return "AMQ222139: {0}::Remote queue binding {1} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses";
    }

    @Override
    public final void nodeManagerCantOpenFile(Exception e, File file) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.nodeManagerCantOpenFile$str(), (Object)file);
    }

    protected String nodeManagerCantOpenFile$str() {
        return "AMQ222141: Node Manager can not open file {0}";
    }

    @Override
    public final void errorResttingLargeMessage(Throwable e, Object deliverer) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorResttingLargeMessage$str(), deliverer);
    }

    protected String errorResttingLargeMessage$str() {
        return "AMQ222142: Error on resetting large message deliver - {0}";
    }

    @Override
    public final void errorTransferringConsumer() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorTransferringConsumer$str(), new Object[0]);
    }

    protected String errorTransferringConsumer$str() {
        return "AMQ222143: Timed out waiting for executor to complete";
    }

    @Override
    public final void errorFlushingExecutorsOnQueue() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorFlushingExecutorsOnQueue$str(), new Object[0]);
    }

    protected String errorFlushingExecutorsOnQueue$str() {
        return "AMQ222144: Queue could not finish waiting executors. Try increasing the thread pool size";
    }

    @Override
    public final void errorExpiringReferencesOnQueue(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorExpiringReferencesOnQueue$str(), (Object)ref);
    }

    protected String errorExpiringReferencesOnQueue$str() {
        return "AMQ222145: Error expiring reference {0} on queue";
    }

    @Override
    public final void errorExpiringReferencesNoBindings(SimpleString expiryAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorExpiringReferencesNoBindings$str(), (Object)expiryAddress);
    }

    protected String errorExpiringReferencesNoBindings$str() {
        return "AMQ222146: Message has expired. No bindings for Expiry Address {0} so dropping it";
    }

    @Override
    public final void errorExpiringReferencesNoAddress(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorExpiringReferencesNoAddress$str(), (Object)name);
    }

    protected String errorExpiringReferencesNoAddress$str() {
        return "AMQ222147: Messages are being expired on queue {0}, but there is no Expiry Address configured so messages will be dropped.";
    }

    @Override
    public final void messageExceededMaxDelivery(MessageReference ref, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.messageExceededMaxDelivery$str(), (Object)ref, (Object)name);
    }

    protected String messageExceededMaxDelivery$str() {
        return "AMQ222148: Message {0} has exceeded max delivery attempts. No bindings for Dead Letter Address {1} so dropping it";
    }

    @Override
    public final void messageExceededMaxDeliverySendtoDLA(MessageReference ref, SimpleString name, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.messageExceededMaxDeliverySendtoDLA$str(), (Object)ref, (Object)name, (Object)simpleString);
    }

    protected String messageExceededMaxDeliverySendtoDLA$str() {
        return "AMQ222149: Message {0} has reached maximum delivery attempts, sending it to Dead Letter Address {1} from {2}";
    }

    @Override
    public final void messageExceededMaxDeliveryNoDLA(MessageReference ref, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.messageExceededMaxDeliveryNoDLA$str(), (Object)ref, (Object)name);
    }

    protected String messageExceededMaxDeliveryNoDLA$str() {
        return "AMQ222150: Message {0} has exceeded max delivery attempts. No Dead Letter Address configured for queue {1} so dropping it";
    }

    @Override
    public final void removingBadConsumer(Throwable e, Consumer consumer, Object reference) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.removingBadConsumer$str(), (Object)consumer, reference);
    }

    protected String removingBadConsumer$str() {
        return "AMQ222151: removing consumer which did not handle a message, consumer={0}, message={1}";
    }

    @Override
    public final void errorDecrementingRefCount(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorDecrementingRefCount$str(), new Object[0]);
    }

    protected String errorDecrementingRefCount$str() {
        return "AMQ222152: Unable to decrement reference counting on queue";
    }

    @Override
    public final void cannotFindMessageOnJournal(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.cannotFindMessageOnJournal$str(), (Object)messageID);
    }

    protected String cannotFindMessageOnJournal$str() {
        return "AMQ222153: Cannot locate record for message id = {0} on Journal";
    }

    @Override
    public final void errorCheckingDLQ(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCheckingDLQ$str(), new Object[0]);
    }

    protected String errorCheckingDLQ$str() {
        return "AMQ222154: Error checking DLQ";
    }

    @Override
    public final void errorRegisteringBackup() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorRegisteringBackup$str(), new Object[0]);
    }

    protected String errorRegisteringBackup$str() {
        return "AMQ222155: Failed to register as backup. Stopping the server.";
    }

    @Override
    public final void memoryError(Integer memoryWarningThreshold, String info) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.memoryError$str(), (Object)memoryWarningThreshold, (Object)info);
    }

    protected String memoryError$str() {
        return "AMQ222156: Less than {0}%\n{1}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)";
    }

    @Override
    public final void errorCompletingCallbackOnReplicationManager(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCompletingCallbackOnReplicationManager$str(), new Object[0]);
    }

    protected String errorCompletingCallbackOnReplicationManager$str() {
        return "AMQ222157: Error completing callback on replication manager";
    }

    @Override
    public final void activationDidntFinish(ActiveMQServer server) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.activationDidntFinish$str(), (Object)server);
    }

    protected String activationDidntFinish$str() {
        return "AMQ222158: {0} activation thread did not finish.";
    }

    @Override
    public final void broadcastBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.broadcastBridgeStoppedError$str(), new Object[0]);
    }

    protected String broadcastBridgeStoppedError$str() {
        return "AMQ222159: unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void notificationBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.notificationBridgeStoppedError$str(), new Object[0]);
    }

    protected String notificationBridgeStoppedError$str() {
        return "AMQ222160: unable to send notification when broadcast group is stopped";
    }

    @Override
    public final void groupHandlerSendTimeout() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.groupHandlerSendTimeout$str(), new Object[0]);
    }

    protected String groupHandlerSendTimeout$str() {
        return "AMQ222161: Group Handler timed-out waiting for sendCondition";
    }

    @Override
    public final void backupMovingDataAway(String oldPath, String newPath) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.backupMovingDataAway$str(), (Object)oldPath, (Object)newPath);
    }

    protected String backupMovingDataAway$str() {
        return "AMQ222162: Moving data directory {0} to {1}";
    }

    @Override
    public final void stopReplicatedBackupAfterFailback() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.stopReplicatedBackupAfterFailback$str(), new Object[0]);
    }

    protected String stopReplicatedBackupAfterFailback$str() {
        return "AMQ222163: Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.";
    }

    @Override
    public final void errorStartingReplication(BackupReplicationStartFailedMessage.BackupRegistrationProblem problem) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorStartingReplication1$str(), (Object)problem);
    }

    protected String errorStartingReplication1$str() {
        return "AMQ222164: Error when trying to start replication {0}";
    }

    @Override
    public final void AddressSettingsNoDLA(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.AddressSettingsNoDLA$str(), (Object)name);
    }

    protected String AddressSettingsNoDLA$str() {
        return "AMQ222165: No Dead Letter Address configured for queue {0} in AddressSettings";
    }

    @Override
    public final void AddressSettingsNoExpiryAddress(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.AddressSettingsNoExpiryAddress$str(), (Object)name);
    }

    protected String AddressSettingsNoExpiryAddress$str() {
        return "AMQ222166: No Expiry Address configured for queue {0} in AddressSettings";
    }

    @Override
    public final void groupingQueueRemoved(int size, SimpleString clusterName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.groupingQueueRemoved$str(), (Object)size, (Object)clusterName);
    }

    protected String groupingQueueRemoved$str() {
        return "AMQ222167: Group Binding not available so deleting {0} groups from {1}, groups will be bound to another node";
    }

    @Override
    public final void warnDeprecatedProtocol() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.warnDeprecatedProtocol$str(), new Object[0]);
    }

    protected String warnDeprecatedProtocol$str() {
        return "AMQ222168: The ''protocol'' property is deprecated. If you want this Acceptor to support multiple protocols, use the ''protocols'' property, e.g. with value ''CORE,AMQP,STOMP''";
    }

    @Override
    public final void warnDisconnectOldClient(String queueName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.warnDisconnectOldClient$str(), (Object)queueName);
    }

    protected String warnDisconnectOldClient$str() {
        return "AMQ222169: You have old legacy clients connected to the queue {0} and we can''t disconnect them, these clients may just hang";
    }

    @Override
    public final void bridgeConfirmationWindowTooSmall(String bridgeName, String address, int windowConfirmation, long maxSizeBytes) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeConfirmationWindowTooSmall$str(), bridgeName, address, windowConfirmation, maxSizeBytes);
    }

    protected String bridgeConfirmationWindowTooSmall$str() {
        return "AMQ222170: Bridge {0} forwarding address {1} has confirmation-window-size ({2}) greater than address'' max-size-bytes'' ({3})";
    }

    @Override
    public final void bridgeCantFindAddressConfig(String bridgeName, String forwardingAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeCantFindAddressConfig$str(), (Object)bridgeName, (Object)forwardingAddress);
    }

    protected String bridgeCantFindAddressConfig$str() {
        return "AMQ222171: Bridge {0} forwarding address {1} could not be resolved on address-settings configuration";
    }

    @Override
    public final void queueBusy(String name, long timeout) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.queueBusy$str(), (Object)name, (Object)timeout);
    }

    protected String queueBusy$str() {
        return "AMQ222172: Queue {0} was busy for more than {1} milliseconds. There are possibly consumers hanging on a network operation";
    }

    @Override
    public final void queueDuplicatedRenaming(String name, String newName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.queueDuplicatedRenaming$str(), (Object)name, (Object)newName);
    }

    protected String queueDuplicatedRenaming$str() {
        return "AMQ222173: Queue {0} is duplicated during reload. This queue will be renamed as {1}";
    }

    @Override
    public final void timeoutFlushInTransit(String queueName, String addressName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutFlushInTransit$str(), (Object)queueName, (Object)addressName);
    }

    protected String timeoutFlushInTransit$str() {
        return "AMQ222174: Queue {0}, on address={1}, is taking too long to flush deliveries. Watch out for frozen clients.";
    }

    @Override
    public final void bridgeCantFindConnectors(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeCantFindConnectors$str(), (Object)bridgeName);
    }

    protected String bridgeCantFindConnectors$str() {
        return "AMQ222175: Bridge {0} could not find configured connectors";
    }

    @Override
    public final void xidReplacedOnXStart(String xidOriginalToString, String xidReplacedToString) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.xidReplacedOnXStart$str(), (Object)xidOriginalToString, (Object)xidReplacedToString);
    }

    protected String xidReplacedOnXStart$str() {
        return "AMQ222176: A session that was already doing XA work on {0} is replacing the xid by {1} . This was most likely caused from a previous communication timeout";
    }

    @Override
    public final void rolePermissionConfigurationError(String permission) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.rolePermissionConfigurationError$str(), (Object)permission);
    }

    protected String rolePermissionConfigurationError$str() {
        return "AMQ222177: Wrong configuration for role, {0} is not a valid permission";
    }

    @Override
    public final void errorRecoveringPageCounter(Throwable error) {
        this.log.logv(FQCN, Logger.Level.WARN, error, this.errorRecoveringPageCounter$str(), new Object[0]);
    }

    protected String errorRecoveringPageCounter$str() {
        return "AMQ222178: Error during recovery of page counters";
    }

    @Override
    public final void failedToScaleDown(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.failedToScaleDown$str(), new Object[0]);
    }

    protected String failedToScaleDown$str() {
        return "AMQ222181: Unable to scaleDown messages";
    }

    @Override
    public final void missingClusterConfigForScaleDown(String scaleDownCluster) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.missingClusterConfigForScaleDown$str(), (Object)scaleDownCluster);
    }

    protected String missingClusterConfigForScaleDown$str() {
        return "AMQ222182: Missing cluster-configuration for scale-down-clustername {0}";
    }

    @Override
    public final void blockingMessageProduction(SimpleString addressName, long currentSize, long maxSize, long globalMaxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.blockingMessageProduction$str(), addressName, currentSize, maxSize, globalMaxSize);
    }

    protected String blockingMessageProduction$str() {
        return "AMQ222183: Blocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes on address: {2}, global-max-size is {3}";
    }

    @Override
    public final void groupBindingsOnRecovery() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.groupBindingsOnRecovery$str(), new Object[0]);
    }

    protected String groupBindingsOnRecovery$str() {
        return "AMQ222184: Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this";
    }

    @Override
    public final void noClusterConnectionForReplicationCluster() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noClusterConnectionForReplicationCluster$str(), new Object[0]);
    }

    protected String noClusterConnectionForReplicationCluster$str() {
        return "AMQ222185: no cluster connection for specified replication cluster";
    }

    @Override
    public final void clusterControlAuthfailure(String causeMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.clusterControlAuthfailure$str(), (Object)causeMessage);
    }

    protected String clusterControlAuthfailure$str() {
        return "AMQ222186: unable to authorise cluster control: {0}";
    }

    @Override
    public final void activateReplicatedBackupFailed(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.activateReplicatedBackupFailed$str(), new Object[0]);
    }

    protected String activateReplicatedBackupFailed$str() {
        return "AMQ222187: Failed to activate replicated backup";
    }

    @Override
    public final void unableToFindTargetQueue(String targetNodeID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToFindTargetQueue$str(), (Object)targetNodeID);
    }

    protected String unableToFindTargetQueue$str() {
        return "AMQ222188: Unable to find target queue for node {0}";
    }

    @Override
    public final void activateSharedStoreSlaveFailed(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.activateSharedStoreSlaveFailed$str(), new Object[0]);
    }

    protected String activateSharedStoreSlaveFailed$str() {
        return "AMQ222189: Failed to activate shared store slave";
    }

    @Override
    public final void cannotFindRoleForUser(String user) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotFindRoleForUser$str(), (Object)user);
    }

    protected String cannotFindRoleForUser$str() {
        return "AMQ222191: Could not find any configured role for user {0}.";
    }

    @Override
    public final void couldNotDeleteTempFile(String tempFileName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.couldNotDeleteTempFile$str(), (Object)tempFileName);
    }

    protected String couldNotDeleteTempFile$str() {
        return "AMQ222192: Could not delete: {0}";
    }

    @Override
    public final void memoryLimitReached(String producerID, String address, long duration) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.memoryLimitReached$str(), (Object)producerID, (Object)address, (Object)duration);
    }

    protected String memoryLimitReached$str() {
        return "AMQ222193: Memory Limit reached. Producer ({0}) stopped to prevent flooding {1} (blocking for {2}s). See http://activemq.apache.org/producer-flow-control.html for more info.";
    }

    @Override
    public final void nullPageCursorInfo(String address, String position, long id) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nullPageCursorInfo$str(), (Object)address, (Object)position, (Object)id);
    }

    protected String nullPageCursorInfo$str() {
        return "AMQ222194: PageCursorInfo == null on address {0}, pos = {1}, queue = {2}.";
    }

    @Override
    public final void largeMessageNotFound(long id) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.largeMessageNotFound$str(), (Object)id);
    }

    protected String largeMessageNotFound$str() {
        return "AMQ222195: Large message {0} wasn''t found when dealing with add pending large message";
    }

    @Override
    public final void bindingNotFound(long id, String message, String binding) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bindingNotFound$str(), (Object)id, (Object)message, (Object)binding);
    }

    protected String bindingNotFound$str() {
        return "AMQ222196: Could not find binding with id={0} on routeFromCluster for message={1} binding = {2}";
    }

    @Override
    public final void nonDeliveryHandled() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nonDeliveryHandled$str(), new Object[0]);
    }

    protected String nonDeliveryHandled$str() {
        return "AMQ222197: Internal error! Delivery logic has identified a non delivery and still handled a consumer!";
    }

    @Override
    public final void couldNotFlushClusterManager(String manager) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.couldNotFlushClusterManager$str(), (Object)manager);
    }

    protected String couldNotFlushClusterManager$str() {
        return "AMQ222198: Could not flush ClusterManager executor ({0}) in 10 seconds, verify your thread pool size";
    }

    @Override
    public final void threadDump(String manager) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.threadDump$str(), (Object)manager);
    }

    protected String threadDump$str() {
        return "AMQ222199: Thread dump: {0}";
    }

    @Override
    public final void couldNotFinishExecutor(String clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.couldNotFinishExecutor$str(), (Object)clusterConnection);
    }

    protected String couldNotFinishExecutor$str() {
        return "AMQ222200: Could not finish executor on {0}";
    }

    @Override
    public final void activationTimeout() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.activationTimeout$str(), new Object[0]);
    }

    protected String activationTimeout$str() {
        return "AMQ222201: Timed out waiting for activation to exit";
    }

    @Override
    public final void connectionTTLEqualsCheckPeriod(String connectionName, String ttl, String checkPeriod) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectionTTLEqualsCheckPeriod$str(), (Object)connectionName, (Object)ttl, (Object)checkPeriod);
    }

    protected String connectionTTLEqualsCheckPeriod$str() {
        return "AMQ222202: {0}: <{1}> should not be set to the same value as <{2}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.";
    }

    @Override
    public final void noProtocolManagerFound(String protocol, String host) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noProtocolManagerFound$str(), (Object)protocol, (Object)host);
    }

    protected String noProtocolManagerFound$str() {
        return "AMQ222203: Classpath lacks a protocol-manager for protocol {0}, Protocol being ignored on acceptor {1}";
    }

    @Override
    public final void duplicatedAcceptor(String name, String parameters, String classFactory) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.duplicatedAcceptor$str(), (Object)name, (Object)parameters, (Object)classFactory);
    }

    protected String duplicatedAcceptor$str() {
        return "AMQ222204: Duplicated Acceptor {0} with parameters {1} classFactory={2} duplicated on the configuration";
    }

    @Override
    public final void potentialOOME(long addressCount, long totalMaxSizeBytes, long maxMemory) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.potentialOOME$str(), (Object)addressCount, (Object)totalMaxSizeBytes, (Object)maxMemory);
    }

    protected String potentialOOME$str() {
        return "AMQ222205: OutOfMemoryError possible! There are currently {0} addresses with a total max-size-bytes of {1} bytes, but the maximum memory available is {2} bytes.";
    }

    @Override
    public final void connectionLimitReached(long connectionsAllowed, String address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectionLimitReached$str(), (Object)connectionsAllowed, (Object)address);
    }

    protected String connectionLimitReached$str() {
        return "AMQ222206: Connection limit of {0} reached. Refusing connection from {1}.";
    }

    @Override
    public final void slowReplicationResponse() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.slowReplicationResponse$str(), new Object[0]);
    }

    protected String slowReplicationResponse$str() {
        return "AMQ222207: The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.";
    }

    @Override
    public final void sslHandshakeFailed(String clientAddress, String cause) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.sslHandshakeFailed$str(), (Object)clientAddress, (Object)cause);
    }

    protected String sslHandshakeFailed$str() {
        return "AMQ222208: SSL handshake failed for client from {0}: {1}.";
    }

    @Override
    public final void impossibleToRouteGrouped() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.impossibleToRouteGrouped$str(), new Object[0]);
    }

    protected String impossibleToRouteGrouped$str() {
        return "AMQ222209: Could not contact group handler coordinator after 10 retries, message being routed without grouping information";
    }

    @Override
    public final void diskBeyondCapacity(String usableSpace, String totalSpace, String usage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.diskBeyondCapacity$str(), (Object)usableSpace, (Object)totalSpace, (Object)usage);
    }

    protected String diskBeyondCapacity$str() {
        return "AMQ222210: Free storage space is at {0} of {1} total. Usage rate is {2} which is beyond the configured <max-disk-usage>. System will start blocking producers.";
    }

    @Override
    public final void diskCapacityRestored(String usableSpace, String totalSpace, String usage) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.diskCapacityRestored$str(), (Object)usableSpace, (Object)totalSpace, (Object)usage);
    }

    protected String diskCapacityRestored$str() {
        return "AMQ222211: Free storage space is at {0} of {1} total. Usage rate is {2} which is below the configured <max-disk-usage>.";
    }

    @Override
    public final void blockingDiskFull(SimpleString addressName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.blockingDiskFull$str(), (Object)addressName);
    }

    protected String blockingDiskFull$str() {
        return "AMQ222212: Disk Full! Blocking message production on address ''{0}''. Clients will report blocked.";
    }

    @Override
    public final void serverIsolatedOnNetwork() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.serverIsolatedOnNetwork$str(), new Object[0]);
    }

    protected String serverIsolatedOnNetwork$str() {
        return "AMQ222213: There was an issue on the network, server is isolated!";
    }

    @Override
    public final void negativeAddressSize(long size, String destination) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.negativeAddressSize$str(), (Object)size, (Object)destination);
    }

    protected String negativeAddressSize$str() {
        return "AMQ222214: Destination {1} has an inconsistent and negative address size={0}.";
    }

    @Override
    public final void negativeGlobalAddressSize(long size) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.negativeGlobalAddressSize$str(), (Object)size);
    }

    protected String negativeGlobalAddressSize$str() {
        return "AMQ222215: Global Address Size has negative and inconsistent value as {0}";
    }

    @Override
    public final void securityProblemWhileAuthenticating(String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.securityProblemWhileAuthenticating$str(), (Object)message);
    }

    protected String securityProblemWhileAuthenticating$str() {
        return "AMQ222216: Security problem while authenticating: {0}";
    }

    @Override
    public final void connectorRefNotFound(String connectorRef, String clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectorRefNotFound$str(), (Object)connectorRef, (Object)clusterConnection);
    }

    protected String connectorRefNotFound$str() {
        return "AMQ222217: Cannot find connector-ref {0}. The cluster-connection {1} will not be deployed.";
    }

    @Override
    public final void disconnectCritical(String reason, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.disconnectCritical$str(), (Object)reason);
    }

    protected String disconnectCritical$str() {
        return "AMQ222218: Server disconnecting: {0}";
    }

    @Override
    public final void fileDoesNotExist(String path) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.fileDoesNotExist$str(), (Object)path);
    }

    protected String fileDoesNotExist$str() {
        return "AMQ222219: File {0} does not exist";
    }

    @Override
    public final void errorCleaningPagingOnQueue(Exception e, String queue) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCleaningPagingOnQueue$str(), (Object)queue);
    }

    protected String errorCleaningPagingOnQueue$str() {
        return "AMQ222220:    Error while cleaning paging on queue {0}";
    }

    @Override
    public final void errorCleaningPagingDuringCommit(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCleaningPagingDuringCommit$str(), new Object[0]);
    }

    protected String errorCleaningPagingDuringCommit$str() {
        return "AMQ222221: Error while cleaning page, during the commit";
    }

    @Override
    public final void errorDeletingPageCompleteRecord(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorDeletingPageCompleteRecord$str(), new Object[0]);
    }

    protected String errorDeletingPageCompleteRecord$str() {
        return "AMQ222222: Error while deleting page-complete-record";
    }

    @Override
    public final void errorCalculateMessageMemoryEstimate(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCalculateMessageMemoryEstimate$str(), new Object[0]);
    }

    protected String errorCalculateMessageMemoryEstimate$str() {
        return "AMQ222223: Failed to calculate message memory estimate";
    }

    @Override
    public final void errorCalculateScheduledDeliveryTime(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCalculateScheduledDeliveryTime$str(), new Object[0]);
    }

    protected String errorCalculateScheduledDeliveryTime$str() {
        return "AMQ222224: Failed to calculate scheduled delivery time";
    }

    @Override
    public final void sendingUnexpectedExceptionToClient(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.sendingUnexpectedExceptionToClient$str(), new Object[0]);
    }

    protected String sendingUnexpectedExceptionToClient$str() {
        return "AMQ222225: Sending unexpected exception to the client";
    }

    @Override
    public final void connectionConfigurationIsNull(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectionConfigurationIsNull$str(), (Object)connectorName);
    }

    protected String connectionConfigurationIsNull$str() {
        return "AMQ222226: Connection configuration is null for connectorName {0}";
    }

    @Override
    public final void failedToProcessEvent(NamingException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToProcessEvent$str(), new Object[0]);
    }

    protected String failedToProcessEvent$str() {
        return "AMQ222227: Failed to process an event";
    }

    @Override
    public final void missingReplicationTokenOnQueue() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.missingReplicationTokenOnQueue$str(), new Object[0]);
    }

    protected String missingReplicationTokenOnQueue$str() {
        return "AMQ222228: Missing replication token on queue";
    }

    @Override
    public final void failedToPerformRollback(IllegalStateException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPerformRollback$str(), new Object[0]);
    }

    protected String failedToPerformRollback$str() {
        return "AMQ222229: Failed to perform rollback";
    }

    @Override
    public final void failedToSendNotification(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToSendNotification$str(), new Object[0]);
    }

    protected String failedToSendNotification$str() {
        return "AMQ222230: Failed to send notification";
    }

    @Override
    public final void failedToFlushOutstandingDataFromTheConnection(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.failedToFlushOutstandingDataFromTheConnection$str(), new Object[0]);
    }

    protected String failedToFlushOutstandingDataFromTheConnection$str() {
        return "AMQ222231: Failed to flush outstanding data from the connection";
    }

    @Override
    public final void unableToAcquireLock(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToAcquireLock$str(), new Object[0]);
    }

    protected String unableToAcquireLock$str() {
        return "AMQ222232: Unable to acquire lock";
    }

    @Override
    public final void unableDestroyConnectionWithSessionMetadata(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableDestroyConnectionWithSessionMetadata$str(), new Object[0]);
    }

    protected String unableDestroyConnectionWithSessionMetadata$str() {
        return "AMQ222233: Unable to destroy connection with session metadata";
    }

    @Override
    public final void unableToInvokeCallback(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToInvokeCallback$str(), new Object[0]);
    }

    protected String unableToInvokeCallback$str() {
        return "AMQ222234: Unable to invoke a callback";
    }

    @Override
    public final void unableToInjectMonitor(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToInjectMonitor$str(), new Object[0]);
    }

    protected String unableToInjectMonitor$str() {
        return "AMQ222235: Unable to inject a monitor";
    }

    @Override
    public final void unableToFlushDeliveries(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToFlushDeliveries$str(), new Object[0]);
    }

    protected String unableToFlushDeliveries$str() {
        return "AMQ222236: Unable to flush deliveries";
    }

    @Override
    public final void unableToCancelRedistributor(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCancelRedistributor$str(), new Object[0]);
    }

    protected String unableToCancelRedistributor$str() {
        return "AMQ222237: Unable to stop redistributor";
    }

    @Override
    public final void unableToCommitTransaction(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCommitTransaction$str(), new Object[0]);
    }

    protected String unableToCommitTransaction$str() {
        return "AMQ222238: Unable to commit transaction";
    }

    @Override
    public final void unableToDeleteQueueStatus(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToDeleteQueueStatus$str(), new Object[0]);
    }

    protected String unableToDeleteQueueStatus$str() {
        return "AMQ222239: Unable to delete Queue status";
    }

    @Override
    public final void unableToPauseQueue(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToPauseQueue$str(), new Object[0]);
    }

    protected String unableToPauseQueue$str() {
        return "AMQ222240: Unable to pause a Queue";
    }

    @Override
    public final void unableToResumeQueue(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToResumeQueue$str(), new Object[0]);
    }

    protected String unableToResumeQueue$str() {
        return "AMQ222241: Unable to resume a Queue";
    }

    @Override
    public final void unableToGetMessagePriority(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToGetMessagePriority$str(), new Object[0]);
    }

    protected String unableToGetMessagePriority$str() {
        return "AMQ222242: Unable to obtain message priority, using default ";
    }

    @Override
    public final void unableToExtractGroupID(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToExtractGroupID$str(), new Object[0]);
    }

    protected String unableToExtractGroupID$str() {
        return "AMQ222243: Unable to extract GroupID from message";
    }

    @Override
    public final void unableToCheckIfMessageExpired(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToCheckIfMessageExpired$str(), new Object[0]);
    }

    protected String unableToCheckIfMessageExpired$str() {
        return "AMQ222244: Unable to check if message expired";
    }

    @Override
    public final void unableToPerformPostAcknowledge(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToPerformPostAcknowledge$str(), new Object[0]);
    }

    protected String unableToPerformPostAcknowledge$str() {
        return "AMQ222245: Unable to perform post acknowledge";
    }

    @Override
    public final void unableToRollbackOnClose(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToRollbackOnClose$str(), new Object[0]);
    }

    protected String unableToRollbackOnClose$str() {
        return "AMQ222246: Unable to rollback on close";
    }

    @Override
    public final void unableToCloseConsumer(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToCloseConsumer$str(), new Object[0]);
    }

    protected String unableToCloseConsumer$str() {
        return "AMQ222247: Unable to close consumer";
    }

    @Override
    public final void unableToRemoveConsumer(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToRemoveConsumer$str(), new Object[0]);
    }

    protected String unableToRemoveConsumer$str() {
        return "AMQ222248: Unable to remove consumer";
    }

    @Override
    public final void unableToRollbackOnTxTimedOut(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToRollbackOnTxTimedOut$str(), new Object[0]);
    }

    protected String unableToRollbackOnTxTimedOut$str() {
        return "AMQ222249: Unable to rollback on TX timed out";
    }

    @Override
    public final void unableToDeleteHeuristicCompletion(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToDeleteHeuristicCompletion$str(), new Object[0]);
    }

    protected String unableToDeleteHeuristicCompletion$str() {
        return "AMQ222250: Unable to delete heuristic completion from storage manager";
    }

    @Override
    public final void unableToStartReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartReplication$str(), new Object[0]);
    }

    protected String unableToStartReplication$str() {
        return "AMQ222251: Unable to start replication";
    }

    @Override
    public final void unableToCalculateFileSize(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCalculateFileSize$str(), new Object[0]);
    }

    protected String unableToCalculateFileSize$str() {
        return "AMQ222252: Unable to calculate file size";
    }

    @Override
    public final void errorWhileSyncingData(String target, Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorWhileSyncingData$str(), (Object)target);
    }

    protected String errorWhileSyncingData$str() {
        return "AMQ222253: Error while syncing data on largeMessageInSync:: {0}";
    }

    @Override
    public final void invalidRecordType(byte type, Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.invalidRecordType$str(), (Object)type);
    }

    protected String invalidRecordType$str() {
        return "AMQ222254: Invalid record type {0}";
    }

    @Override
    public final void unableToCalculateFileStoreUsage(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCalculateFileStoreUsage$str(), new Object[0]);
    }

    protected String unableToCalculateFileStoreUsage$str() {
        return "AMQ222255: Unable to calculate file store usage";
    }

    @Override
    public final void failedToUnregisterAcceptors(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToUnregisterAcceptors$str(), new Object[0]);
    }

    protected String failedToUnregisterAcceptors$str() {
        return "AMQ222256: Failed to unregister acceptors";
    }

    @Override
    public final void failedToDecrementMessageReferenceCount(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToDecrementMessageReferenceCount$str(), new Object[0]);
    }

    protected String failedToDecrementMessageReferenceCount$str() {
        return "AMQ222257: Failed to decrement message reference count";
    }

    @Override
    public final void errorOnDeletingQueue(String queueName, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorOnDeletingQueue$str(), (Object)queueName);
    }

    protected String errorOnDeletingQueue$str() {
        return "AMQ222258: Error on deleting queue {0}";
    }

    @Override
    public final void failedToFlushExecutor(InterruptedException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToFlushExecutor$str(), new Object[0]);
    }

    protected String failedToFlushExecutor$str() {
        return "AMQ222259: Failed to flush the executor";
    }

    @Override
    public final void failedToRollback(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToRollback$str(), new Object[0]);
    }

    protected String failedToRollback$str() {
        return "AMQ222260: Failed to perform rollback";
    }

    @Override
    public final void failedToActivateBackup(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToActivateBackup$str(), new Object[0]);
    }

    protected String failedToActivateBackup$str() {
        return "AMQ222261: Failed to activate a backup";
    }

    @Override
    public final void failedToStopClusterManager(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToStopClusterManager$str(), new Object[0]);
    }

    protected String failedToStopClusterManager$str() {
        return "AMQ222262: Failed to stop cluster manager";
    }

    @Override
    public final void failedToStopClusterConnection(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToStopClusterConnection$str(), new Object[0]);
    }

    protected String failedToStopClusterConnection$str() {
        return "AMQ222263: Failed to stop cluster connection";
    }

    @Override
    public final void failedToProcessMessageReferenceAfterRollback(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToProcessMessageReferenceAfterRollback$str(), new Object[0]);
    }

    protected String failedToProcessMessageReferenceAfterRollback$str() {
        return "AMQ222264: Failed to process message reference after rollback";
    }

    @Override
    public final void failedToFinishDelivery(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToFinishDelivery$str(), new Object[0]);
    }

    protected String failedToFinishDelivery$str() {
        return "AMQ222265: Failed to finish delivery, unable to lock delivery";
    }

    @Override
    public final void failedToSendRequestToNode(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToSendRequestToNode$str(), new Object[0]);
    }

    protected String failedToSendRequestToNode$str() {
        return "AMQ222266: Failed to send request to the node";
    }

    @Override
    public final void failedToDisconnectBindings(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToDisconnectBindings$str(), new Object[0]);
    }

    protected String failedToDisconnectBindings$str() {
        return "AMQ222267: Failed to disconnect bindings";
    }

    @Override
    public final void failedToRemoveRecord(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToRemoveRecord$str(), new Object[0]);
    }

    protected String failedToRemoveRecord$str() {
        return "AMQ222268: Failed to remove a record";
    }

    @Override
    public final void useFixedValueOnJournalPoolFiles() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.useFixedValueOnJournalPoolFiles$str(), new Object[0]);
    }

    protected String useFixedValueOnJournalPoolFiles$str() {
        return "AMQ222269: Please use a fixed value for \"journal-pool-files\". Default changed per https://issues.apache.org/jira/browse/ARTEMIS-1628";
    }

    @Override
    public final void unableToCreateManagementNotificationAddress(SimpleString addressName, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCreateManagementNotificationAddress$str(), (Object)addressName);
    }

    protected String unableToCreateManagementNotificationAddress$str() {
        return "AMQ222270: Unable to create management notification address: {0}";
    }

    @Override
    public final void journalMessageAckMissingQueueInPreparedTX(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.journalMessageAckMissingQueueInPreparedTX$str(), (Object)queueID);
    }

    protected String journalMessageAckMissingQueueInPreparedTX$str() {
        return "AMQ022272: Message ack in prepared tx for queue {0} which does not exist. This ack will be ignored.";
    }

    @Override
    public final void bridgeAddressFull(String addressName, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.bridgeAddressFull$str(), (Object)addressName, (Object)bridgeName);
    }

    protected String bridgeAddressFull$str() {
        return "AMQ022273: Address \"{0}\" is full. Bridge {1} will disconnect";
    }

    @Override
    public final void problemDeployingAddress(String addressName, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.problemDeployingAddress$str(), (Object)addressName, (Object)message);
    }

    protected String problemDeployingAddress$str() {
        return "AMQ222274: Failed to deploy address {0}: {1}";
    }

    @Override
    public final void problemDeployingQueue(String queueName, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.problemDeployingQueue$str(), (Object)queueName, (Object)message);
    }

    protected String problemDeployingQueue$str() {
        return "AMQ222275: Failed to deploy queue {0}: {1}";
    }

    @Override
    public final void loggingReloadFailed(String configFile, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.loggingReloadFailed$str(), (Object)configFile);
    }

    protected String loggingReloadFailed$str() {
        return "AMQ222276: Failed to process changes to the logging configuration file: {0}";
    }

    @Override
    public final void problemAddingConfigReloadCallback(String propertyName, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemAddingConfigReloadCallback$str(), (Object)propertyName);
    }

    protected String problemAddingConfigReloadCallback$str() {
        return "AMQ222277: Problem initializing automatic logging configuration reload for {0}";
    }

    @Override
    public final void unableToExtractGroupSequence(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToExtractGroupSequence$str(), new Object[0]);
    }

    protected String unableToExtractGroupSequence$str() {
        return "AMQ222278: Unable to extract GroupSequence from message";
    }

    @Override
    public final void federationCantFindPolicyRef(String upstreamName, String policyRef) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.federationCantFindPolicyRef$str(), (Object)upstreamName, (Object)policyRef);
    }

    protected String federationCantFindPolicyRef$str() {
        return "AMQ222279: Federation upstream {0} policy ref {1} could not be resolved in federation configuration";
    }

    @Override
    public final void federationUnknownPolicyType(String upstreamName, String policyRef) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.federationUnknownPolicyType$str(), (Object)upstreamName, (Object)policyRef);
    }

    protected String federationUnknownPolicyType$str() {
        return "AMQ222280: Federation upstream {0} policy ref {1} is of unknown type in federation configuration";
    }

    @Override
    public final void federationAvoidStackOverflowPolicyRef(String upstreamName, String policyRef) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.federationAvoidStackOverflowPolicyRef$str(), (Object)upstreamName, (Object)policyRef);
    }

    protected String federationAvoidStackOverflowPolicyRef$str() {
        return "AMQ222281: Federation upstream {0} policy ref {1} are too self referential, avoiding stack overflow , ";
    }

    @Override
    public final void federationCantFindUpstreamConnector(String downstreamName, String upstreamRef) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.federationCantFindUpstreamConnector$str(), (Object)downstreamName, (Object)upstreamRef);
    }

    protected String federationCantFindUpstreamConnector$str() {
        return "AMQ222282: Federation downstream {0} upstream transport configuration ref {1} could not be resolved in federation configuration";
    }

    @Override
    public final void federationDownstreamDeployed(String downstreamName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.federationDownstreamDeployed$str(), (Object)downstreamName);
    }

    protected String federationDownstreamDeployed$str() {
        return "AMQ222283: Federation downstream {0} has been deployed";
    }

    @Override
    public final void federationDownstreamUnDeployed(String downstreamName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.federationDownstreamUnDeployed$str(), (Object)downstreamName);
    }

    protected String federationDownstreamUnDeployed$str() {
        return "AMQ222284: Federation downstream {0} has been undeployed";
    }

    @Override
    public final void emptyAddressFile(String addressFile, String directory) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.emptyAddressFile$str(), (Object)addressFile, (Object)directory);
    }

    protected String emptyAddressFile$str() {
        return "AMQ222285: File {0} at {1} is empty. Delete the empty file to stop this message.";
    }

    @Override
    public final void federationPluginExecutionError(Throwable e, String pluginMethod) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.federationPluginExecutionError$str(), (Object)pluginMethod);
    }

    protected String federationPluginExecutionError$str() {
        return "AMQ222286: Error executing {0} federation plugin method.";
    }

    @Override
    public final void federationBindingsLookupError(Throwable e, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.federationBindingsLookupError$str(), (Object)address);
    }

    protected String federationBindingsLookupError$str() {
        return "AMQ222287: Error looking up bindings for address {}.";
    }

    @Override
    public final void pageLookupError(int pageNr, int messageNr, int offset, int startNr) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageLookupError$str(), pageNr, messageNr, offset, startNr);
    }

    protected String pageLookupError$str() {
        return "AMQ222288: Page {0}, message {1} could not be found on offset {2}, with starting message {3}. This represents a logic error or inconsistency on the data, and the system will try once again from the beggining of the page file.";
    }

    @Override
    public final void noMatchingBindingsOnDLAWithAutoCreateDLAResources(SimpleString address, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noMatchingBindingsOnDLAWithAutoCreateDLAResources$str(), (Object)address, (Object)message);
    }

    protected String noMatchingBindingsOnDLAWithAutoCreateDLAResources$str() {
        return "AMQ222289: Did not route to any matching bindings on dead-letter-address {0} and auto-create-dead-letter-resources is true; dropping message: {1}";
    }

    @Override
    public final void failedToFindClusterConnection(String packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failedToFindClusterConnection$str(), (Object)packet);
    }

    protected String failedToFindClusterConnection$str() {
        return "AMQ222290: Failed to find cluster-connection when handling cluster-connect packet. Ignoring: {0}";
    }

    @Override
    public final void metricsPluginElementDeprecated() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.metricsPluginElementDeprecated$str(), new Object[0]);
    }

    protected String metricsPluginElementDeprecated$str() {
        return "AMQ222291: The metrics-plugin element is deprecated and replaced by the metrics element";
    }

    @Override
    public final void metricsPluginElementIgnored() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.metricsPluginElementIgnored$str(), new Object[0]);
    }

    protected String metricsPluginElementIgnored$str() {
        return "AMQ222292: The metrics-plugin element is ignored because the metrics element is defined";
    }

    @Override
    public final void possibleSplitBrain(String nodeID, String connectionPairInformation) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.possibleSplitBrain2$str(), (Object)nodeID, (Object)connectionPairInformation);
    }

    protected String possibleSplitBrain2$str() {
        return "AMQ222294: \n**************************************************************************************************************************************************************************************************************************************************************\nThere is a possible split brain on nodeID {0}, coming from connectors {1}. Topology update ignored.\n**************************************************************************************************************************************************************************************************************************************************************";
    }

    @Override
    public final void possibleSplitBrain(String nodeID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.possibleSplitBrain1$str(), (Object)nodeID);
    }

    protected String possibleSplitBrain1$str() {
        return "AMQ222295: \n**************************************************************************************************************************************************************************************************************************************************************\nThere is a possible split brain on nodeID {0}. Topology update ignored.\n**************************************************************************************************************************************************************************************************************************************************************";
    }

    @Override
    public final void unableToDeployHawtioMBean(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToDeployHawtioMBean$str(), new Object[0]);
    }

    protected String unableToDeployHawtioMBean$str() {
        return "AMQ222296: Unable to deploy Hawtio MBeam, console client side RBAC not available";
    }

    @Override
    public final void unableStartManagementContext(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableStartManagementContext$str(), new Object[0]);
    }

    protected String unableStartManagementContext$str() {
        return "AMQ222297: Unable to start Management Context, RBAC not available";
    }

    @Override
    public final void failedToCreateBootstrapCredentials(Exception e, String user) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToCreateBootstrapCredentials$str(), (Object)user);
    }

    protected String failedToCreateBootstrapCredentials$str() {
        return "AMQ222298: Failed to create bootstrap user \"{0}\". User management may not function.";
    }

    @Override
    public final void noBootstrapCredentialsFound() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noBootstrapCredentialsFound$str(), new Object[0]);
    }

    protected String noBootstrapCredentialsFound$str() {
        return "AMQ222299: No bootstrap credentials found. User management may not function.";
    }

    @Override
    public final void gettingSslHandlerFailed(String clientAddress, String cause) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.gettingSslHandlerFailed$str(), (Object)clientAddress, (Object)cause);
    }

    protected String gettingSslHandlerFailed$str() {
        return "AMQ222300: Getting SSL handler failed when serving client from {0}: {1}.";
    }

    @Override
    public final void duplicateAddressSettingMatch(String match) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.duplicateAddressSettingMatch$str(), (Object)match);
    }

    protected String duplicateAddressSettingMatch$str() {
        return "AMQ222301: Duplicate address-setting match found: {0}. These settings will be ignored! Please review your broker.xml and consolidate any duplicate address-setting elements.";
    }

    @Override
    public final void failedToDealWithObjectProperty(SimpleString property, String exceptionMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failedToDealWithObjectProperty$str(), (Object)property, (Object)exceptionMessage);
    }

    protected String failedToDealWithObjectProperty$str() {
        return "AMQ222302: Failed to deal with property {0} when converting message from core to OpenWire: {1}";
    }

    @Override
    public final void errorRedistributing(Throwable t, String queueName, long m3) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.errorRedistributing$str(), (Object)queueName, (Object)m3);
    }

    protected String errorRedistributing$str() {
        return "AMQ222303: Redistribution by {0} of messageID = {1} failed";
    }

    @Override
    public final void unableToLoadMessageFromJournal(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.unableToLoadMessageFromJournal$str(), new Object[0]);
    }

    protected String unableToLoadMessageFromJournal$str() {
        return "AMQ222304: Unable to load message from journal";
    }

    @Override
    public final void federationDispatchError(Throwable e, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.federationDispatchError$str(), (Object)message);
    }

    protected String federationDispatchError$str() {
        return "AMQ222305: Error federating message {0}.";
    }

    @Override
    public final void failedToLoadPreparedTX(Throwable e, String message) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.failedToLoadPreparedTX$str(), (Object)message);
    }

    protected String failedToLoadPreparedTX$str() {
        return "AMQ222306: Failed to load prepared TX and it will be rolled back: {0}";
    }

    @Override
    public final void initializationError(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.initializationError$str(), new Object[0]);
    }

    protected String initializationError$str() {
        return "AMQ224000: Failure in initialisation";
    }

    @Override
    public final void errorDeployingURI(Throwable e, URI uri) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeployingURI1$str(), (Object)uri);
    }

    protected String errorDeployingURI1$str() {
        return "AMQ224001: Error deploying URI {0}";
    }

    @Override
    public final void errorDeployingURI(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeployingURI0$str(), new Object[0]);
    }

    protected String errorDeployingURI0$str() {
        return "AMQ224002: Error deploying URI";
    }

    @Override
    public final void errorUnDeployingURI(Throwable e, URI a) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorUnDeployingURI$str(), (Object)a);
    }

    protected String errorUnDeployingURI$str() {
        return "AMQ224003: Error undeploying URI {0}";
    }

    @Override
    public final void unableToDeployNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToDeployNode$str(), (Object)node);
    }

    protected String unableToDeployNode$str() {
        return "AMQ224005: Unable to deploy node {0}";
    }

    @Override
    public final void invalidFilter(SimpleString filter2) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidFilter$str(), (Object)filter2);
    }

    protected String invalidFilter$str() {
        return "AMQ224006: Invalid filter: {0}";
    }

    @Override
    public final void pageSubscriptionError(IOCallback IOCallback2, String error) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.pageSubscriptionError$str(), (Object)IOCallback2, (Object)error);
    }

    protected String pageSubscriptionError$str() {
        return "AMQ224007: page subscription = {0} error={1}";
    }

    @Override
    public final void batchingIdError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.batchingIdError$str(), new Object[0]);
    }

    protected String batchingIdError$str() {
        return "AMQ224008: Failed to store id";
    }

    @Override
    public final void cannotFindMessage(Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotFindMessage$str(), (Object)id);
    }

    protected String cannotFindMessage$str() {
        return "AMQ224009: Cannot find message {0}";
    }

    @Override
    public final void journalCannotFindQueue(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.journalCannotFindQueue$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueue$str() {
        return "AMQ224010: Cannot find queue messages for queueID={0} on ack for messageID={1}";
    }

    @Override
    public final void journalCannotFindQueueScheduled(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.journalCannotFindQueueScheduled$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueueScheduled$str() {
        return "AMQ224011: Cannot find queue messages {0} for message {1} while processing scheduled messages";
    }

    @Override
    public final void largeMessageErrorReleasingResources(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.largeMessageErrorReleasingResources$str(), new Object[0]);
    }

    protected String largeMessageErrorReleasingResources$str() {
        return "AMQ224012: error releasing resources";
    }

    @Override
    public final void errorExpiringMessages(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorExpiringMessages$str(), new Object[0]);
    }

    protected String errorExpiringMessages$str() {
        return "AMQ224013: failed to expire messages for queue";
    }

    @Override
    public final void errorClosingSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingSession$str(), new Object[0]);
    }

    protected String errorClosingSession$str() {
        return "AMQ224014: Failed to close session";
    }

    @Override
    public final void caughtXaException(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtXaException$str(), new Object[0]);
    }

    protected String caughtXaException$str() {
        return "AMQ224015: Caught XA exception";
    }

    @Override
    public final void caughtException(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.caughtException$str(), new Object[0]);
    }

    protected String caughtException$str() {
        return "AMQ224016: Caught exception";
    }

    @Override
    public final void invalidPacket(Packet packet) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidPacket$str(), (Object)packet);
    }

    protected String invalidPacket$str() {
        return "AMQ224017: Invalid packet {0}";
    }

    @Override
    public final void failedToCreateSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCreateSession$str(), new Object[0]);
    }

    protected String failedToCreateSession$str() {
        return "AMQ224018: Failed to create session";
    }

    @Override
    public final void failedToReattachSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToReattachSession$str(), new Object[0]);
    }

    protected String failedToReattachSession$str() {
        return "AMQ224019: Failed to reattach session";
    }

    @Override
    public final void failedToHandleCreateQueue(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToHandleCreateQueue$str(), new Object[0]);
    }

    protected String failedToHandleCreateQueue$str() {
        return "AMQ224020: Failed to handle create queue";
    }

    @Override
    public final void errorDecodingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDecodingPacket$str(), new Object[0]);
    }

    protected String errorDecodingPacket$str() {
        return "AMQ224021: Failed to decode packet";
    }

    @Override
    public final void errorCallingFailureListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingFailureListener$str(), new Object[0]);
    }

    protected String errorCallingFailureListener$str() {
        return "AMQ224022: Failed to execute failure listener";
    }

    @Override
    public final void stompErrorTXExists(String txID) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.stompErrorTXExists$str(), (Object)txID);
    }

    protected String stompErrorTXExists$str() {
        return "AMQ224024: Stomp Error, tx already exist! {0}";
    }

    @Override
    public final void errorWritingToInvmConnector(Exception e, Runnable runnable) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingToInvmConnector$str(), (Object)runnable);
    }

    protected String errorWritingToInvmConnector$str() {
        return "AMQ224027: Failed to write to handler on invm connector {0}";
    }

    @Override
    public final void errorStoppingAcceptor(String name) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.errorStoppingAcceptor$str(), (Object)name);
    }

    protected String errorStoppingAcceptor$str() {
        return "AMQ224028: Failed to stop acceptor {0}";
    }

    @Override
    public final void largeMessageIncompatible() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.largeMessageIncompatible$str(), new Object[0]);
    }

    protected String largeMessageIncompatible$str() {
        return "AMQ224029: large message sync: largeMessage instance is incompatible with it, ignoring data";
    }

    @Override
    public final void errorCancellingRefOnBridge(Exception e, MessageReference ref2) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCancellingRefOnBridge$str(), (Object)ref2);
    }

    protected String errorCancellingRefOnBridge$str() {
        return "AMQ224030: Could not cancel reference {0}";
    }

    @Override
    public final void errorPausingBridge(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorPausingBridge$str(), new Object[0]);
    }

    protected String errorPausingBridge$str() {
        return "AMQ224032: Failed to pause bridge";
    }

    @Override
    public final void errorBroadcastingConnectorConfigs(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorBroadcastingConnectorConfigs$str(), new Object[0]);
    }

    protected String errorBroadcastingConnectorConfigs$str() {
        return "AMQ224033: Failed to broadcast connector configs";
    }

    @Override
    public final void errorClosingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingConsumer$str(), new Object[0]);
    }

    protected String errorClosingConsumer$str() {
        return "AMQ224034: Failed to close consumer";
    }

    @Override
    public final void errorClosingFlowRecord(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingFlowRecord$str(), new Object[0]);
    }

    protected String errorClosingFlowRecord$str() {
        return "AMQ224035: Failed to close cluster connection flow record";
    }

    @Override
    public final void errorUpdatingTopology(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorUpdatingTopology$str(), new Object[0]);
    }

    protected String errorUpdatingTopology$str() {
        return "AMQ224036: Failed to update cluster connection topology";
    }

    @Override
    public final void errorHandlingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorHandlingMessage$str(), new Object[0]);
    }

    protected String errorHandlingMessage$str() {
        return "AMQ224037: cluster connection Failed to handle message";
    }

    @Override
    public final void errorAckingOldReference(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorAckingOldReference$str(), new Object[0]);
    }

    protected String errorAckingOldReference$str() {
        return "AMQ224038: Failed to ack old reference";
    }

    @Override
    public final void errorExpiringRef(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorExpiringRef$str(), new Object[0]);
    }

    protected String errorExpiringRef$str() {
        return "AMQ224039: Failed to expire message reference";
    }

    @Override
    public final void errorRemovingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingConsumer$str(), new Object[0]);
    }

    protected String errorRemovingConsumer$str() {
        return "AMQ224040: Failed to remove consumer";
    }

    @Override
    public final void errorDelivering(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDelivering$str(), new Object[0]);
    }

    protected String errorDelivering$str() {
        return "AMQ224041: Failed to deliver";
    }

    @Override
    public final void errorRestartingBackupServer(Exception e, ActiveMQServer backup) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRestartingBackupServer$str(), (Object)backup);
    }

    protected String errorRestartingBackupServer$str() {
        return "AMQ224042: Error while restarting the backup server: {0}";
    }

    @Override
    public final void errorSendingForcedDelivery(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorSendingForcedDelivery$str(), new Object[0]);
    }

    protected String errorSendingForcedDelivery$str() {
        return "AMQ224043: Failed to send forced delivery message";
    }

    @Override
    public final void errorAckingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorAckingMessage$str(), new Object[0]);
    }

    protected String errorAckingMessage$str() {
        return "AMQ224044: error acknowledging message";
    }

    @Override
    public final void errorRunningLargeMessageDeliverer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRunningLargeMessageDeliverer$str(), new Object[0]);
    }

    protected String errorRunningLargeMessageDeliverer$str() {
        return "AMQ224045: Failed to run large message deliverer";
    }

    @Override
    public final void errorBrowserHandlingMessage(Exception e, MessageReference current) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorBrowserHandlingMessage$str(), (Object)current);
    }

    protected String errorBrowserHandlingMessage$str() {
        return "AMQ224046: Exception while browser handled from {0}";
    }

    @Override
    public final void errorDeletingLargeMessageFile(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeletingLargeMessageFile$str(), new Object[0]);
    }

    protected String errorDeletingLargeMessageFile$str() {
        return "AMQ224047: Failed to delete large message file";
    }

    @Override
    public final void errorRemovingTempQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingTempQueue$str(), (Object)bindingName);
    }

    protected String errorRemovingTempQueue$str() {
        return "AMQ224048: Failed to remove temporary queue {0}";
    }

    @Override
    public final void cannotFindConsumer(long consumerID) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotFindConsumer$str(), (Object)consumerID);
    }

    protected String cannotFindConsumer$str() {
        return "AMQ224049: Cannot find consumer with id {0}";
    }

    @Override
    public final void errorClosingConnection(ServerSessionImpl serverSession) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.errorClosingConnection$str(), (Object)serverSession);
    }

    protected String errorClosingConnection$str() {
        return "AMQ224050: Failed to close connection {0}";
    }

    @Override
    public final void errorCallingNotifListener(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCallingNotifListener$str(), new Object[0]);
    }

    protected String errorCallingNotifListener$str() {
        return "AMQ224051: Failed to call notification listener";
    }

    @Override
    public final void errorCallingRepoListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingRepoListener$str(), new Object[0]);
    }

    protected String errorCallingRepoListener$str() {
        return "AMQ224052: Unable to call Hierarchical Repository Change Listener";
    }

    @Override
    public final void errorTimingOutTX(Exception e, Xid xid) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorTimingOutTX$str(), (Object)xid);
    }

    protected String errorTimingOutTX$str() {
        return "AMQ224053: failed to timeout transaction, xid:{0}";
    }

    @Override
    public final void errorStoppingReplicationManager(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorStoppingReplicationManager$str(), new Object[0]);
    }

    protected String errorStoppingReplicationManager$str() {
        return "AMQ224054: exception while stopping the replication manager";
    }

    @Override
    public final void bridgeFailedToAck(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.bridgeFailedToAck$str(), new Object[0]);
    }

    protected String bridgeFailedToAck$str() {
        return "AMQ224055: Bridge Failed to ack";
    }

    @Override
    public final void autoFailBackDenied() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.autoFailBackDenied$str(), new Object[0]);
    }

    protected String autoFailBackDenied$str() {
        return "AMQ224056: Live server will not fail-back automatically";
    }

    @Override
    public final void failbackMissedBackupAnnouncement() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.failbackMissedBackupAnnouncement$str(), new Object[0]);
    }

    protected String failbackMissedBackupAnnouncement$str() {
        return "AMQ224057: Backup server that requested fail-back was not announced. Server will not stop for fail-back.";
    }

    @Override
    public final void clusterManagerAuthenticationError(String msg) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.clusterManagerAuthenticationError$str(), (Object)msg);
    }

    protected String clusterManagerAuthenticationError$str() {
        return "AMQ224058: Stopping ClusterManager. As it failed to authenticate with the cluster: {0}";
    }

    @Override
    public final void invalidCipherSuite(String validSuites) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidCipherSuite$str(), (Object)validSuites);
    }

    protected String invalidCipherSuite$str() {
        return "AMQ224059: Invalid cipher suite specified. Supported cipher suites are: {0}";
    }

    @Override
    public final void invalidProtocol(String validProtocols) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidProtocol$str(), (Object)validProtocols);
    }

    protected String invalidProtocol$str() {
        return "AMQ224060: Invalid protocol specified. Supported protocols are: {0}";
    }

    @Override
    public final void incompatibleWithHAPolicy(String parameter) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.incompatibleWithHAPolicy$str(), (Object)parameter);
    }

    protected String incompatibleWithHAPolicy$str() {
        return "AMQ224061: Setting both <{0}> and <ha-policy> is invalid. Please use <ha-policy> exclusively as <{0}> is deprecated. Ignoring <{0}> value.";
    }

    @Override
    public final void failedToSendSlowConsumerNotification(Notification notification, Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendSlowConsumerNotification$str(), (Object)notification);
    }

    protected String failedToSendSlowConsumerNotification$str() {
        return "AMQ224062: Failed to send SLOW_CONSUMER notification: {0}";
    }

    @Override
    public final void failedToCloseConsumerConnectionsForAddress(String address, Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCloseConsumerConnectionsForAddress$str(), (Object)address);
    }

    protected String failedToCloseConsumerConnectionsForAddress$str() {
        return "AMQ224063: Failed to close consumer connections for address {0}";
    }

    @Override
    public final void incompatibleWithHAPolicyChosen(String parameter) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.incompatibleWithHAPolicyChosen$str(), (Object)parameter);
    }

    protected String incompatibleWithHAPolicyChosen$str() {
        return "AMQ224064: Setting <{0}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring <{0}> value.";
    }

    @Override
    public final void errorRemovingAutoCreatedDestination(Exception e, SimpleString bindingName, String destinationType) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingAutoCreatedDestination$str(), (Object)bindingName, (Object)destinationType);
    }

    protected String errorRemovingAutoCreatedDestination$str() {
        return "AMQ224065: Failed to remove auto-created {1} {0}";
    }

    @Override
    public final void errorOpeningContextForLDAP(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorOpeningContextForLDAP$str(), new Object[0]);
    }

    protected String errorOpeningContextForLDAP$str() {
        return "AMQ224066: Error opening context for LDAP";
    }

    @Override
    public final void errorPopulatingSecurityRolesFromLDAP(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorPopulatingSecurityRolesFromLDAP$str(), new Object[0]);
    }

    protected String errorPopulatingSecurityRolesFromLDAP$str() {
        return "AMQ224067: Error populating security roles from LDAP";
    }

    @Override
    public final void errorStoppingComponent(Throwable t, String componentClassName) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorStoppingComponent$str(), (Object)componentClassName);
    }

    protected String errorStoppingComponent$str() {
        return "AMQ224068: Unable to stop component: {0}";
    }

    @Override
    public final void configurationReloadFailed(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.configurationReloadFailed$str(), new Object[0]);
    }

    protected String configurationReloadFailed$str() {
        return "AMQ224069: Change detected in broker configuration file, but reload failed";
    }

    @Override
    public final void invalidMessageCounterPeriod(long value) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidMessageCounterPeriod$str(), (Object)value);
    }

    protected String invalidMessageCounterPeriod$str() {
        return "AMQ224072: Message Counter Sample Period too short: {0}";
    }

    @Override
    public final void journalUseMAPPED() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.journalUseMAPPED$str(), new Object[0]);
    }

    protected String journalUseMAPPED$str() {
        return "AMQ224073: Using MAPPED Journal";
    }

    @Override
    public final void failedToPurgeQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToPurgeQueue$str(), (Object)bindingName);
    }

    protected String failedToPurgeQueue$str() {
        return "AMQ224074: Failed to purge queue {0} on no consumers";
    }

    @Override
    public final void journalCannotFindPageTX(Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.journalCannotFindPageTX$str(), (Object)id);
    }

    protected String journalCannotFindPageTX$str() {
        return "AMQ224075: Cannot find pageTX id = {0}";
    }

    @Override
    public final void criticalSystemHalt(Object component) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.criticalSystemHalt$str(), component);
    }

    protected String criticalSystemHalt$str() {
        return "AMQ224079: The process for the virtual machine will be killed, as component {0} is not responsive";
    }

    @Override
    public final void criticalSystemShutdown(Object component) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.criticalSystemShutdown$str(), component);
    }

    protected String criticalSystemShutdown$str() {
        return "AMQ224080: The server process will now be stopped, as component {0} is not responsive";
    }

    @Override
    public final void criticalSystemLog(Object component) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.criticalSystemLog$str(), component);
    }

    protected String criticalSystemLog$str() {
        return "AMQ224081: The component {0} is not responsive";
    }

    @Override
    public final void undeployAddress(SimpleString addressName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.undeployAddress$str(), (Object)addressName);
    }

    protected String undeployAddress$str() {
        return "AMQ224076: Undeploying address {0}";
    }

    @Override
    public final void undeployQueue(SimpleString queueName) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.undeployQueue$str(), (Object)queueName);
    }

    protected String undeployQueue$str() {
        return "AMQ224077: Undeploying queue {0}";
    }

    @Override
    public final void duplicateCacheSizeWarning(int idCacheSize, int confirmationWindowSize) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.duplicateCacheSizeWarning$str(), (Object)idCacheSize, (Object)confirmationWindowSize);
    }

    protected String duplicateCacheSizeWarning$str() {
        return "AMQ224078: The size of duplicate cache detection (<id_cache-size/>) appears to be too large {0}. It should be no greater than the number of messages that can be squeezed into confirmation window buffer (<confirmation-window-size/>) {1}.";
    }

    @Override
    public final void failedToInvokeAnInterceptor(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToInvokeAnInterceptor$str(), new Object[0]);
    }

    protected String failedToInvokeAnInterceptor$str() {
        return "AMQ224082: Failed to invoke an interceptor";
    }

    @Override
    public final void failedToCloseContext(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCloseContext$str(), new Object[0]);
    }

    protected String failedToCloseContext$str() {
        return "AMQ224083: Failed to close context";
    }

    @Override
    public final void failedToOpenContext(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToOpenContext$str(), new Object[0]);
    }

    protected String failedToOpenContext$str() {
        return "AMQ224084: Failed to open context";
    }

    @Override
    public final void failedToLoadProperty(Exception e, String key, String reason) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToLoadProperty$str(), (Object)key, (Object)reason);
    }

    protected String failedToLoadProperty$str() {
        return "AMQ224085: Failed to load property {0}, reason: {1}";
    }

    @Override
    public final void caughtUnexpectedException(NamingException e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtUnexpectedException$str(), new Object[0]);
    }

    protected String caughtUnexpectedException$str() {
        return "AMQ224086: Caught unexpected exception";
    }

    @Override
    public final void errorAnnouncingBackup(String backupManager) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.errorAnnouncingBackup1$str(), (Object)backupManager);
    }

    protected String errorAnnouncingBackup1$str() {
        return "AMQ224087: Error announcing backup: backupServerLocator is null. {0}";
    }

    @Override
    public final void handshakeTimeout(int timeout, String acceptorName, String remoteAddress) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.handshakeTimeout$str(), (Object)timeout, (Object)acceptorName, (Object)remoteAddress);
    }

    protected String handshakeTimeout$str() {
        return "AMQ224088: Timeout ({0} seconds) on acceptor \"{1}\" during protocol handshake with {2} has occurred.";
    }

    @Override
    public final void errorCalculatePersistentSize(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCalculatePersistentSize$str(), new Object[0]);
    }

    protected String errorCalculatePersistentSize$str() {
        return "AMQ224089: Failed to calculate persistent size";
    }

    @Override
    public final void noVoteHandlerConfigured() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noVoteHandlerConfigured$str(), new Object[0]);
    }

    protected String noVoteHandlerConfigured$str() {
        return "AMQ224090: This node is not configured for Quorum Voting, all nodes must be configured for HA";
    }

    @Override
    public final void errorConnectingBridgeRetry(Bridge bridge) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.errorConnectingBridgeRetry$str(), (Object)bridge);
    }

    protected String errorConnectingBridgeRetry$str() {
        return "AMQ224091: Bridge {0} is unable to connect to destination. Retrying";
    }

    @Override
    public final void pageWillBePersisted() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.pageWillBePersisted$str(), new Object[0]);
    }

    protected String pageWillBePersisted$str() {
        return "AMQ224092: Despite disabled persistence, page files will be persisted.";
    }

    @Override
    public final void nullRefMessage() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.nullRefMessage$str(), new Object[0]);
    }

    protected String nullRefMessage$str() {
        return "AMQ224093: Reference to message is null";
    }

    @Override
    public final void quorumVoteAwaitInterrupted() {
        this.log.logv(FQCN, Logger.Level.TRACE, (Throwable)null, this.quorumVoteAwaitInterrupted$str(), new Object[0]);
    }

    protected String quorumVoteAwaitInterrupted$str() {
        return "AMQ224094: Quorum vote result await is interrupted";
    }

    @Override
    public final void consumerCountError(String reason) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.consumerCountError$str(), (Object)reason);
    }

    protected String consumerCountError$str() {
        return "AMQ224095: Error updating Consumer Count: {0}";
    }

    @Override
    public final void failedToFindProtocolManager(String remoteAddress, String localAddress, String intendedProtocolManager, String protocolMap) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.failedToFindProtocolManager$str(), remoteAddress, localAddress, intendedProtocolManager, protocolMap);
    }

    protected String failedToFindProtocolManager$str() {
        return "AMQ224096: Error setting up connection from {0} to {1}; protocol {2} not found in map: {3}";
    }

    @Override
    public final void failedToStartServer(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.failedToStartServer$str(), new Object[0]);
    }

    protected String failedToStartServer$str() {
        return "AMQ224097: Failed to start server";
    }

    @Override
    public final void quorumBackupIsLive(String liveConnector) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.quorumBackupIsLive$str(), (Object)liveConnector);
    }

    protected String quorumBackupIsLive$str() {
        return "AMQ224098: Received a vote saying the backup is live with connector: {0}";
    }

    @Override
    public final void messageWithHeaderTooLarge(Long messageID, String loggerClass) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.messageWithHeaderTooLarge$str(), (Object)messageID, (Object)loggerClass);
    }

    protected String messageWithHeaderTooLarge$str() {
        return "AMQ224099: Message with ID {0} has a header too large. More information available on debug level for class {1}";
    }

    @Override
    public final void timedOutWaitingForLargeMessagesDeletion(List<Long> largeMessageIds) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.timedOutWaitingForLargeMessagesDeletion$str(), (Object)largeMessageIds);
    }

    protected String timedOutWaitingForLargeMessagesDeletion$str() {
        return "AMQ224100: Timed out waiting for large messages deletion with IDs {0}, might not be deleted if broker crashes atm";
    }

    @Override
    public final void scheduledPoolWithNoRemoveOnCancelPolicy() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.scheduledPoolWithNoRemoveOnCancelPolicy$str(), new Object[0]);
    }

    protected String scheduledPoolWithNoRemoveOnCancelPolicy$str() {
        return "AMQ224101: Apache ActiveMQ Artemis is using a scheduled pool without remove on cancel policy, so a cancelled task could be not automatically removed from the work queue, it may also cause unbounded retention of cancelled tasks.";
    }

    @Override
    public final void unableToUndeployAddress(SimpleString addressName, String reason) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.unableToUndeployAddress$str(), (Object)addressName, (Object)reason);
    }

    protected String unableToUndeployAddress$str() {
        return "AMQ224102: unable to undeploy address {0} : reason {1}";
    }

    @Override
    public final void unableToUndeployQueue(SimpleString queueName, String reason) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.unableToUndeployQueue$str(), (Object)queueName, (Object)reason);
    }

    protected String unableToUndeployQueue$str() {
        return "AMQ224103: unable to undeploy queue {0} : reason {1}";
    }

    @Override
    public final void errorStartingAcceptor(String name, Object configuration) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.errorStartingAcceptor$str(), (Object)name, configuration);
    }

    protected String errorStartingAcceptor$str() {
        return "AMQ224104: Error starting the Acceptor {0} {1}";
    }

    @Override
    public final void failedConnectingToCluster(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedConnectingToCluster$str(), new Object[0]);
    }

    protected String failedConnectingToCluster$str() {
        return "AMQ224105: Connecting to cluster failed";
    }

    @Override
    public final void errorRemovingTX(Exception e, Xid xid) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingTX$str(), (Object)xid);
    }

    protected String errorRemovingTX$str() {
        return "AMQ224106: failed to remove transaction, xid:{0}";
    }

    @Override
    public final void enableTraceForCriticalAnalyzer() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.enableTraceForCriticalAnalyzer$str(), new Object[0]);
    }

    protected String enableTraceForCriticalAnalyzer$str() {
        return "AMQ224107: The Critical Analyzer detected slow paths on the broker.  It is recommended that you enable trace logs on org.apache.activemq.artemis.utils.critical while you troubleshoot this issue. You should disable the trace logs when you have finished troubleshooting.";
    }

    @Override
    public final void pageStoreStop(SimpleString storeName, long addressSize, long maxSize, long globalMaxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreStop$str(), storeName, addressSize, maxSize, globalMaxSize);
    }

    protected String pageStoreStop$str() {
        return "AMQ224108: Stopped paging on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }

    @Override
    public final void brokerBalancerNotFound(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.brokerBalancerNotFound$str(), (Object)name);
    }

    protected String brokerBalancerNotFound$str() {
        return "AMQ224109: BrokerBalancer {0} not found";
    }

    @Override
    public final void useAllowList() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.useAllowList$str(), new Object[0]);
    }

    protected String useAllowList$str() {
        return "AMQ224110: Configuration 'whitelist' is deprecated, please use the 'allowlist' configuration";
    }

    @Override
    public final void useOnlyAllowList() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.useOnlyAllowList$str(), new Object[0]);
    }

    protected String useOnlyAllowList$str() {
        return "AMQ224111: Both 'whitelist' and 'allowlist' detected. Configuration 'whitelist' is deprecated, please use only the 'allowlist' configuration";
    }

    @Override
    public final void autoRemoveQueue(String name, long queueID, String address) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.autoRemoveQueue$str(), (Object)name, (Object)queueID, (Object)address);
    }

    protected String autoRemoveQueue$str() {
        return "AMQ224112: Auto removing Queue {0} with queueID={1} on address={2}";
    }

    @Override
    public final void autoRemoveAddress(String name) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.autoRemoveAddress$str(), (Object)name);
    }

    protected String autoRemoveAddress$str() {
        return "AMQ224113: Auto removing Address {0}";
    }
}

