/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.jboss.logging.Logger;

public class ReplicatedJournal
implements Journal {
    private static final Logger log = Logger.getLogger(ReplicatedJournal.class);
    private final ReplicationManager replicationManager;
    private final Journal localJournal;
    private final byte journalID;

    @Override
    public void setRemoveExtraFilesOnLoad(boolean removeExtraFilesOnLoad) {
        this.localJournal.setRemoveExtraFilesOnLoad(removeExtraFilesOnLoad);
    }

    @Override
    public boolean isRemoveExtraFilesOnLoad() {
        return this.localJournal.isRemoveExtraFilesOnLoad();
    }

    public ReplicatedJournal(byte journalID, Journal localJournal, ReplicationManager replicationManager) {
        this.journalID = journalID;
        this.localJournal = localJournal;
        this.replicationManager = replicationManager;
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Append record id = " + id + " recordType = " + recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Append record id = " + id + " recordType = " + recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync, completionCallback);
    }

    @Override
    public void appendAddEvent(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Append record id = " + id + " recordType = " + recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.EVENT, id, recordType, persister, record);
        this.localJournal.appendAddEvent(id, recordType, persister, record, sync, completionCallback);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Append record txID=" + id + " recordType = " + recordType);
        }
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, txID, id, recordType, persister, record);
        this.localJournal.appendAddRecordTransactional(txID, id, recordType, persister, record);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendCommit txID=" + txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendCommit " + txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync, callback);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendCommit " + txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, lineUpContext);
        this.localJournal.appendCommitRecord(txID, sync, callback, lineUpContext);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete " + id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync);
    }

    @Override
    public void tryAppendDeleteRecord(long id, JournalUpdateCallback updateCallback, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete " + id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.tryAppendDeleteRecord(id, updateCallback, sync);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete " + id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync, completionCallback);
    }

    @Override
    public void tryAppendDeleteRecord(long id, boolean sync, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete " + id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.tryAppendDeleteRecord(id, sync, updateCallback, completionCallback);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete txID=" + txID + " id=" + id);
        }
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id, record);
        this.localJournal.appendDeleteRecordTransactional(txID, id, record);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendDelete (noencoding) txID=" + txID + " id=" + id);
        }
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id);
        this.localJournal.appendDeleteRecordTransactional(txID, id);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendPrepare txID=" + txID);
        }
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendPrepare txID=" + txID);
        }
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync, callback);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendRollback " + txID);
        }
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendRollback " + txID);
        }
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync, callback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, byte[] record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceableRecord) throws Exception {
        this.tryAppendUpdateRecord(id, recordType, new ByteArrayEncoding(record), updateCallback, sync, replaceableRecord);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendUpdateRecord id = " + id + " , recordType = " + recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, persister, record);
        this.localJournal.appendUpdateRecord(id, recordType, persister, record, sync);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceable) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendUpdateRecord id = " + id + " , recordType = " + recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, persister, record);
        this.localJournal.tryAppendUpdateRecord(id, recordType, persister, record, updateCallback, sync, replaceable);
    }

    @Override
    public void appendUpdateRecord(long id, byte journalRecordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendUpdateRecord id = " + id + " , recordType = " + journalRecordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, persister, record);
        this.localJournal.appendUpdateRecord(id, journalRecordType, persister, record, sync, completionCallback);
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte journalRecordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendUpdateRecord id = " + id + " , recordType = " + journalRecordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, persister, record);
        this.localJournal.tryAppendUpdateRecord(id, journalRecordType, persister, record, sync, replaceableUpdate, updateCallback, completionCallback);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("AppendUpdateRecord txid=" + txID + " id = " + id + " , recordType = " + recordType);
        }
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, txID, id, recordType, persister, record);
        this.localJournal.appendUpdateRecordTransactional(txID, id, recordType, persister, record);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadTX) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure, fixbadTX);
    }

    @Override
    public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadTX) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure, fixbadTX);
    }

    @Override
    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        return this.localJournal.load(reloadManager);
    }

    @Override
    public void start() throws Exception {
        this.localJournal.start();
    }

    @Override
    public void stop() throws Exception {
        this.localJournal.stop();
    }

    @Override
    public int getAlignment() throws Exception {
        return this.localJournal.getAlignment();
    }

    @Override
    public boolean isStarted() {
        return this.localJournal.isStarted();
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        return this.localJournal.loadInternalOnly();
    }

    @Override
    public int getNumberOfRecords() {
        return this.localJournal.getNumberOfRecords();
    }

    @Override
    public int getUserVersion() {
        return this.localJournal.getUserVersion();
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        ((OperationContext)callback).replicationLineUp();
        this.localJournal.lineUpContext(callback);
    }

    @Override
    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return this.localJournal.loadSyncOnly(state);
    }

    @Override
    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException("This method should only be called at a replicating backup");
    }

    @Override
    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceMoveNextFile() throws Exception {
        this.localJournal.forceMoveNextFile();
    }

    @Override
    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFileSize() {
        return this.localJournal.getFileSize();
    }

    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        this.localJournal.scheduleCompactAndBlock(timeout);
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException("should never get called");
    }

    @Override
    public void replicationSyncFinished() {
        throw new UnsupportedOperationException("should never get called");
    }

    @Override
    public long getMaxRecordSize() {
        return this.localJournal.getMaxRecordSize();
    }
}

