/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpAcceptorHandler;

public class HttpKeepAliveRunnable
implements Runnable {
    private final List<HttpAcceptorHandler> handlers = new ArrayList<HttpAcceptorHandler>();
    private boolean closed = false;
    private Future<?> future;

    @Override
    public synchronized void run() {
        if (this.closed) {
            return;
        }
        long time = System.currentTimeMillis();
        for (HttpAcceptorHandler handler : this.handlers) {
            handler.keepAlive(time);
        }
    }

    public List<HttpAcceptorHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public synchronized void registerKeepAliveHandler(HttpAcceptorHandler httpAcceptorHandler) {
        this.handlers.add(httpAcceptorHandler);
    }

    public synchronized void unregisterKeepAliveHandler(HttpAcceptorHandler httpAcceptorHandler) {
        this.handlers.remove(httpAcceptorHandler);
        httpAcceptorHandler.shutdown();
    }

    public void close() {
        for (HttpAcceptorHandler handler : this.handlers) {
            handler.shutdown();
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.closed = true;
    }

    public synchronized void setFuture(Future<?> future) {
        this.future = future;
    }
}

