/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.invm;

import io.netty.channel.ChannelFutureListener;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public class InVMConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(InVMConnection.class);
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener listener;
    private final String id;
    private boolean closed;
    private static boolean flushEnabled = true;
    private final int serverID;
    private final Executor executor;
    private volatile boolean closing;
    private final ActiveMQPrincipal defaultActiveMQPrincipal;
    private RemotingConnection protocolConnection;
    private boolean bufferPoolingEnabled = true;
    private boolean directDeliver = false;

    public InVMConnection(int serverID, BufferHandler handler, BaseConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, UUIDGenerator.getInstance().generateSimpleStringUUID().toString(), handler, listener, executor);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, BaseConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, id, handler, listener, executor, null);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, BaseConnectionLifeCycleListener listener, Executor executor, ActiveMQPrincipal defaultActiveMQPrincipal) {
        this.serverID = serverID;
        this.handler = handler;
        this.listener = listener;
        this.id = id;
        this.executor = executor;
        this.defaultActiveMQPrincipal = defaultActiveMQPrincipal;
    }

    public void setEnableBufferPooling(boolean enableBufferPooling) {
        this.bufferPoolingEnabled = enableBufferPooling;
    }

    @Override
    public void forceClose() {
    }

    @Override
    public boolean isWritable(ReadyListener listener) {
        return true;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void fireReady(boolean ready) {
    }

    @Override
    public RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    @Override
    public void setProtocolConnection(RemotingConnection connection) {
        this.protocolConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        InVMConnection inVMConnection = this;
        synchronized (inVMConnection) {
            if (!this.closed) {
                this.listener.connectionDestroyed(this.id);
                this.closed = true;
            }
        }
    }

    @Override
    public void setAutoRead(boolean autoRead) {
    }

    @Override
    public ActiveMQBuffer createTransportBuffer(int size) {
        if (this.bufferPoolingEnabled) {
            return ActiveMQBuffers.pooledBuffer(size);
        }
        return ActiveMQBuffers.dynamicBuffer(size);
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public void checkFlushBatchBuffer() {
    }

    @Override
    public void write(ActiveMQBuffer buffer, boolean requestFlush) {
        this.write(buffer, false, false, null);
    }

    @Override
    public void write(ActiveMQBuffer buffer) {
        this.write(buffer, false, false, null);
    }

    @Override
    public void write(ActiveMQBuffer buffer, boolean flush, boolean batch) {
        this.write(buffer, flush, batch, null);
    }

    @Override
    public void write(final ActiveMQBuffer buffer, boolean flush, boolean batch, final ChannelFutureListener futureListener) {
        block5: {
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!InVMConnection.this.closed) {
                                buffer.readInt();
                                if (logger.isTraceEnabled()) {
                                    logger.trace(InVMConnection.this + "::Sending inVM packet");
                                }
                                InVMConnection.this.handler.bufferReceived(InVMConnection.this.id, buffer);
                                if (futureListener != null) {
                                    futureListener.operationComplete(null);
                                }
                            }
                        }
                        catch (Exception e) {
                            String msg = "Failed to write to handler on connector " + this;
                            ActiveMQServerLogger.LOGGER.errorWritingToInvmConnector(e, this);
                            throw new IllegalStateException(msg, e);
                        }
                        finally {
                            buffer.release();
                            if (logger.isTraceEnabled()) {
                                logger.trace(InVMConnection.this + "::packet sent done");
                            }
                        }
                    }
                });
                if (!flush || !flushEnabled) break block5;
                final CountDownLatch latch = new CountDownLatch(1);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                try {
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        ActiveMQServerLogger.LOGGER.timedOutFlushingInvmChannel();
                    }
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException(e);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        return "invm:" + this.serverID;
    }

    @Override
    public String getLocalAddress() {
        return "invm:" + this.serverID;
    }

    public int getBatchingBufferSize() {
        return -1;
    }

    @Override
    public boolean isUsingProtocolHandling() {
        return false;
    }

    @Override
    public ActiveMQPrincipal getDefaultActiveMQPrincipal() {
        return this.defaultActiveMQPrincipal;
    }

    public static void setFlushEnabled(boolean enable) {
        flushEnabled = enable;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public TransportConfiguration getConnectorConfig() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serverId", this.serverID);
        return new TransportConfiguration(InVMConnectorFactory.class.getName(), params);
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    public void setDirectDeliver(boolean directDeliver) {
        this.directDeliver = directDeliver;
    }

    public String toString() {
        return "InVMConnection [serverID=" + this.serverID + ", id=" + this.id + "]";
    }

    @Override
    public boolean isSameTarget(TransportConfiguration ... configs) {
        boolean result = false;
        for (TransportConfiguration cfg : configs) {
            if (cfg == null || !InVMConnectorFactory.class.getName().equals(cfg.getFactoryClassName()) || this.serverID != (Integer)cfg.getParams().get("serverId")) continue;
            result = true;
            break;
        }
        return result;
    }
}

