/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationLargeMessageWriteMessage
extends PacketImpl {
    private long messageId;
    private byte[] body;

    public ReplicationLargeMessageWriteMessage() {
        super((byte)101);
    }

    public ReplicationLargeMessageWriteMessage(long messageId, byte[] body2) {
        this();
        this.messageId = messageId;
        this.body = body2;
    }

    @Override
    public int expectedEncodeSize() {
        return 33 + this.body.length;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeInt(this.body.length);
        buffer.writeBytes(this.body);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.messageId = buffer.readLong();
        int size = buffer.readInt();
        this.body = new byte[size];
        buffer.readBytes(this.body);
    }

    public long getMessageId() {
        return this.messageId;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        return result;
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + "messageId=" + this.messageId + ", body.size=" + this.body.length;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationLargeMessageWriteMessage)) {
            return false;
        }
        ReplicationLargeMessageWriteMessage other = (ReplicationLargeMessageWriteMessage)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return this.messageId == other.messageId;
    }
}

