/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;

public final class AddressPartNode<T> {
    protected final String ANY_CHILD;
    protected final String ANY_DESCENDENT;
    private final AddressPartNode<T> parent;
    private final List<T> values = new CopyOnWriteArrayList<T>();
    private final Map<String, AddressPartNode<T>> childNodes = new ConcurrentHashMap<String, AddressPartNode<T>>();
    private final String path;

    public AddressPartNode(String path, AddressPartNode<T> parent) {
        this.parent = parent;
        this.ANY_DESCENDENT = parent.ANY_DESCENDENT;
        this.ANY_CHILD = parent.ANY_CHILD;
        this.path = this.ANY_DESCENDENT.equals(path) ? this.ANY_DESCENDENT : (this.ANY_CHILD.equals(path) ? this.ANY_CHILD : path);
    }

    public AddressPartNode(String anyDescendent, String anyChild) {
        this.ANY_DESCENDENT = anyDescendent;
        this.ANY_CHILD = anyChild;
        this.path = "Root";
        this.parent = null;
    }

    public AddressPartNode<T> getChild(String path) {
        return this.childNodes.get(path);
    }

    public Collection<AddressPartNode<T>> getChildren() {
        return this.childNodes.values();
    }

    public AddressPartNode<T> getChildOrCreate(String path) {
        AddressPartNode<T> answer = this.childNodes.get(path);
        if (answer == null) {
            answer = new AddressPartNode<T>(path, this);
            this.childNodes.put(path, answer);
        }
        return answer;
    }

    public void add(String[] paths, int idx, T value) {
        if (idx >= paths.length) {
            this.values.add(value);
        } else {
            this.getChildOrCreate(paths[idx]).add(paths, idx + 1, value);
        }
    }

    public void remove(String[] paths, int idx, T value) {
        if (idx >= paths.length) {
            this.values.remove(value);
            this.pruneIfEmpty();
        } else {
            this.getChildOrCreate(paths[idx]).remove(paths, idx + 1, value);
        }
    }

    public void visitDescendantNonWildcardValues(AddressMapVisitor<T> collector) throws Exception {
        this.visitValues(collector);
        for (AddressPartNode<T> child : this.childNodes.values()) {
            if (this.ANY_CHILD == child.getPath() || this.ANY_DESCENDENT == child.getPath()) continue;
            child.visitDescendantNonWildcardValues(collector);
        }
    }

    public void visitPathTailNonWildcard(String[] paths, int startIndex, AddressMapVisitor<T> collector) throws Exception {
        if (this.childNodes.isEmpty()) {
            return;
        }
        AddressPartNode<T> match = null;
        for (int i2 = startIndex; i2 < paths.length; ++i2) {
            match = this.getChild(paths[i2]);
            if (match == null || this.ANY_CHILD == match.getPath() || this.ANY_DESCENDENT == match.getPath()) continue;
            match.visitNonWildcard(paths, i2 + 1, collector);
            break;
        }
        for (AddressPartNode<T> child : this.childNodes.values()) {
            if (child == match || this.ANY_DESCENDENT == child.getPath() || this.ANY_CHILD == child.getPath()) continue;
            child.visitPathTailNonWildcard(paths, startIndex, collector);
        }
    }

    public void visitPathTailMatch(String[] paths, int startIndex, AddressMapVisitor<T> collector) throws Exception {
        if (this.childNodes.isEmpty()) {
            return;
        }
        ArrayList<AddressPartNode> visitedSet = new ArrayList<AddressPartNode>(paths.length);
        for (int i2 = startIndex; i2 < paths.length; ++i2) {
            AddressPartNode<T> match = this.getChild(paths[i2]);
            if (match == null) continue;
            match.visitMatchingWildcards(paths, i2 + 1, collector);
            visitedSet.add(match);
        }
        for (AddressPartNode<T> child : this.childNodes.values()) {
            if (this.alreadyVisited(child, visitedSet)) continue;
            child.visitPathTailMatch(paths, startIndex, collector);
        }
    }

    private boolean alreadyVisited(AddressPartNode<T> child, ArrayList<AddressPartNode> matches) {
        if (!matches.isEmpty()) {
            for (AddressPartNode alreadyMatched : matches) {
                if (child != alreadyMatched) continue;
                return true;
            }
        }
        return false;
    }

    public void visitNonWildcard(String[] paths, int startIndex, AddressMapVisitor<T> collector) throws Exception {
        String path;
        boolean canVisitAnyDescendent = true;
        AddressPartNode<T> node = this;
        int size = paths.length;
        for (int i2 = startIndex; i2 < size && node != null; node = node.getChild(path), ++i2) {
            path = paths[i2];
            if (this.ANY_DESCENDENT.equals(path) && i2 == size - 1) {
                node.visitDescendantNonWildcardValues(collector);
                canVisitAnyDescendent = false;
                break;
            }
            if (this.ANY_CHILD.equals(path)) {
                for (AddressPartNode<T> anyChild : node.getChildren()) {
                    if (this.ANY_CHILD == anyChild.getPath() || this.ANY_DESCENDENT == anyChild.getPath()) continue;
                    anyChild.visitNonWildcard(paths, i2 + 1, collector);
                }
                return;
            }
            if (!this.ANY_DESCENDENT.equals(path)) continue;
            node.visitValues(collector);
            node.visitPathTailNonWildcard(paths, i2 + 1, collector);
            return;
        }
        if (node != null && canVisitAnyDescendent) {
            node.visitValues(collector);
        }
    }

    public void visitMatchingWildcards(String[] paths, int startIndex, AddressMapVisitor<T> collector) throws Exception {
        boolean canVisitAnyDescendent = true;
        AddressPartNode<T> node = this;
        AddressPartNode<T> anyDescendentNode = null;
        AddressPartNode<T> anyChildNode = null;
        int size = paths.length;
        for (int i2 = startIndex; i2 < size && node != null; ++i2) {
            String path = paths[i2];
            anyDescendentNode = node.getChild(this.ANY_DESCENDENT);
            if (anyDescendentNode != null) {
                anyDescendentNode.visitValues(collector);
                anyDescendentNode.visitPathTailMatch(paths, i2, collector);
                canVisitAnyDescendent = false;
            }
            if ((anyChildNode = node.getChild(this.ANY_CHILD)) != null) {
                anyChildNode.visitMatchingWildcards(paths, i2 + 1, collector);
            }
            if ((node = node.getChild(path)) == null || node != anyChildNode && node != anyDescendentNode) continue;
            return;
        }
        if (node != null) {
            node.visitValues(collector);
            if (canVisitAnyDescendent && (anyDescendentNode = node.getChild(this.ANY_DESCENDENT)) != null) {
                anyDescendentNode.visitValues(collector);
            }
        }
    }

    public void visitValues(AddressMapVisitor<T> collector) throws Exception {
        for (T o : this.values) {
            collector.visit(o);
        }
    }

    public String getPath() {
        return this.path;
    }

    protected void pruneIfEmpty() {
        if (this.parent != null && this.childNodes.isEmpty() && this.values.isEmpty()) {
            this.parent.removeChild(this);
        }
    }

    protected void removeChild(AddressPartNode<T> node) {
        this.childNodes.remove(node.getPath());
        this.pruneIfEmpty();
    }

    public void reset() {
        this.values.clear();
        this.childNodes.clear();
    }
}

