/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;

public class QueueInfo
implements Serializable {
    private static final long serialVersionUID = 3451892849198803182L;
    private final SimpleString routingName;
    private final SimpleString clusterName;
    private final SimpleString address;
    private final SimpleString filterString;
    private final long id;
    private List<SimpleString> filterStrings;
    private volatile int consumersCount = 0;
    private static final AtomicIntegerFieldUpdater<QueueInfo> consumerUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueInfo.class, "consumersCount");
    private final int distance;

    public QueueInfo(SimpleString routingName, SimpleString clusterName, SimpleString address, SimpleString filterString, long id, int distance) {
        if (routingName == null) {
            throw ActiveMQMessageBundle.BUNDLE.routeNameIsNull();
        }
        if (clusterName == null) {
            throw ActiveMQMessageBundle.BUNDLE.clusterNameIsNull();
        }
        if (address == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressIsNull();
        }
        this.routingName = routingName;
        this.clusterName = clusterName;
        this.address = address;
        this.filterString = filterString;
        this.id = id;
        this.distance = distance;
    }

    public SimpleString getRoutingName() {
        return this.routingName;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public int getDistance() {
        return this.distance;
    }

    public long getID() {
        return this.id;
    }

    public List<SimpleString> getFilterStrings() {
        return this.filterStrings;
    }

    public void setFilterStrings(List<SimpleString> filterStrings) {
        this.filterStrings = filterStrings;
    }

    public int getNumberOfConsumers() {
        return consumerUpdater.get(this);
    }

    public void incrementConsumers() {
        consumerUpdater.incrementAndGet(this);
    }

    public void decrementConsumers() {
        consumerUpdater.getAndUpdate(this, value -> {
            if (value > 0) {
                return --value;
            }
            ActiveMQServerLogger.LOGGER.consumerCountError("Tried to decrement consumer count below 0: " + this);
            return value;
        });
    }

    public boolean matchesAddress(SimpleString address) {
        boolean containsAddress = false;
        if (address != null) {
            SimpleString addressPart;
            SimpleString[] split;
            SimpleString[] simpleStringArray = split = address.split(',');
            int n = simpleStringArray.length;
            for (int j = 0; j < n && !(containsAddress = address.startsWith(addressPart = simpleStringArray[j])); ++j) {
            }
        }
        return containsAddress;
    }

    public String toString() {
        return "QueueInfo [routingName=" + this.routingName + ", clusterName=" + this.clusterName + ", address=" + this.address + ", filterString=" + this.filterString + ", id=" + this.id + ", filterStrings=" + this.filterStrings + ", numberOfConsumers=" + this.consumersCount + ", distance=" + this.distance + "]";
    }
}

