/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class PageCountRecordInc
implements EncodingSupport {
    private long queueID;
    private int value;
    private long persistentSize;

    public String toString() {
        return "PageCountRecordInc [queueID=" + this.queueID + ", value=" + this.value + ", persistentSize=" + this.persistentSize + "]";
    }

    public PageCountRecordInc() {
    }

    public PageCountRecordInc(long queueID, int value, long persistentSize) {
        this.queueID = queueID;
        this.value = value;
        this.persistentSize = persistentSize;
    }

    public long getQueueID() {
        return this.queueID;
    }

    public int getValue() {
        return this.value;
    }

    public long getPersistentSize() {
        return this.persistentSize;
    }

    @Override
    public int getEncodeSize() {
        return 20;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.queueID);
        buffer.writeInt(this.value);
        buffer.writeLong(this.persistentSize);
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.queueID = buffer.readLong();
        this.value = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.persistentSize = buffer.readLong();
        }
    }
}

