/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class HeuristicCompletionEncoding
implements EncodingSupport {
    public Xid xid;
    public boolean isCommit;

    public String toString() {
        return "HeuristicCompletionEncoding [xid=" + this.xid + ", isCommit=" + this.isCommit + "]";
    }

    public HeuristicCompletionEncoding(Xid xid, boolean isCommit) {
        this.xid = xid;
        this.isCommit = isCommit;
    }

    public HeuristicCompletionEncoding() {
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.isCommit = buffer.readBoolean();
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.isCommit);
    }

    @Override
    public int getEncodeSize() {
        return XidCodecSupport.getXidEncodeLength(this.xid) + 1;
    }
}

