/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;

public class GroupingEncoding
implements EncodingSupport,
GroupingInfo {
    public long id;
    public SimpleString groupId;
    public SimpleString clusterName;

    public GroupingEncoding(long id, SimpleString groupId, SimpleString clusterName) {
        this.id = id;
        this.groupId = groupId;
        this.clusterName = clusterName;
    }

    public GroupingEncoding() {
    }

    @Override
    public int getEncodeSize() {
        return SimpleString.sizeofString(this.groupId) + SimpleString.sizeofString(this.clusterName);
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.groupId);
        buffer.writeSimpleString(this.clusterName);
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.groupId = buffer.readSimpleString();
        this.clusterName = buffer.readSimpleString();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public SimpleString getGroupId() {
        return this.groupId;
    }

    @Override
    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public String toString() {
        return "GroupingEncoding [id=" + this.id + ", groupId=" + this.groupId + ", clusterName=" + this.clusterName + "]";
    }
}

