/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class OperationContextImpl
implements OperationContext {
    private static final ThreadLocal<OperationContext> threadLocalContext = new ThreadLocal();
    LinkedList<TaskHolder> tasks;
    LinkedList<StoreOnlyTaskHolder> storeOnlyTasks;
    long minimalStore = Long.MAX_VALUE;
    long minimalReplicated = Long.MAX_VALUE;
    long minimalPage = Long.MAX_VALUE;
    static final AtomicIntegerFieldUpdater<OperationContextImpl> EXECUTORS_PENDING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OperationContextImpl.class, "executorsPendingField");
    static final AtomicLongFieldUpdater<OperationContextImpl> STORE_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "storeLineUpField");
    static final AtomicLongFieldUpdater<OperationContextImpl> REPLICATION_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "replicationLineUpField");
    static final AtomicLongFieldUpdater<OperationContextImpl> PAGE_LINEUP_UPDATER = AtomicLongFieldUpdater.newUpdater(OperationContextImpl.class, "pageLineUpField");
    volatile int executorsPendingField = 0;
    volatile long storeLineUpField = 0L;
    volatile long replicationLineUpField = 0L;
    volatile long pageLineUpField = 0L;
    long stored = 0L;
    long replicated = 0L;
    long paged = 0L;
    private int errorCode = -1;
    private String errorMessage = null;
    private final Executor executor;

    public static void clearContext() {
        threadLocalContext.set(null);
    }

    public static final OperationContext getContext() {
        return OperationContextImpl.getContext(null);
    }

    public static OperationContext getContext(ExecutorFactory executorFactory) {
        OperationContext token = threadLocalContext.get();
        if (token == null) {
            if (executorFactory == null) {
                return null;
            }
            token = new OperationContextImpl(executorFactory.getExecutor());
            threadLocalContext.set(token);
        }
        return token;
    }

    public static void setContext(OperationContext context) {
        threadLocalContext.set(context);
    }

    public OperationContextImpl(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void pageSyncLineUp() {
        PAGE_LINEUP_UPDATER.incrementAndGet(this);
    }

    @Override
    public synchronized void pageSyncDone() {
        ++this.paged;
        this.checkTasks();
    }

    @Override
    public void storeLineUp() {
        STORE_LINEUP_UPDATER.incrementAndGet(this);
    }

    @Override
    public void replicationLineUp() {
        REPLICATION_LINEUP_UPDATER.incrementAndGet(this);
    }

    @Override
    public synchronized void replicationDone() {
        ++this.replicated;
        this.checkTasks();
    }

    @Override
    public void executeOnCompletion(IOCallback runnable) {
        this.executeOnCompletion(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnCompletion(IOCallback completion, boolean storeOnly) {
        boolean executeNow = false;
        OperationContextImpl operationContextImpl = this;
        synchronized (operationContextImpl) {
            if (this.errorCode == -1) {
                long storeLined = STORE_LINEUP_UPDATER.get(this);
                long pageLined = PAGE_LINEUP_UPDATER.get(this);
                long replicationLined = REPLICATION_LINEUP_UPDATER.get(this);
                if (storeOnly) {
                    if (this.storeOnlyTasks == null) {
                        this.storeOnlyTasks = new LinkedList();
                    }
                } else if (this.tasks == null) {
                    this.tasks = new LinkedList();
                    this.minimalReplicated = replicationLined;
                    this.minimalStore = storeLined;
                    this.minimalPage = pageLined;
                }
                if (replicationLined == this.replicated && storeLined == this.stored && pageLined == this.paged) {
                    if (EXECUTORS_PENDING_UPDATER.get(this) == 0) {
                        executeNow = true;
                    } else {
                        this.execute(completion);
                    }
                } else if (storeOnly) {
                    assert (this.storeOnlyTasks.isEmpty() || this.storeOnlyTasks.peekLast().storeLined <= storeLined);
                    this.storeOnlyTasks.add(new StoreOnlyTaskHolder(completion, storeLined));
                } else {
                    assert (this.validateTasksAdd(storeLined, replicationLined, pageLined));
                    this.tasks.add(new TaskHolder(completion, storeLined, replicationLined, pageLined));
                }
            }
        }
        if (this.errorCode != -1) {
            completion.onError(this.errorCode, this.errorMessage);
        } else if (executeNow) {
            completion.done();
        }
    }

    private boolean validateTasksAdd(long storeLined, long replicationLined, long pageLined) {
        if (this.tasks.isEmpty()) {
            return true;
        }
        TaskHolder holder = this.tasks.peekLast();
        return holder.storeLined <= storeLined && holder.replicationLined <= replicationLined && holder.pageLined <= pageLined;
    }

    @Override
    public synchronized void done() {
        ++this.stored;
        this.checkTasks();
    }

    private void checkStoreTasks() {
        LinkedList<StoreOnlyTaskHolder> storeOnlyTasks = this.storeOnlyTasks;
        assert (storeOnlyTasks != null);
        int size = storeOnlyTasks.size();
        if (size == 0) {
            return;
        }
        long stored = this.stored;
        for (int i2 = 0; i2 < size; ++i2) {
            StoreOnlyTaskHolder holder = storeOnlyTasks.peek();
            if (stored < holder.storeLined) {
                return;
            }
            this.execute(holder.task);
            StoreOnlyTaskHolder removed = storeOnlyTasks.poll();
            assert (removed == holder);
        }
    }

    private void checkCompleteContext() {
        LinkedList<TaskHolder> tasks = this.tasks;
        assert (tasks != null);
        int size = this.tasks.size();
        if (size == 0) {
            return;
        }
        assert (size >= 1);
        for (int i2 = 0; i2 < size; ++i2) {
            TaskHolder holder = tasks.peek();
            if (this.stored < holder.storeLined || this.replicated < holder.replicationLined || this.paged < holder.pageLined) {
                return;
            }
            this.execute(holder.task);
            TaskHolder removed = tasks.poll();
            assert (removed == holder);
        }
    }

    private void checkTasks() {
        if (this.storeOnlyTasks != null) {
            this.checkStoreTasks();
        }
        if (this.stored >= this.minimalStore && this.replicated >= this.minimalReplicated && this.paged >= this.minimalPage) {
            this.checkCompleteContext();
        }
    }

    private void execute(final IOCallback task) {
        EXECUTORS_PENDING_UPDATER.incrementAndGet(this);
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        OperationContextImpl.clearContext();
                        task.done();
                    }
                    finally {
                        EXECUTORS_PENDING_UPDATER.decrementAndGet(OperationContextImpl.this);
                    }
                }
            });
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorExecutingAIOCallback(e);
            EXECUTORS_PENDING_UPDATER.decrementAndGet(this);
            task.onError(ActiveMQExceptionType.INTERNAL_ERROR.getCode(), "It wasn't possible to complete IO operation - " + e.getMessage());
        }
    }

    public void complete() {
    }

    @Override
    public synchronized void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        if (this.tasks != null) {
            int size = this.tasks.size();
            for (int i2 = 0; i2 < size; ++i2) {
                TaskHolder holder = this.tasks.poll();
                holder.task.onError(errorCode, errorMessage);
            }
        }
    }

    @Override
    public void waitCompletion() throws Exception {
        this.waitCompletion(0L);
    }

    @Override
    public boolean waitCompletion(long timeout) throws InterruptedException, ActiveMQException {
        SimpleWaitIOCallback waitCallback = new SimpleWaitIOCallback();
        this.executeOnCompletion(waitCallback);
        this.complete();
        if (timeout == 0L) {
            waitCallback.waitCompletion();
            return true;
        }
        return waitCallback.waitCompletion(timeout);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.tasks != null) {
            for (TaskHolder hold : this.tasks) {
                buffer.append("Task = " + hold + "\n");
            }
        }
        return "OperationContextImpl [" + this.hashCode() + "] [minimalStore=" + this.minimalStore + ", storeLineUp=" + this.storeLineUpField + ", stored=" + this.stored + ", minimalReplicated=" + this.minimalReplicated + ", replicationLineUp=" + this.replicationLineUpField + ", replicated=" + this.replicated + ", paged=" + this.paged + ", minimalPage=" + this.minimalPage + ", pageLineUp=" + this.pageLineUpField + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", executorsPending=" + this.executorsPendingField + ", executor=" + this.executor + "]" + buffer.toString();
    }

    static final class StoreOnlyTaskHolder {
        long storeLined;
        final IOCallback task;

        public String toString() {
            return "StoreOnlyTaskHolder [storeLined=" + this.storeLined + ", task=" + this.task + "]";
        }

        StoreOnlyTaskHolder(IOCallback task, long storeLined) {
            this.storeLined = storeLined;
            this.task = task;
        }
    }

    static final class TaskHolder {
        long storeLined;
        long replicationLined;
        long pageLined;
        final IOCallback task;

        public String toString() {
            return "TaskHolder [storeLined=" + this.storeLined + ", replicationLined=" + this.replicationLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        TaskHolder(IOCallback task, long storeLined, long replicationLined, long pageLined) {
            this.storeLined = storeLined;
            this.replicationLined = replicationLined;
            this.pageLined = pageLined;
            this.task = task;
        }
    }
}

