/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

public class LargeMessageTXFailureCallback
implements TransactionFailureCallback {
    private AbstractJournalStorageManager journalStorageManager;

    public LargeMessageTXFailureCallback(AbstractJournalStorageManager journalStorageManager) {
        this.journalStorageManager = journalStorageManager;
    }

    @Override
    public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        for (RecordInfo record : records) {
            if (record.userRecordType != 30) continue;
            byte[] data = record.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer(data);
            try {
                LargeServerMessage serverMessage = this.journalStorageManager.parseLargeMessage(buff);
                serverMessage.toMessage().usageDown();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.journalError(e);
            }
        }
    }
}

