/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class BufferSplitter {
    public static void split(ActiveMQBuffer buffer, int splitSize, Consumer<EncodingSupport> target) {
        byte[] bytesBuffer = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), bytesBuffer);
        BufferSplitter.split(bytesBuffer, splitSize, target);
    }

    public static void split(byte[] buffer, int splitSize, Consumer<EncodingSupport> target) {
        int maxSize;
        for (int location = 0; location < buffer.length; location += maxSize) {
            maxSize = Math.min(splitSize, buffer.length - location);
            target.accept(new PartialEncoding(buffer, location, maxSize));
        }
    }

    protected static class PartialEncoding
    implements EncodingSupport {
        final byte[] data;
        final int begin;
        final int length;

        public PartialEncoding(byte[] data, int begin, int length) {
            this.data = data;
            this.begin = begin;
            this.length = length;
        }

        @Override
        public void decode(ActiveMQBuffer buffer) {
            throw new IllegalStateException("operation not supported");
        }

        @Override
        public void encode(ActiveMQBuffer buffer) {
            buffer.writeBytes(this.data, this.begin, this.length);
        }

        @Override
        public int getEncodeSize() {
            return this.length;
        }
    }
}

