/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class PersistedSecuritySetting
implements EncodingSupport {
    private long storeId;
    private SimpleString addressMatch;
    private SimpleString sendRoles;
    private SimpleString consumeRoles;
    private SimpleString createDurableQueueRoles;
    private SimpleString deleteDurableQueueRoles;
    private SimpleString createNonDurableQueueRoles;
    private SimpleString deleteNonDurableQueueRoles;
    private SimpleString manageRoles;
    private SimpleString browseRoles;
    private SimpleString createAddressRoles;
    private SimpleString deleteAddressRoles;

    public PersistedSecuritySetting() {
    }

    public PersistedSecuritySetting(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles) {
        this.addressMatch = SimpleString.toSimpleString(addressMatch);
        this.sendRoles = SimpleString.toSimpleString(sendRoles);
        this.consumeRoles = SimpleString.toSimpleString(consumeRoles);
        this.createDurableQueueRoles = SimpleString.toSimpleString(createDurableQueueRoles);
        this.deleteDurableQueueRoles = SimpleString.toSimpleString(deleteDurableQueueRoles);
        this.createNonDurableQueueRoles = SimpleString.toSimpleString(createNonDurableQueueRoles);
        this.deleteNonDurableQueueRoles = SimpleString.toSimpleString(deleteNonDurableQueueRoles);
        this.manageRoles = SimpleString.toSimpleString(manageRoles);
        this.browseRoles = SimpleString.toSimpleString(browseRoles);
        this.createAddressRoles = SimpleString.toSimpleString(createAddressRoles);
        this.deleteAddressRoles = SimpleString.toSimpleString(deleteAddressRoles);
    }

    public long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public SimpleString getAddressMatch() {
        return this.addressMatch;
    }

    public String getSendRoles() {
        return this.sendRoles != null ? this.sendRoles.toString() : null;
    }

    public String getConsumeRoles() {
        return this.consumeRoles != null ? this.consumeRoles.toString() : null;
    }

    public String getCreateDurableQueueRoles() {
        return this.createDurableQueueRoles != null ? this.createDurableQueueRoles.toString() : null;
    }

    public String getDeleteDurableQueueRoles() {
        return this.deleteDurableQueueRoles != null ? this.deleteDurableQueueRoles.toString() : null;
    }

    public String getCreateNonDurableQueueRoles() {
        return this.createNonDurableQueueRoles != null ? this.createNonDurableQueueRoles.toString() : null;
    }

    public String getDeleteNonDurableQueueRoles() {
        return this.deleteNonDurableQueueRoles != null ? this.deleteNonDurableQueueRoles.toString() : null;
    }

    public String getManageRoles() {
        return this.manageRoles != null ? this.manageRoles.toString() : null;
    }

    public String getBrowseRoles() {
        return this.browseRoles != null ? this.browseRoles.toString() : null;
    }

    public String getCreateAddressRoles() {
        return this.createAddressRoles != null ? this.createAddressRoles.toString() : null;
    }

    public String getDeleteAddressRoles() {
        return this.deleteAddressRoles != null ? this.deleteAddressRoles.toString() : null;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        if (this.addressMatch == null) {
            this.addressMatch = new SimpleString("");
        }
        buffer.writeSimpleString(this.addressMatch);
        buffer.writeNullableSimpleString(this.sendRoles);
        buffer.writeNullableSimpleString(this.consumeRoles);
        buffer.writeNullableSimpleString(this.createDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteDurableQueueRoles);
        buffer.writeNullableSimpleString(this.createNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.manageRoles);
        buffer.writeNullableSimpleString(this.browseRoles);
        buffer.writeNullableSimpleString(this.createAddressRoles);
        buffer.writeNullableSimpleString(this.deleteAddressRoles);
    }

    @Override
    public int getEncodeSize() {
        return (this.addressMatch == null ? 4 : this.addressMatch.sizeof()) + (this.sendRoles == null ? 1 : SimpleString.sizeofNullableString(this.sendRoles)) + (this.consumeRoles == null ? 1 : SimpleString.sizeofNullableString(this.consumeRoles)) + (this.createDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString(this.createDurableQueueRoles)) + (this.deleteDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString(this.deleteDurableQueueRoles)) + (this.createNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString(this.createNonDurableQueueRoles)) + (this.deleteNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString(this.deleteNonDurableQueueRoles)) + (this.manageRoles == null ? 1 : SimpleString.sizeofNullableString(this.manageRoles)) + (this.browseRoles == null ? 1 : SimpleString.sizeofNullableString(this.browseRoles)) + (this.createAddressRoles == null ? 1 : SimpleString.sizeofNullableString(this.createAddressRoles)) + (this.deleteAddressRoles == null ? 1 : SimpleString.sizeofNullableString(this.deleteAddressRoles));
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.sendRoles = buffer.readNullableSimpleString();
        this.consumeRoles = buffer.readNullableSimpleString();
        this.createDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteDurableQueueRoles = buffer.readNullableSimpleString();
        this.createNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.manageRoles = buffer.readNullableSimpleString();
        this.browseRoles = buffer.readNullableSimpleString();
        this.createAddressRoles = buffer.readNullableSimpleString();
        this.deleteAddressRoles = buffer.readNullableSimpleString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressMatch == null ? 0 : this.addressMatch.hashCode());
        result = 31 * result + (this.consumeRoles == null ? 0 : this.consumeRoles.hashCode());
        result = 31 * result + (this.createDurableQueueRoles == null ? 0 : this.createDurableQueueRoles.hashCode());
        result = 31 * result + (this.createNonDurableQueueRoles == null ? 0 : this.createNonDurableQueueRoles.hashCode());
        result = 31 * result + (this.deleteDurableQueueRoles == null ? 0 : this.deleteDurableQueueRoles.hashCode());
        result = 31 * result + (this.deleteNonDurableQueueRoles == null ? 0 : this.deleteNonDurableQueueRoles.hashCode());
        result = 31 * result + (this.manageRoles == null ? 0 : this.manageRoles.hashCode());
        result = 31 * result + (this.browseRoles == null ? 0 : this.browseRoles.hashCode());
        result = 31 * result + (this.createAddressRoles == null ? 0 : this.createAddressRoles.hashCode());
        result = 31 * result + (this.deleteAddressRoles == null ? 0 : this.deleteAddressRoles.hashCode());
        result = 31 * result + (this.sendRoles == null ? 0 : this.sendRoles.hashCode());
        result = 31 * result + (int)(this.storeId ^ this.storeId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistedSecuritySetting other = (PersistedSecuritySetting)obj;
        if (this.addressMatch == null ? other.addressMatch != null : !this.addressMatch.equals(other.addressMatch)) {
            return false;
        }
        if (this.consumeRoles == null ? other.consumeRoles != null : !this.consumeRoles.equals(other.consumeRoles)) {
            return false;
        }
        if (this.createDurableQueueRoles == null ? other.createDurableQueueRoles != null : !this.createDurableQueueRoles.equals(other.createDurableQueueRoles)) {
            return false;
        }
        if (this.createNonDurableQueueRoles == null ? other.createNonDurableQueueRoles != null : !this.createNonDurableQueueRoles.equals(other.createNonDurableQueueRoles)) {
            return false;
        }
        if (this.deleteDurableQueueRoles == null ? other.deleteDurableQueueRoles != null : !this.deleteDurableQueueRoles.equals(other.deleteDurableQueueRoles)) {
            return false;
        }
        if (this.deleteNonDurableQueueRoles == null ? other.deleteNonDurableQueueRoles != null : !this.deleteNonDurableQueueRoles.equals(other.deleteNonDurableQueueRoles)) {
            return false;
        }
        if (this.manageRoles == null ? other.manageRoles != null : !this.manageRoles.equals(other.manageRoles)) {
            return false;
        }
        if (this.browseRoles == null ? other.browseRoles != null : !this.browseRoles.equals(other.browseRoles)) {
            return false;
        }
        if (this.createAddressRoles == null ? other.createAddressRoles != null : !this.createAddressRoles.equals(other.createAddressRoles)) {
            return false;
        }
        if (this.deleteAddressRoles == null ? other.deleteAddressRoles != null : !this.deleteAddressRoles.equals(other.deleteAddressRoles)) {
            return false;
        }
        if (this.sendRoles == null ? other.sendRoles != null : !this.sendRoles.equals(other.sendRoles)) {
            return false;
        }
        return this.storeId == other.storeId;
    }

    public String toString() {
        return "PersistedSecuritySetting [storeId=" + this.storeId + ", addressMatch=" + this.addressMatch + ", sendRoles=" + this.sendRoles + ", consumeRoles=" + this.consumeRoles + ", createDurableQueueRoles=" + this.createDurableQueueRoles + ", deleteDurableQueueRoles=" + this.deleteDurableQueueRoles + ", createNonDurableQueueRoles=" + this.createNonDurableQueueRoles + ", deleteNonDurableQueueRoles=" + this.deleteNonDurableQueueRoles + ", manageRoles=" + this.manageRoles + ", browseRoles=" + this.browseRoles + ", createAddressRoles=" + this.createAddressRoles + ", deleteAddressRoles=" + this.deleteAddressRoles + "]";
    }
}

