/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Collections;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.transformer.RegisteredTransformer;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.logs.AuditLogger;

public class DivertControlImpl
extends AbstractControl
implements DivertControl {
    private final Divert divert;
    private final String internalNamingPrefix;

    public DivertControlImpl(Divert divert, StorageManager storageManager, String internalNamingPrefix) throws Exception {
        super(DivertControl.class, storageManager);
        this.divert = divert;
        this.internalNamingPrefix = internalNamingPrefix;
    }

    @Override
    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress(this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getAddress().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFilter() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilter(this.divert);
        }
        this.clearIO();
        try {
            Filter filter2 = this.divert.getFilter();
            String string = filter2 != null ? filter2.getFilterString().toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getForwardingAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getForwardingAddress(this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getForwardAddress().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRoutingName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingName(this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getRoutingName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getTransformerClassName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerClassName(this.divert);
        }
        this.clearIO();
        try {
            Transformer transformer = this.divert.getTransformer();
            String string = transformer != null ? (transformer instanceof RegisteredTransformer ? ((RegisteredTransformer)transformer).getTransformer() : transformer).getClass().getName() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getTransformerPropertiesAsJSON() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerPropertiesAsJSON(this.divert);
        }
        return JsonUtil.toJsonObject(this.getTransformerProperties()).toString();
    }

    @Override
    public Map<String, String> getTransformerProperties() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerProperties(this.divert);
        }
        this.clearIO();
        try {
            Transformer transformer = this.divert.getTransformer();
            Map<String, String> map = transformer != null && transformer instanceof RegisteredTransformer ? ((RegisteredTransformer)transformer).getProperties() : Collections.emptyMap();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRoutingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingType(this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getUniqueName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getUniqueName(this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getUniqueName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isExclusive() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isExclusive(this.divert);
        }
        this.clearIO();
        try {
            boolean bl = this.divert.isExclusive();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isRetroactiveResource() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isRetroactiveResource(this.divert);
        }
        return ResourceNames.isRetroactiveResource(this.internalNamingPrefix, this.divert.getUniqueName());
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(DivertControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(DivertControl.class);
    }
}

