/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.logs.AuditLogger;

public class ClusterConnectionControlImpl
extends AbstractControl
implements ClusterConnectionControl {
    private final ClusterConnection clusterConnection;
    private final ClusterConnectionConfiguration configuration;

    public ClusterConnectionControlImpl(ClusterConnection clusterConnection, StorageManager storageManager, ClusterConnectionConfiguration configuration) throws Exception {
        super(ClusterConnectionControl.class, storageManager);
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
    }

    @Override
    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getDiscoveryGroupName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDiscoveryGroupName(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getMaxHops() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxHops(this.clusterConnection);
        }
        this.clearIO();
        try {
            int n = this.configuration.getMaxHops();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getRetryInterval() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRetryInterval(this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getNodeID() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNodeID(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.clusterConnection.getNodeID();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getStaticConnectors() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getStaticConnectors(this.clusterConnection);
        }
        this.clearIO();
        try {
            List<String> staticConnectors = this.configuration.getStaticConnectors();
            if (staticConnectors == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = staticConnectors.toArray(new String[staticConnectors.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getStaticConnectorsAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getStaticConnectorsAsJSON(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = JsonUtil.toJsonArray(this.configuration.getStaticConnectors()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isDuplicateDetection() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isDuplicateDetection(this.clusterConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.configuration.isDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getMessageLoadBalancingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessageLoadBalancingType(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getMessageLoadBalancingType().getType();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getTopology() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTopology(this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.clusterConnection.getTopology().describe();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public Map<String, String> getNodes() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNodes(this.clusterConnection);
        }
        this.clearIO();
        try {
            Map<String, String> map = this.clusterConnection.getNodes();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStarted(this.clusterConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.clusterConnection.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startClusterConnection(this.clusterConnection);
        }
        this.clearIO();
        try {
            this.clusterConnection.start();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopClusterConnection(this.clusterConnection);
        }
        this.clearIO();
        try {
            this.clusterConnection.stop();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ClusterConnectionControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(ClusterConnectionControl.class);
    }

    @Override
    public long getMessagesPendingAcknowledgement() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesPendingAcknowledgement(this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.clusterConnection.getMetrics().getMessagesPendingAcknowledgement();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesAcknowledged() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAcknowledged(this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.clusterConnection.getMetrics().getMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMetrics(this.clusterConnection);
        }
        this.clearIO();
        try {
            Map<String, Object> map = this.clusterConnection.getMetrics().convertToMap();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getBridgeMetrics(String nodeId) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getBridgeMetrics(this.clusterConnection, nodeId);
        }
        this.clearIO();
        try {
            BridgeMetrics bridgeMetrics = this.clusterConnection.getBridgeMetrics(nodeId);
            Map<String, Object> map = bridgeMetrics != null ? bridgeMetrics.convertToMap() : null;
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }
}

