/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.logs.AuditLogger;

public class BridgeControlImpl
extends AbstractControl
implements BridgeControl {
    private final Bridge bridge;
    private final BridgeConfiguration configuration;

    public BridgeControlImpl(Bridge bridge, StorageManager storageManager, BridgeConfiguration configuration) throws Exception {
        super(BridgeControl.class, storageManager);
        this.bridge = bridge;
        this.configuration = configuration;
    }

    @Override
    public String[] getStaticConnectors() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getStaticConnectors(this.bridge);
        }
        this.clearIO();
        try {
            List<String> staticConnectors = this.configuration.getStaticConnectors();
            String[] stringArray = staticConnectors.toArray(new String[staticConnectors.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getForwardingAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getForwardingAddress(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getForwardingAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getQueueName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getQueueName(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getQueueName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getDiscoveryGroupName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDiscoveryGroupName(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFilterString() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilterString(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getReconnectAttempts() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getReconnectAttempts(this.bridge);
        }
        this.clearIO();
        try {
            int n = this.configuration.getReconnectAttempts();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getRetryInterval() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRetryInterval(this.bridge);
        }
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public double getRetryIntervalMultiplier() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRetryIntervalMultiplier(this.bridge);
        }
        this.clearIO();
        try {
            double d = this.configuration.getRetryIntervalMultiplier();
            return d;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMaxRetryInterval() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxRetryInterval(this.bridge);
        }
        this.clearIO();
        try {
            long l = this.configuration.getMaxRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getTransformerClassName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerClassName(this.bridge);
        }
        this.clearIO();
        try {
            String string = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getTransformerPropertiesAsJSON() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerPropertiesAsJSON(this.bridge);
        }
        return JsonUtil.toJsonObject(this.getTransformerProperties()).toString();
    }

    @Override
    public Map<String, String> getTransformerProperties() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTransformerProperties(this.bridge);
        }
        this.clearIO();
        try {
            Map<String, String> map = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getProperties();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStartedBridge(this.bridge);
        }
        this.clearIO();
        try {
            boolean bl = this.bridge.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isUseDuplicateDetection() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isUseDuplicateDetection(this.bridge);
        }
        this.clearIO();
        try {
            boolean bl = this.configuration.isUseDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isHA() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isHA(this.bridge);
        }
        this.clearIO();
        try {
            boolean bl = this.configuration.isHA();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startBridge(this.bridge);
        }
        this.clearIO();
        try {
            this.bridge.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopBridge(this.bridge);
        }
        this.clearIO();
        try {
            this.bridge.stop();
            this.bridge.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BridgeControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(BridgeControl.class);
    }

    @Override
    public long getMessagesPendingAcknowledgement() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesPendingAcknowledgement(this.bridge);
        }
        this.clearIO();
        try {
            long l = this.bridge.getMetrics().getMessagesPendingAcknowledgement();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesAcknowledged() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAcknowledged(this.bridge);
        }
        this.clearIO();
        try {
            long l = this.bridge.getMetrics().getMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMetrics(this.bridge);
        }
        this.clearIO();
        try {
            Map<String, Object> map = this.bridge.getMetrics().convertToMap();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }
}

