/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.jboss.logging.Logger;

public final class Reclaimer {
    private static final Logger logger = Logger.getLogger(Reclaimer.class);

    private Reclaimer() {
    }

    public static void scan(JournalFile[] files) {
        for (int i2 = 0; i2 < files.length; ++i2) {
            JournalFile currentFile = files[i2];
            if (!currentFile.isNegReclaimCriteria()) {
                boolean outstandingNeg = false;
                for (int j = i2 - 1; j >= 0 && !outstandingNeg; --j) {
                    JournalFile file = files[j];
                    if (file.isCanReclaim() || currentFile.getNegCount(file) == 0) continue;
                    logger.tracef("%s can't be reclaimed because %s has negative values", (Object)currentFile, (Object)file);
                    outstandingNeg = true;
                }
                if (outstandingNeg) continue;
                currentFile.setNegReclaimCriteria();
            }
            if (currentFile.isPosReclaimCriteria()) continue;
            int negCount = 0;
            int posCount = currentFile.getPosCount();
            logger.tracef("posCount on %s = %d", (Object)currentFile, (Object)posCount);
            for (int j = i2; j < files.length && negCount < posCount; ++j) {
                int toNeg = files[j].getNegCount(currentFile);
                negCount += toNeg;
                if (!logger.isTraceEnabled() || toNeg == 0) continue;
                logger.tracef("Negative from %s into %s = %d", (Object)files[j], (Object)currentFile, (Object)toNeg);
            }
            if (negCount < posCount) {
                logger.tracef("%s can't be reclaimed because there are not enough negatives %d", (Object)currentFile, (Object)negCount);
                continue;
            }
            logger.tracef("%s can be reclaimed", (Object)currentFile);
            currentFile.setPosReclaimCriteria();
        }
    }
}

