/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.util;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.activemq.artemis.core.io.util.ByteBufferPool;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.PowerOf2Util;

final class ThreadLocalByteBufferPool
implements ByteBufferPool {
    private final ThreadLocal<ByteBuffer> bytesPool = new ThreadLocal();
    private final boolean direct;

    ThreadLocalByteBufferPool(boolean direct) {
        this.direct = direct;
    }

    @Override
    public ByteBuffer borrow(int size, boolean zeroed) {
        int requiredCapacity = PowerOf2Util.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = this.bytesPool.get();
        if (byteBuffer == null || requiredCapacity > byteBuffer.capacity()) {
            byteBuffer = this.direct ? ByteBuffer.allocateDirect(requiredCapacity) : ByteBuffer.allocate(requiredCapacity);
        } else {
            this.bytesPool.set(null);
            if (zeroed) {
                ByteUtil.zeros(byteBuffer, 0, size);
            }
            byteBuffer.clear();
        }
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        Objects.requireNonNull(buffer);
        boolean directBuffer = buffer.isDirect();
        if (directBuffer == this.direct && !buffer.isReadOnly() && (byteBuffer = this.bytesPool.get()) != buffer) {
            if (byteBuffer == null || buffer.capacity() > byteBuffer.capacity()) {
                if (byteBuffer != null && directBuffer) {
                    PlatformDependent.freeDirectBuffer(byteBuffer);
                }
                this.bytesPool.set(buffer);
            } else if (directBuffer) {
                PlatformDependent.freeDirectBuffer(buffer);
            }
        }
    }
}

