/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFile;
import org.apache.activemq.artemis.core.io.mapped.TimedSequentialFile;
import org.apache.activemq.artemis.core.io.util.ByteBufferPool;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.PowerOf2Util;

public final class MappedSequentialFileFactory
extends AbstractSequentialFileFactory {
    private int capacity;
    private boolean bufferPooling;
    private final ByteBufferPool bytesPool;

    public MappedSequentialFileFactory(File directory, int capacity, boolean buffered, int bufferSize, int bufferTimeout, IOCriticalErrorListener criticalErrorListener) {
        super(directory, buffered, bufferSize, bufferTimeout, 1, false, criticalErrorListener, null);
        this.capacity = capacity;
        this.setDatasync(true);
        this.bufferPooling = true;
        this.bytesPool = ByteBufferPool.threadLocal(true);
    }

    public MappedSequentialFileFactory capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return this.createSequentialFile(fileName, this.capacity);
    }

    @Override
    public SequentialFile createSequentialFile(String fileName, int capacity) {
        MappedSequentialFile mappedSequentialFile = new MappedSequentialFile(this, this.journalDir, new File(this.journalDir, fileName), capacity, this.critialErrorListener);
        if (this.timedBuffer == null) {
            return mappedSequentialFile;
        }
        return new TimedSequentialFile(this, mappedSequentialFile);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int requiredCapacity = PowerOf2Util.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer(buffer);
    }

    public MappedSequentialFileFactory enableBufferReuse() {
        this.bufferPooling = true;
        return this;
    }

    public MappedSequentialFileFactory disableBufferReuse() {
        this.bufferPooling = false;
        return this;
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return this.newBuffer(size, true);
    }

    @Override
    public ByteBuffer newBuffer(int size, boolean zeroed) {
        if (!this.bufferPooling) {
            return this.allocateDirectBuffer(size);
        }
        return this.bytesPool.borrow(size, zeroed);
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        if (this.bufferPooling) {
            this.bytesPool.release(buffer);
        }
    }

    @Override
    public MappedSequentialFileFactory setDatasync(boolean enabled) {
        super.setDatasync(enabled);
        return this;
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    @Deprecated
    public MappedSequentialFileFactory setAlignment(int alignment) {
        throw new UnsupportedOperationException("alignment can't be changed!");
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        ByteUtil.zeros(buffer);
        buffer.rewind();
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
    }
}

