/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.PowerOf2Util;
import org.jboss.logging.Logger;

final class MappedFile
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(MappedFile.class);
    private static final int OS_PAGE_SIZE = Env.osPageSize();
    private final MappedByteBuffer buffer;
    private final FileChannel channel;
    private final long address;
    private final ByteBuf byteBufWrapper;
    private final ChannelBufferWrapper channelBufferWrapper;
    private int position;
    private int length;

    private MappedFile(FileChannel channel, MappedByteBuffer byteBuffer, int position, int length) throws IOException {
        this.channel = channel;
        this.buffer = byteBuffer;
        this.position = position;
        this.length = length;
        this.byteBufWrapper = Unpooled.wrappedBuffer((ByteBuffer)this.buffer);
        this.channelBufferWrapper = new ChannelBufferWrapper(this.byteBufWrapper, false);
        this.address = PlatformDependent.directBufferAddress(this.buffer);
    }

    public static MappedFile of(File file, int position, int capacity) throws IOException {
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        int length = (int)channel.size();
        if (length != capacity && length != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adjusting capacity to " + length + " while it was " + capacity + " on file " + file);
            }
            capacity = length;
        }
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, position, capacity);
        return new MappedFile(channel, buffer, 0, length);
    }

    public FileChannel channel() {
        return this.channel;
    }

    public MappedByteBuffer mapped() {
        return this.buffer;
    }

    public long address() {
        return this.address;
    }

    public void force() {
        this.buffer.force();
    }

    private void checkCapacity(int requiredCapacity) {
        if (requiredCapacity < 0 || requiredCapacity > this.buffer.capacity()) {
            throw new IllegalStateException("requiredCapacity must be >0 and <= " + this.buffer.capacity());
        }
    }

    private void rawMovePositionAndLength(int position) {
        this.position = position;
        if (position > this.length) {
            this.length = position;
        }
    }

    public int read(ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int remaining = this.length - this.position;
        int read = Math.min(remaining, dstLength);
        long srcAddress = this.address + (long)this.position;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress(dst) + (long)dstStart;
            PlatformDependent.copyMemory(srcAddress, dstAddress, read);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory(srcAddress, dstArray, dstStart, (long)read);
        }
        this.position += read;
        return read;
    }

    public void write(EncodingSupport encodingSupport) throws IOException {
        int encodedSize = encodingSupport.getEncodeSize();
        int nextPosition = this.position + encodedSize;
        this.checkCapacity(nextPosition);
        this.byteBufWrapper.setIndex(this.position, this.position);
        encodingSupport.encode(this.channelBufferWrapper);
        this.rawMovePositionAndLength(nextPosition);
        assert (this.byteBufWrapper.writerIndex() == this.position);
    }

    public void write(ByteBuf src, int srcStart, int srcLength) throws IOException {
        int nextPosition = this.position + srcLength;
        this.checkCapacity(nextPosition);
        long destAddress = this.address + (long)this.position;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory(srcAddress, destAddress, srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory(srcArray, srcStart, destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.rawMovePositionAndLength(nextPosition);
    }

    public void write(ByteBuffer src, int srcStart, int srcLength) throws IOException {
        int nextPosition = this.position + srcLength;
        this.checkCapacity(nextPosition);
        long destAddress = this.address + (long)this.position;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress(src) + (long)srcStart;
            PlatformDependent.copyMemory(srcAddress, destAddress, srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory(srcArray, srcStart, destAddress, (long)srcLength);
        }
        this.rawMovePositionAndLength(nextPosition);
    }

    public void zeros(int position, int count) throws IOException {
        this.checkCapacity(position + count);
        long start = this.address + (long)position;
        long end = start + (long)count;
        int toZeros = count;
        long lastGap = (int)(end & (long)(OS_PAGE_SIZE - 1));
        long lastStartPage = end - lastGap;
        long lastZeroed = end;
        if (start <= lastStartPage && lastGap > 0L) {
            PlatformDependent.setMemory(lastStartPage, lastGap, (byte)0);
            lastZeroed = lastStartPage;
            toZeros = (int)((long)toZeros - lastGap);
        }
        while (toZeros >= OS_PAGE_SIZE) {
            assert (PowerOf2Util.isAligned(lastZeroed, OS_PAGE_SIZE));
            long startPage = lastZeroed - (long)OS_PAGE_SIZE;
            PlatformDependent.setMemory(startPage, OS_PAGE_SIZE, (byte)0);
            lastZeroed = startPage;
            toZeros -= OS_PAGE_SIZE;
        }
        if (toZeros > 0) {
            PlatformDependent.setMemory(start, toZeros, (byte)0);
        }
        if ((position += count) > this.length) {
            this.length = position;
        }
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.checkCapacity(position);
        this.position = position;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            PlatformDependent.freeDirectBuffer(this.buffer);
        }
    }
}

