/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;

public class AMQPBrokerConnectionElement
implements Serializable {
    SimpleString matchAddress;
    SimpleString queueName;
    AMQPBrokerConnectionAddressType type;
    AMQPBrokerConnectConfiguration parent;

    public AMQPBrokerConnectConfiguration getParent() {
        return this.parent;
    }

    public AMQPBrokerConnectionElement setParent(AMQPBrokerConnectConfiguration parent) {
        this.parent = parent;
        return this;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public AMQPBrokerConnectionElement setQueueName(String queueName) {
        return this.setQueueName(SimpleString.toSimpleString(queueName));
    }

    public AMQPBrokerConnectionElement setQueueName(SimpleString queueName) {
        this.queueName = queueName;
        return this;
    }

    public SimpleString getMatchAddress() {
        return this.matchAddress;
    }

    public boolean match(SimpleString checkAddress, WildcardConfiguration wildcardConfig) {
        return AMQPBrokerConnectionElement.match(this.matchAddress, checkAddress, wildcardConfig);
    }

    public static boolean match(SimpleString matchAddressString, SimpleString checkAddressString, WildcardConfiguration wildcardConfig) {
        AddressImpl matchAddress = new AddressImpl(matchAddressString, wildcardConfig);
        AddressImpl checkAddress = new AddressImpl(checkAddressString, wildcardConfig);
        return checkAddress.matches(matchAddress);
    }

    public AMQPBrokerConnectionElement setMatchAddress(String matchAddress) {
        return this.setMatchAddress(SimpleString.toSimpleString(matchAddress));
    }

    public AMQPBrokerConnectionElement setMatchAddress(SimpleString matchAddress) {
        this.matchAddress = matchAddress;
        return this;
    }

    public AMQPBrokerConnectionAddressType getType() {
        return this.type;
    }

    public AMQPBrokerConnectionElement setType(AMQPBrokerConnectionAddressType type) {
        this.type = type;
        return this;
    }
}

