/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import io.Bytes;
import java.io.IOException;
import java.util.Random;
import mslinks.Serializable;

public class GUID
implements Serializable {
    private static Random r = new Random();
    private int d1;
    private short d2;
    private short d3;
    private short d4;
    private long d5;

    public GUID() {
        this.d1 = r.nextInt();
        this.d2 = (short)r.nextInt();
        this.d3 = (short)r.nextInt();
        this.d4 = (short)r.nextInt();
        this.d5 = r.nextLong() & 0xFFFFFFFFFFFFL;
    }

    public GUID(byte[] d) {
        this.d1 = Bytes.makeIntL(d[0], d[1], d[2], d[3]);
        this.d2 = Bytes.makeShortL(d[4], d[5]);
        this.d3 = Bytes.makeShortL(d[6], d[7]);
        this.d4 = Bytes.makeShortB(d[8], d[9]);
        this.d5 = Bytes.makeLongB((byte)0, (byte)0, d[10], d[11], d[12], d[13], d[14], d[15]);
    }

    public GUID(ByteReader data) throws IOException {
        this.d1 = (int)data.read4bytes();
        this.d2 = (short)data.read2bytes();
        this.d3 = (short)data.read2bytes();
        data.changeEndiannes();
        this.d4 = (short)data.read2bytes();
        this.d5 = data.read6bytes();
        data.changeEndiannes();
    }

    public GUID(String s2) {
        if (s2.charAt(0) == '{' && s2.charAt(s2.length() - 1) == '}') {
            s2 = s2.substring(1, s2.length() - 1);
        }
        String[] p = s2.split("-");
        byte[] b = this.parse(p[0]);
        this.d1 = Bytes.makeIntB(b[0], b[1], b[2], b[3]);
        b = this.parse(p[1]);
        this.d2 = Bytes.makeShortB(b[0], b[1]);
        b = this.parse(p[2]);
        this.d3 = Bytes.makeShortB(b[0], b[1]);
        this.d4 = (short)Long.parseLong(p[3], 16);
        this.d5 = Long.parseLong(p[4], 16);
    }

    private byte[] parse(String s2) {
        byte[] b = new byte[s2.length() >> 1];
        int i2 = 0;
        for (int j = 0; j < s2.length(); j += 2) {
            b[i2] = (byte)Long.parseLong(s2.substring(j, j + 2), 16);
            ++i2;
        }
        return b;
    }

    public String toString() {
        return String.format("%08X-%04X-%04X-%04X-%012X", this.d1, this.d2, this.d3, this.d4, this.d5);
    }

    public boolean equals(Object o) {
        GUID g2 = (GUID)o;
        return this.d1 == g2.d1 && this.d2 == g2.d2 && this.d3 == g2.d3 && this.d4 == g2.d4 && this.d5 == g2.d5;
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write4bytes(this.d1);
        bw.write2bytes(this.d2);
        bw.write2bytes(this.d3);
        bw.changeEndiannes();
        bw.write2bytes(this.d4);
        bw.write6bytes(this.d5);
        bw.changeEndiannes();
    }
}

