/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.togglebutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialToggleButtonUI
extends BasicToggleButtonUI {
    protected Boolean withoutIcon;
    protected JToggleButton toggleButton;
    protected Color withoutIconSelectedBackground;
    protected Color withoutIconSelectedForeground;
    protected Color withoutIconBackground;
    protected Color withoutIconForeground;
    protected Color disabledForeground;
    protected Icon selected;
    protected Icon unselected;
    protected Border withoutIconSelectedBorder;
    protected Border withoutIconBorder;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.toggleButton = (JToggleButton)c;
        this.disabledForeground = UIManager.getColor("RadioButton.disabledText");
        c.setCursor(Cursor.getPredefinedCursor(12));
        if (this.toggleButton.getIcon() == null && this.toggleButton.getSelectedIcon() == null) {
            this.unselected = new MaterialToggleButtonIcon(this.getPropertyPrefix());
            this.withoutIcon = UIManager.getBoolean("ToggleButton.withoutIcon");
            if (this.withoutIcon.booleanValue()) {
                this.withoutIconSelectedBorder = UIManager.getBorder("ToggleButton[withoutIcon].selectedBorder");
                this.withoutIconBorder = UIManager.getBorder("ToggleButton[withoutIcon].border");
                this.withoutIconSelectedBackground = UIManager.getColor("ToggleButton[withoutIcon].selectedBackground");
                this.withoutIconSelectedForeground = UIManager.getColor("ToggleButton[withoutIcon].selectedForeground");
                this.withoutIconBackground = UIManager.getColor("ToggleButton[withoutIcon].background");
                this.withoutIconForeground = UIManager.getColor("ToggleButton[withoutIcon].foreground");
                if (this.toggleButton.isSelected()) {
                    LookAndFeel.installBorder(this.toggleButton, "ToggleButton[withoutIcon].background");
                } else {
                    LookAndFeel.installBorder(this.toggleButton, "ToggleButton[withoutIcon].selectedForeground");
                }
            } else {
                this.toggleButton.setIcon(this.unselected);
                LookAndFeel.installBorder(this.toggleButton, "ToggleButton.border");
            }
        } else {
            LookAndFeel.installBorder(this.toggleButton, "ToggleButton.border");
            this.withoutIcon = Boolean.FALSE;
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        boolean removeIcon;
        super.uninstallUI(c);
        JToggleButton toggleButton = (JToggleButton)c;
        boolean bl = removeIcon = this.unselected == toggleButton.getIcon() && this.selected == toggleButton.getSelectedIcon();
        if (removeIcon) {
            toggleButton.setIcon(null);
            toggleButton.setSelectedIcon(null);
        }
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
        if (this.withoutIcon != null && this.withoutIcon.booleanValue() && this.isNotNullColor(this.withoutIcon)) {
            AbstractButton button = (AbstractButton)c;
            if (button.isSelected()) {
                button.setBackground(this.withoutIconSelectedBackground);
                button.setForeground(this.withoutIconSelectedForeground);
                button.setBorder(this.withoutIconSelectedBorder);
            } else {
                button.setBackground(this.withoutIconBackground);
                button.setForeground(this.withoutIconForeground);
                button.setBorder(this.withoutIconBorder);
            }
        }
    }

    private boolean isNotNullColor(boolean withoutIcon) {
        if (withoutIcon) {
            boolean selectedColorNotNull = this.withoutIconSelectedBackground != null && this.withoutIconSelectedForeground != null;
            boolean unselectColorNotNull = this.withoutIconBackground != null && this.withoutIconForeground != null;
            boolean borderNotNull = this.withoutIconBorder != null && this.withoutIconSelectedBorder != null;
            return selectedColorNotNull && unselectColorNotNull && borderNotNull;
        }
        return true;
    }

    @Override
    protected void paintFocus(Graphics g2, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void paintText(Graphics g2, JComponent c, Rectangle textRect, String text) {
        ButtonModel model = this.toggleButton.getModel();
        if (model.isEnabled()) {
            MaterialDrawingUtils.drawString(c, g2, text, textRect, this.toggleButton.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), this.toggleButton.getForeground());
            return;
        }
        MaterialDrawingUtils.drawString(c, g2, text, textRect, this.toggleButton.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), this.disabledForeground);
    }

    protected class MaterialToggleButtonIcon
    implements Icon,
    UIResource {
        protected Icon unselectedIcon;
        protected Icon selectedIcon;
        protected Icon disabledIcon;
        protected Icon disabledSelectedIcon;

        public MaterialToggleButtonIcon(String componentPrefix) {
            this.unselectedIcon = UIManager.getIcon(componentPrefix + "icon");
            this.selectedIcon = UIManager.getIcon(componentPrefix + "selectedIcon");
            this.disabledIcon = UIManager.getIcon(componentPrefix + "disabledIcon");
            this.disabledSelectedIcon = UIManager.getIcon(componentPrefix + "disabledSelectedIcon");
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            if (MaterialToggleButtonUI.this.toggleButton.isEnabled()) {
                if (MaterialToggleButtonUI.this.toggleButton.isSelected()) {
                    this.selectedIcon.paintIcon(c, g2, x, y);
                } else {
                    this.unselectedIcon.paintIcon(c, g2, x, y);
                }
            } else if (MaterialToggleButtonUI.this.toggleButton.isSelected()) {
                this.disabledSelectedIcon.paintIcon(c, g2, x, y);
            } else {
                this.disabledIcon.paintIcon(c, g2, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.selectedIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.selectedIcon.getIconHeight();
        }
    }
}

