/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.slider;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialSliderUI
extends BasicSliderUI {
    private static final int NORMAL_THUMB_RADIUS = 7;
    private static final int DRAG_THUMB_RADIUS = 14;
    private static final Dimension THUMB_SIZE = new Dimension(28, 28);

    public MaterialSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialSliderUI((JSlider)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public Dimension getThumbSize() {
        return THUMB_SIZE;
    }

    @Override
    public void paintThumb(Graphics g2) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        int cx = this.thumbRect.x + this.thumbRect.width / 2;
        int cy = this.thumbRect.y + this.thumbRect.height / 2;
        if (this.isDragging()) {
            g2.setColor(UIManager.getColor("Slider[halo].color"));
            this.drawCircle(g2, cx, cy, 14);
        }
        if (this.slider.isEnabled()) {
            g2.setColor(this.slider.getForeground());
        } else {
            g2.setColor(UIManager.getColor("Slider.disable"));
        }
        this.drawCircle(g2, cx, cy, 7);
        Line loaded = this.getTrack(true);
        g2.drawLine(loaded.x1, loaded.y1, loaded.x2, loaded.y2);
    }

    @Override
    public void paintTrack(Graphics g2) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        g2.setColor(UIManager.getColor("Slider.trackColor"));
        g2.setColor(UIManager.getColor("Slider.disableTrackColor"));
        Line unloaded = this.getTrack(false);
        g2.drawLine(unloaded.x1, unloaded.y1, unloaded.x2, unloaded.y2);
        if (this.slider.isEnabled()) {
            g2.setColor(this.slider.getForeground());
        } else {
            g2.setColor(UIManager.getColor("Slider.disable"));
        }
        Line loaded = this.getTrack(true);
        g2.drawLine(loaded.x1, loaded.y1, loaded.x2, loaded.y2);
    }

    private Line getTrack(boolean loaded) {
        if (this.slider.getOrientation() == 0) {
            Line left = new Line(this.trackRect.x, this.thumbRect.y + this.thumbRect.height / 2, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2);
            Line right = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2, this.trackRect.x + this.trackRect.width, this.thumbRect.y + this.thumbRect.height / 2);
            if (loaded) {
                return this.slider.getInverted() ? right : left;
            }
            return this.slider.getInverted() ? left : right;
        }
        Line top = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.trackRect.y, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2);
        Line bottom = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2, this.thumbRect.x + this.thumbRect.width / 2, this.trackRect.y + this.trackRect.height);
        if (loaded) {
            return this.slider.getInverted() ? top : bottom;
        }
        return this.slider.getInverted() ? bottom : top;
    }

    @Override
    public void paintFocus(Graphics g2) {
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g2), c);
    }

    protected void drawCircle(Graphics g2, int x, int y, int radius) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        g2.fillOval(x - radius, y - radius, radius * 2, radius * 2);
    }

    private static class Line {
        int x1;
        int y1;
        int x2;
        int y2;

        Line(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }
}

