/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.scrollbar;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.components.button.MaterialButtonUI;
import mdlaf.utils.MaterialDrawingUtils;
import mdlaf.utils.MaterialImageFactory;
import mdlaf.utils.MaterialManagerListener;

public class MaterialScrollBarUI
extends BasicScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialScrollBarUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g2), c);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.installButton(orientation);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.installButton(orientation);
    }

    @Override
    protected void paintTrack(Graphics g2, JComponent c, Rectangle trackBounds) {
        super.paintTrack(g2, c, trackBounds);
        g2.setColor(UIManager.getColor("ScrollBar.track"));
    }

    @Override
    protected void paintThumb(Graphics g2, JComponent c, Rectangle thumbBounds) {
        super.paintThumb(g2, c, thumbBounds);
        g2.setColor(UIManager.getColor("ScrollBar.thumb"));
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
    }

    protected void setIconArrowButton(JButton button, int orientation) {
        if (button == null) {
            throw new IllegalArgumentException("Input null");
        }
        if (orientation == 1) {
            button.setIcon(MaterialImageFactory.getInstance().getImage("up_arrow"));
            return;
        }
        if (orientation == 5) {
            button.setIcon(MaterialImageFactory.getInstance().getImage("down_arrow"));
            return;
        }
        if (orientation == 3) {
            button.setIcon(MaterialImageFactory.getInstance().getImage("right_arrow"));
            return;
        }
        if (orientation == 7) {
            button.setIcon(MaterialImageFactory.getInstance().getImage("left_arrow"));
            return;
        }
        throw new IllegalArgumentException("orientation not valid");
    }

    protected void createInvisibleButton(JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument function null");
        }
        component.setPreferredSize(new Dimension(0, 0));
        component.setMinimumSize(new Dimension(0, 0));
        component.setMaximumSize(new Dimension(0, 0));
    }

    protected JButton installButton(int orientation) {
        JButton button = new JButton();
        MaterialManagerListener.removeAllMaterialMouseListener(button);
        button.setUI(new MaterialButtonUI());
        button.setOpaque(true);
        button.setFocusable(false);
        button.setBackground(UIManager.getColor("ScrollBar.arrowButtonBackground"));
        if (!UIManager.getBoolean("ScrollBar.enableArrow")) {
            this.createInvisibleButton(button);
            return button;
        }
        this.setIconArrowButton(button, orientation);
        if (UIManager.getBoolean("ScrollBar[MouseHover].enable")) {
            button.addMouseListener(MaterialUIMovement.getStaticMovement(button, UIManager.getColor("ScrollBar[MouseHover].color"), UIManager.getColor("ScrollBar[OnClick].color")));
        }
        button.setBorder(UIManager.getBorder("ScrollBar.arrowButtonBorder"));
        return button;
    }
}

