/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.checkbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import mdlaf.animation.MaterialMouseHover;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialCheckBoxUI
extends BasicCheckBoxUI {
    protected JCheckBox checkBox;
    protected Color disabledForeground;
    protected boolean isHover;
    protected boolean mouseHoverEnable;
    protected Color hoverColor;
    protected MaterialMouseHover mouseHover;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.checkBox = (JCheckBox)c;
        c.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.icon = new MaterialCheckBoxIcon(this.getPropertyPrefix());
        this.mouseHoverEnable = UIManager.getBoolean(this.getPropertyPrefix() + "mouseHoverEnabled");
        this.hoverColor = UIManager.getColor(this.getPropertyPrefix() + "mouseHoverColor");
        this.disabledForeground = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        if (this.mouseHoverEnable) {
            this.mouseHover = new MouseHoverEvent();
        }
    }

    @Override
    public synchronized void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
    }

    @Override
    protected void paintText(Graphics g2, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isEnabled()) {
            MaterialDrawingUtils.drawString(c, g2, text, textRect, b.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), b.getForeground());
        } else {
            MaterialDrawingUtils.drawString(c, g2, text, textRect, b.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), this.disabledForeground);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        this.hoverColor = null;
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
    }

    protected class MaterialCheckBoxIcon
    implements Icon,
    UIResource {
        protected Icon unselectedIcon;
        protected Icon selectedIcon;
        protected Icon disabledIcon;
        protected Icon disabledSelectedIcon;

        public MaterialCheckBoxIcon(String componentPrefix) {
            this.unselectedIcon = UIManager.getIcon(componentPrefix + "icon");
            this.selectedIcon = UIManager.getIcon(componentPrefix + "selectedIcon");
            this.disabledIcon = UIManager.getIcon(componentPrefix + "disabledIcon");
            this.disabledSelectedIcon = UIManager.getIcon(componentPrefix + "disabledSelectedIcon");
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            if (MaterialCheckBoxUI.this.checkBox.isEnabled()) {
                if (MaterialCheckBoxUI.this.checkBox.isSelected()) {
                    this.selectedIcon.paintIcon(c, g2, x, y);
                } else {
                    this.unselectedIcon.paintIcon(c, g2, x, y);
                }
            } else if (MaterialCheckBoxUI.this.checkBox.isSelected()) {
                this.disabledSelectedIcon.paintIcon(c, g2, x, y);
            } else {
                this.disabledIcon.paintIcon(c, g2, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.unselectedIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.unselectedIcon.getIconHeight();
        }
    }

    protected class MouseHoverEvent
    implements MaterialMouseHover {
        protected MouseHoverEvent() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MaterialCheckBoxUI.this.isHover = true;
            MaterialCheckBoxUI.this.checkBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MaterialCheckBoxUI.this.isHover = false;
            MaterialCheckBoxUI.this.checkBox.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public boolean isRunning() {
            return MaterialCheckBoxUI.this.isHover;
        }
    }
}

