/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import de.griefed.versionchecker.ArchiveType;
import de.griefed.versionchecker.ReleaseAsset;
import de.griefed.versionchecker.Source;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Update {
    private final String VERSION;
    private final String DESCRIPTION;
    private final URL LINK;
    private final LocalDate RELEASE_DATE;
    private final List<ReleaseAsset> ASSETS;
    private final List<Source> SOURCES;

    public Update(@NotNull String version, @Nullable String description, @NotNull URL link, @NotNull LocalDate releaseDate, @Nullable List<ReleaseAsset> assets, @NotNull List<Source> sources) {
        this.VERSION = version;
        this.DESCRIPTION = description;
        this.LINK = link;
        this.RELEASE_DATE = releaseDate;
        this.ASSETS = assets;
        this.SOURCES = sources;
    }

    public String version() {
        return this.VERSION;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.DESCRIPTION);
    }

    public URL url() {
        return this.LINK;
    }

    public LocalDate releaseDate() {
        return this.RELEASE_DATE;
    }

    public Optional<List<ReleaseAsset>> assets() {
        return Optional.ofNullable(this.ASSETS);
    }

    public List<Source> sources() {
        return this.SOURCES;
    }

    public Source sourceZip() {
        for (Source source : this.SOURCES) {
            if (source.type() != ArchiveType.ZIP) continue;
            return source;
        }
        return null;
    }

    public Source sourceTarGz() {
        for (Source source : this.SOURCES) {
            if (source.type() != ArchiveType.TAR_GZ) continue;
            return source;
        }
        return null;
    }

    public Optional<Source> sourceTar() {
        for (Source source : this.SOURCES) {
            if (source.type() != ArchiveType.TAR) continue;
            return Optional.of(source);
        }
        return Optional.empty();
    }

    public Optional<Source> sourceTarBz2() {
        for (Source source : this.SOURCES) {
            if (source.type() != ArchiveType.TAR_BZ2) continue;
            return Optional.of(source);
        }
        return Optional.empty();
    }

    public Optional<ReleaseAsset> getReleaseAsset(@NotNull String releaseName) {
        if (this.ASSETS == null) {
            return Optional.empty();
        }
        for (ReleaseAsset releaseAsset : this.ASSETS) {
            if (!releaseAsset.name().equals(releaseName)) continue;
            return Optional.of(releaseAsset);
        }
        return Optional.empty();
    }
}

