/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.quilt;

import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.Manifests;
import de.griefed.serverpackcreator.versionmeta.Meta;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediaries;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltInstaller;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class QuiltMeta
extends Manifests
implements Meta {
    private final File QUILT_MANIFEST;
    private final File QUILT_INSTALLER_MANIFEST;
    private final QuiltLoader QUILT_LOADER;
    private final QuiltInstaller QUILT_INSTALLER;
    private final FabricIntermediaries FABRIC_INTERMEDIARIES;

    public QuiltMeta(File quiltManifest, File quiltInstallerManifest, FabricIntermediaries injectedFabricIntermediaries) throws ParserConfigurationException, IOException, SAXException {
        this.QUILT_MANIFEST = quiltManifest;
        this.QUILT_INSTALLER_MANIFEST = quiltInstallerManifest;
        this.QUILT_LOADER = new QuiltLoader(this.getXml(this.QUILT_MANIFEST));
        this.QUILT_INSTALLER = new QuiltInstaller(this.getXml(this.QUILT_INSTALLER_MANIFEST));
        this.FABRIC_INTERMEDIARIES = injectedFabricIntermediaries;
    }

    @Override
    public void update() throws IOException, ParserConfigurationException, SAXException {
        this.QUILT_LOADER.update(this.getXml(this.QUILT_MANIFEST));
        this.QUILT_INSTALLER.update(this.getXml(this.QUILT_INSTALLER_MANIFEST));
    }

    @Override
    public String latestLoader() {
        return this.QUILT_LOADER.latestLoaderVersion();
    }

    @Override
    public String releaseLoader() {
        return this.QUILT_LOADER.releaseLoaderVersion();
    }

    @Override
    public List<String> loaderVersionsListAscending() {
        return this.QUILT_LOADER.loaders();
    }

    @Override
    public List<String> loaderVersionsListDescending() {
        return Lists.reverse(this.QUILT_LOADER.loaders());
    }

    @Override
    public String[] loaderVersionsArrayAscending() {
        return this.QUILT_LOADER.loaders().toArray(new String[0]);
    }

    @Override
    public String[] loaderVersionsArrayDescending() {
        return Lists.reverse(this.QUILT_LOADER.loaders()).toArray(new String[0]);
    }

    @Override
    public String latestInstaller() {
        return this.QUILT_INSTALLER.latestInstallerVersion();
    }

    @Override
    public String releaseInstaller() {
        return this.QUILT_INSTALLER.releaseInstallerVersion();
    }

    @Override
    public List<String> installerVersionsListAscending() {
        return this.QUILT_INSTALLER.installers();
    }

    @Override
    public List<String> installerVersionsListDescending() {
        return Lists.reverse(this.QUILT_INSTALLER.installers());
    }

    @Override
    public String[] installerVersionsArrayAscending() {
        return this.QUILT_INSTALLER.installers().toArray(new String[0]);
    }

    @Override
    public String[] installerVersionsArrayDescending() {
        return Lists.reverse(this.QUILT_INSTALLER.installers()).toArray(new String[0]);
    }

    @Override
    public URL latestInstallerUrl() {
        return this.QUILT_INSTALLER.latestInstallerUrl();
    }

    @Override
    public URL releaseInstallerUrl() {
        return this.QUILT_INSTALLER.releaseInstallerUrl();
    }

    @Override
    public boolean isInstallerUrlAvailable(String quiltVersion) {
        return Optional.ofNullable(this.QUILT_INSTALLER.meta().get(quiltVersion)).isPresent();
    }

    @Override
    public Optional<URL> getInstallerUrl(String quiltVersion) {
        return Optional.ofNullable(this.QUILT_INSTALLER.meta().get(quiltVersion));
    }

    @Override
    public boolean isVersionValid(String quiltVersion) {
        return this.QUILT_LOADER.loaders().contains(quiltVersion);
    }

    @Override
    public boolean isMinecraftSupported(String minecraftVersion) {
        return this.FABRIC_INTERMEDIARIES.areIntermediariesPresent(minecraftVersion);
    }
}

