/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftClient;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftClientMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftServer;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftServerMeta;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class MinecraftMeta {
    private final MinecraftClientMeta MINECRAFT_CLIENT_META;
    private final MinecraftServerMeta MINECRAFT_SERVER_META;

    public MinecraftMeta(File minecraftManifest, ForgeMeta injectedForgeMeta, ObjectMapper objectMapper) {
        this.MINECRAFT_CLIENT_META = new MinecraftClientMeta(minecraftManifest, injectedForgeMeta, objectMapper);
        this.MINECRAFT_SERVER_META = new MinecraftServerMeta(this.MINECRAFT_CLIENT_META);
    }

    public void update() throws IOException {
        this.MINECRAFT_CLIENT_META.update();
        this.MINECRAFT_SERVER_META.update();
    }

    public boolean checkMinecraftVersion(String minecraftVersion) {
        return this.getClient(minecraftVersion).isPresent();
    }

    public List<String> releaseVersionsDescending() {
        ArrayList<String> list = new ArrayList<String>();
        this.releasesDescending().forEach(client -> list.add(client.version()));
        return list;
    }

    public List<String> releaseVersionsAscending() {
        ArrayList list = new ArrayList();
        this.releasesDescending().forEach(client -> list.add(client.version()));
        return Lists.reverse(list);
    }

    public String[] releaseVersionsArrayDescending() {
        return this.releaseVersionsDescending().toArray(new String[0]);
    }

    public String[] releaseVersionsArrayAscending() {
        return this.releaseVersionsAscending().toArray(new String[0]);
    }

    public List<String> snapshotVersionsDescending() {
        ArrayList<String> list = new ArrayList<String>();
        this.snapshotsDescending().forEach(client -> list.add(client.version()));
        return list;
    }

    public List<String> snapshotVersionsAscending() {
        ArrayList list = new ArrayList();
        this.snapshotsDescending().forEach(client -> list.add(client.version()));
        return Lists.reverse(list);
    }

    public String[] snapshotVersionsArrayDescending() {
        return this.snapshotVersionsDescending().toArray(new String[0]);
    }

    public String[] snapshotVersionsArrayAscending() {
        return this.snapshotVersionsAscending().toArray(new String[0]);
    }

    public String[] allVersionsArrayDescending() {
        return this.allVersionsDescending().toArray(new String[0]);
    }

    public String[] allVersionsArrayAscending() {
        return this.allVersionsAscending().toArray(new String[0]);
    }

    public List<String> allVersionsDescending() {
        ArrayList<String> versions = new ArrayList<String>();
        this.allDescending().forEach(client -> versions.add(client.version()));
        return versions;
    }

    public List<String> allVersionsAscending() {
        ArrayList<String> versions = new ArrayList<String>(this.releaseVersionsAscending());
        this.allAscending().forEach(client -> versions.add(client.version()));
        return versions;
    }

    public MinecraftClient latestRelease() {
        return this.MINECRAFT_CLIENT_META.latestRelease();
    }

    public MinecraftClient latestSnapshot() {
        return this.MINECRAFT_CLIENT_META.latestSnapshot();
    }

    public Optional<MinecraftClient> getClient(String minecraftVersion) {
        return Optional.ofNullable(this.MINECRAFT_CLIENT_META.meta().get(minecraftVersion));
    }

    public List<MinecraftClient> releasesDescending() {
        return this.MINECRAFT_CLIENT_META.releases();
    }

    public List<MinecraftClient> releasesAscending() {
        return Lists.reverse(this.MINECRAFT_CLIENT_META.releases());
    }

    public MinecraftClient[] releasesArrayDescending() {
        return this.releasesDescending().toArray(new MinecraftClient[0]);
    }

    public MinecraftClient[] releasesArrayAscending() {
        return this.releasesAscending().toArray(new MinecraftClient[0]);
    }

    public List<MinecraftClient> snapshotsDescending() {
        return this.MINECRAFT_CLIENT_META.snapshots();
    }

    public List<MinecraftClient> snapshotsAscending() {
        return Lists.reverse(this.MINECRAFT_CLIENT_META.snapshots());
    }

    public MinecraftClient[] snapshotsArrayDescending() {
        return this.snapshotsDescending().toArray(new MinecraftClient[0]);
    }

    public MinecraftClient[] snapshotsArrayAscending() {
        return this.snapshotsAscending().toArray(new MinecraftClient[0]);
    }

    public List<MinecraftClient> allDescending() {
        return this.MINECRAFT_CLIENT_META.all();
    }

    public List<MinecraftClient> allAscending() {
        return Lists.reverse(this.MINECRAFT_CLIENT_META.all());
    }

    public MinecraftClient[] allDescendingArray() {
        return this.allDescending().toArray(new MinecraftClient[0]);
    }

    public MinecraftClient[] allAscendingArray() {
        return this.allAscending().toArray(new MinecraftClient[0]);
    }

    public Optional<MinecraftServer> getServer(String minecraftVersion) {
        try {
            if (this.MINECRAFT_SERVER_META.meta().get(minecraftVersion).url().isPresent() && this.MINECRAFT_SERVER_META.meta().get(minecraftVersion).javaVersion().isPresent()) {
                return Optional.ofNullable(this.MINECRAFT_SERVER_META.meta().get(minecraftVersion));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public boolean checkServerAvailability(String minecraftVersion) {
        return this.getServer(minecraftVersion).isPresent();
    }

    public MinecraftServer latestReleaseServer() {
        return this.MINECRAFT_CLIENT_META.latestRelease().server();
    }

    public MinecraftServer latestSnapshotServer() {
        return this.MINECRAFT_CLIENT_META.latestSnapshot().server();
    }

    public List<MinecraftServer> releasesServersDescending() {
        return this.MINECRAFT_SERVER_META.releases();
    }

    public List<MinecraftServer> releasesServersAscending() {
        return Lists.reverse(this.MINECRAFT_SERVER_META.releases());
    }

    public MinecraftServer[] releasesServersArrayDescending() {
        return this.releasesServersDescending().toArray(new MinecraftServer[0]);
    }

    public MinecraftServer[] releasesServersArrayAscending() {
        return this.releasesServersAscending().toArray(new MinecraftServer[0]);
    }

    public List<MinecraftServer> snapshotsServersDescending() {
        return this.MINECRAFT_SERVER_META.snapshots();
    }

    public List<MinecraftServer> snapshotsServersAscending() {
        return Lists.reverse(this.MINECRAFT_SERVER_META.snapshots());
    }

    public MinecraftServer[] snapshotsServersArrayDescending() {
        return this.snapshotsServersDescending().toArray(new MinecraftServer[0]);
    }

    public MinecraftServer[] snapshotsServersArrayAscending() {
        return this.snapshotsServersAscending().toArray(new MinecraftServer[0]);
    }
}

