/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.legacyfabric;

import de.griefed.serverpackcreator.versionmeta.Manifests;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class LegacyFabricInstaller
extends Manifests {
    private final File MANIFEST;
    private final List<String> ALL = new ArrayList<String>();
    private final String INSTALLER_URL_TEMPLATE = "https://maven.legacyfabric.net/net/legacyfabric/fabric-installer/%s/fabric-installer-%s.jar";
    private String latest;
    private String release;

    public LegacyFabricInstaller(File installerVersionsManifest) throws ParserConfigurationException, IOException, SAXException {
        this.MANIFEST = installerVersionsManifest;
        this.update();
    }

    void update() throws ParserConfigurationException, IOException, SAXException {
        Document installerManifest = this.getXml(this.MANIFEST);
        this.latest = installerManifest.getElementsByTagName("latest").item(0).getChildNodes().item(0).getNodeValue();
        this.release = installerManifest.getElementsByTagName("release").item(0).getChildNodes().item(0).getNodeValue();
        this.ALL.clear();
        for (int i2 = 0; i2 < installerManifest.getElementsByTagName("version").getLength(); ++i2) {
            this.ALL.add(installerManifest.getElementsByTagName("version").item(i2).getChildNodes().item(0).getNodeValue());
        }
    }

    public List<String> all() {
        return this.ALL;
    }

    public String latest() {
        return this.latest;
    }

    public String release() {
        return this.release;
    }

    public URL latestURL() throws MalformedURLException {
        return new URL(String.format("https://maven.legacyfabric.net/net/legacyfabric/fabric-installer/%s/fabric-installer-%s.jar", this.latest, this.latest));
    }

    public URL releaseURL() throws MalformedURLException {
        return new URL(String.format("https://maven.legacyfabric.net/net/legacyfabric/fabric-installer/%s/fabric-installer-%s.jar", this.release, this.latest));
    }

    public Optional<URL> specificURL(String version) throws MalformedURLException {
        if (this.ALL.contains(version)) {
            return Optional.of(new URL(String.format("https://maven.legacyfabric.net/net/legacyfabric/fabric-installer/%s/fabric-installer-%s.jar", version, version)));
        }
        return Optional.empty();
    }
}

